/*
 * Decompiled with CFR 0.152.
 */
package pixlepix.auracascade.block.tile;

import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import pixlepix.auracascade.AuraCascade;
import pixlepix.auracascade.block.entity.EntityMinerExplosion;
import pixlepix.auracascade.block.tile.ConsumerTile;
import pixlepix.auracascade.data.OreDropManager;
import pixlepix.auracascade.main.AuraUtil;

public class MinerTile
extends ConsumerTile {
    public EntityMinerExplosion explosion;
    public boolean hasBeenPulsed = false;

    @Override
    public void readCustomNBT(NBTTagCompound nbt) {
        super.readCustomNBT(nbt);
        if (nbt.func_74764_b("explosion")) {
            this.explosion = (EntityMinerExplosion)this.field_145850_b.func_73045_a(nbt.func_74762_e("explosion"));
            nbt.func_74757_a("hasBeenPulsed", this.hasBeenPulsed);
        }
    }

    @Override
    public void writeCustomNBT(NBTTagCompound nbt) {
        super.writeCustomNBT(nbt);
        if (this.explosion != null) {
            nbt.func_74768_a("explosion", this.explosion.func_145782_y());
            nbt.func_74757_a("hasBeenPulsed", this.hasBeenPulsed);
        }
    }

    @Override
    public int getMaxProgress() {
        return 1;
    }

    @Override
    public int getPowerPerProgress() {
        return 2500;
    }

    @Override
    public boolean validItemsNearby() {
        return true;
    }

    @Override
    public void func_145845_h() {
        if (this.field_145850_b.func_72864_z(this.field_145851_c, this.field_145848_d, this.field_145849_e)) {
            this.hasBeenPulsed = true;
        }
        super.func_145845_h();
    }

    @Override
    public void onUsePower() {
        AuraCascade.analytics.eventDesign("consumerMiner", AuraUtil.formatLocation(this));
        if (!this.hasBeenPulsed) {
            if (this.explosion != null && !this.explosion.field_70128_L) {
                ++this.explosion.charge;
                this.explosion.lastCharged = this.field_145850_b.func_82737_E();
            } else {
                this.explosion = new EntityMinerExplosion(this.field_145850_b);
                this.explosion.func_70107_b((double)this.field_145851_c + 0.5, (double)this.field_145848_d - 1.5, (double)this.field_145849_e + 0.5);
                this.explosion.charge = 1;
                this.explosion.lastCharged = this.field_145850_b.func_82737_E();
                this.explosion.bounce();
                this.field_145850_b.func_72838_d((Entity)this.explosion);
            }
        } else {
            if (this.explosion != null && !this.explosion.field_70128_L) {
                this.explosion.func_70106_y();
                if (this.field_145850_b.field_72995_K) {
                    this.field_145850_b.func_72869_a("hugeexplosion", this.explosion.field_70165_t, this.explosion.field_70163_u, this.explosion.field_70161_v, 0.0, 0.0, 0.0);
                } else if (this.explosion.charge > 20) {
                    int oresSpawned = (int)(Math.pow(this.explosion.charge, 1.5) / 50.0);
                    for (int i = 0; i < oresSpawned; ++i) {
                        ItemStack stack = OreDropManager.getOreToPut();
                        EntityItem item = new EntityItem(this.field_145850_b, (double)this.field_145851_c + 0.5, (double)this.field_145848_d + 1.5, (double)this.field_145849_e + 0.5, stack);
                        this.field_145850_b.func_72838_d((Entity)item);
                    }
                    AuraCascade.analytics.eventDesign("consumerMinerLoot", AuraUtil.formatLocation(this), this.explosion.charge);
                }
            }
            this.hasBeenPulsed = false;
        }
    }
}

