/*
 * Decompiled with CFR 0.152.
 */
package pixlepix.auracascade.block.tile;

import net.minecraft.block.Block;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S35PacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.util.ForgeDirection;
import pixlepix.auracascade.block.BlockMonitor;
import pixlepix.auracascade.block.tile.AuraTile;
import pixlepix.auracascade.data.CoordTuple;
import pixlepix.auracascade.data.EnumAura;
import pixlepix.auracascade.main.AuraUtil;

public abstract class ConsumerTile
extends TileEntity {
    public int storedPower;
    public int lastPower;
    public int progress;
    private boolean lastValidState;

    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.readCustomNBT(nbt);
    }

    public abstract int getMaxProgress();

    public abstract int getPowerPerProgress();

    public void readCustomNBT(NBTTagCompound nbt) {
        this.progress = nbt.func_74762_e("progress");
        this.storedPower = nbt.func_74762_e("storedPower");
        this.lastPower = nbt.func_74762_e("lastPower");
    }

    public abstract boolean validItemsNearby();

    public void writeCustomNBT(NBTTagCompound nbt) {
        nbt.func_74768_a("progress", this.progress);
        nbt.func_74768_a("storedPower", this.storedPower);
        nbt.func_74768_a("lastPower", this.lastPower);
    }

    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        this.writeCustomNBT(nbt);
    }

    public Packet func_145844_m() {
        NBTTagCompound nbt = new NBTTagCompound();
        this.writeCustomNBT(nbt);
        return new S35PacketUpdateTileEntity(this.field_145851_c, this.field_145848_d, this.field_145849_e, -999, nbt);
    }

    public void onDataPacket(NetworkManager net, S35PacketUpdateTileEntity pkt) {
        this.readCustomNBT(pkt.func_148857_g());
    }

    public void updateMonitor() {
        for (ForgeDirection d1 : ForgeDirection.VALID_DIRECTIONS) {
            Block b = new CoordTuple(this).add(d1).getBlock(this.field_145850_b);
            if (!(b instanceof BlockMonitor)) continue;
            for (ForgeDirection d2 : ForgeDirection.VALID_DIRECTIONS) {
                CoordTuple tuple = new CoordTuple(this).add(d2).add(d1);
                Block b2 = tuple.getBlock(this.field_145850_b);
                b2.func_149695_a(this.field_145850_b, tuple.getX(), tuple.getY(), tuple.getZ(), b);
            }
        }
    }

    public void func_145845_h() {
        super.func_145845_h();
        if (!this.field_145850_b.field_72995_K) {
            if (this.field_145850_b.func_82737_E() % 20L == 18L) {
                this.storedPower = (int)((double)this.storedPower * 0.25);
            }
            if (this.field_145850_b.func_82737_E() % 20L == 0L && this.lastValidState != this.validItemsNearby()) {
                this.lastValidState = !this.lastValidState;
                this.updateMonitor();
            }
            boolean changeLastPower = false;
            for (ForgeDirection direction : ForgeDirection.VALID_DIRECTIONS) {
                TileEntity tileEntity = this.field_145850_b.func_147438_o(this.field_145851_c + direction.offsetX, this.field_145848_d + direction.offsetY, this.field_145849_e + direction.offsetZ);
                if (!(tileEntity instanceof AuraTile)) continue;
                AuraTile auraTile = (AuraTile)tileEntity;
                if (auraTile.energy <= 0) continue;
                auraTile.burst(new CoordTuple(this), "magicCrit", EnumAura.WHITE_AURA, 1.0);
                this.storedPower += auraTile.energy;
                auraTile.energy = 0;
                changeLastPower = true;
            }
            if (this.field_145850_b.func_82737_E() % 20L == 0L) {
                this.lastPower = 0;
            }
            if (changeLastPower) {
                this.lastPower = this.storedPower;
                this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
            } else if (this.field_145850_b.func_82737_E() % 20L == 2L) {
                this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
            }
            if (this.field_145850_b.func_82737_E() % 500L == 0L) {
                AuraUtil.keepAlive(this, 3);
            }
            if (this.field_145850_b.func_82737_E() % 20L == 1L || this.field_145850_b.func_82737_E() % 20L == 2L) {
                int nextBoostCost = this.getPowerPerProgress();
                while (true) {
                    if (this.progress > this.getMaxProgress()) {
                        this.progress = 0;
                        this.onUsePower();
                        this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
                    }
                    if (this.storedPower < nextBoostCost) break;
                    ++this.progress;
                    this.storedPower -= nextBoostCost;
                    nextBoostCost *= 2;
                    this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
                    this.field_145850_b.func_147444_c(this.field_145851_c, this.field_145848_d, this.field_145849_e, this.field_145850_b.func_147439_a(this.field_145851_c, this.field_145848_d, this.field_145849_e));
                }
            }
        }
    }

    public abstract void onUsePower();
}

