/*
 * Decompiled with CFR 0.152.
 */
package pixlepix.auracascade.block;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;
import pixlepix.auracascade.block.tile.AngelSteelTile;
import pixlepix.auracascade.block.tile.ConsumerTile;
import pixlepix.auracascade.block.tile.DyeTile;
import pixlepix.auracascade.block.tile.EnchanterTile;
import pixlepix.auracascade.block.tile.FisherTile;
import pixlepix.auracascade.block.tile.FurnaceTile;
import pixlepix.auracascade.block.tile.LootTile;
import pixlepix.auracascade.block.tile.MinerTile;
import pixlepix.auracascade.block.tile.PlanterTile;
import pixlepix.auracascade.block.tile.PotionTile;
import pixlepix.auracascade.block.tile.ProcessorTile;
import pixlepix.auracascade.block.tile.ProcessorTileAdv;
import pixlepix.auracascade.block.tile.SpawnTile;
import pixlepix.auracascade.block.tile.TileRitualEnd;
import pixlepix.auracascade.block.tile.TileRitualNether;
import pixlepix.auracascade.data.AuraQuantity;
import pixlepix.auracascade.data.EnumAura;
import pixlepix.auracascade.data.IToolTip;
import pixlepix.auracascade.data.recipe.PylonRecipe;
import pixlepix.auracascade.data.recipe.PylonRecipeComponent;
import pixlepix.auracascade.item.ItemAuraCrystal;
import pixlepix.auracascade.item.ItemMaterial;
import pixlepix.auracascade.item.ItemRedHole;
import pixlepix.auracascade.main.AuraUtil;
import pixlepix.auracascade.registry.BlockRegistry;
import pixlepix.auracascade.registry.CraftingBenchRecipe;
import pixlepix.auracascade.registry.ITTinkererBlock;
import pixlepix.auracascade.registry.ThaumicTinkererRecipe;

public class ConsumerBlock
extends Block
implements IToolTip,
ITTinkererBlock,
ITileEntityProvider {
    public String name;
    public IIcon front;
    public IIcon side;
    public IIcon top;

    public ConsumerBlock() {
        super(Material.field_151573_f);
        this.name = "furnace";
        this.func_149711_c(2.0f);
    }

    public ConsumerBlock(String name) {
        super(Material.field_151573_f);
        this.name = name;
        this.func_149711_c(2.0f);
    }

    public static ConsumerBlock getBlockFromName(String name) {
        ArrayList<Block> blockList = BlockRegistry.getBlockFromClass(ConsumerBlock.class);
        for (Block b : blockList) {
            if (((ConsumerBlock)b).name == null || !((ConsumerBlock)b).name.equals(name)) continue;
            return (ConsumerBlock)b;
        }
        return null;
    }

    public void func_149689_a(World w, int x, int y, int z, EntityLivingBase livingBase, ItemStack stack) {
        int l = MathHelper.func_76128_c((double)((double)(livingBase.field_70177_z * 4.0f / 360.0f) + 0.5)) & 3;
        if (l == 0) {
            w.func_72921_c(x, y, z, 2, 2);
        }
        if (l == 1) {
            w.func_72921_c(x, y, z, 5, 2);
        }
        if (l == 2) {
            w.func_72921_c(x, y, z, 3, 2);
        }
        if (l == 3) {
            w.func_72921_c(x, y, z, 4, 2);
        }
        AuraUtil.updateMonitor(w, x, y, z);
    }

    public void func_149749_a(World w, int x, int y, int z, Block b, int p_149749_6_) {
        super.func_149749_a(w, x, y, z, b, p_149749_6_);
        AuraUtil.updateMonitor(w, x, y, z);
    }

    public void func_149651_a(IIconRegister iconRegister) {
        if (this.name.equals("furnace")) {
            this.top = iconRegister.func_94245_a("aura:auraFurnace_top");
            this.side = iconRegister.func_94245_a("aura:auraFurnace_side");
            this.front = iconRegister.func_94245_a("aura:auraFurnace_front");
        }
        if (this.name.equals("ore")) {
            this.field_149761_L = iconRegister.func_94245_a("aura:auraOre");
        }
        if (this.name.equals("mob")) {
            this.field_149761_L = iconRegister.func_94245_a("aura:auraMob");
        }
        if (this.name.equals("plant")) {
            this.field_149761_L = iconRegister.func_94245_a("aura:auraGrow");
            this.top = iconRegister.func_94245_a("aura:auraGrowTop");
        }
        if (this.name.equals("fish")) {
            this.field_149761_L = iconRegister.func_94245_a("aura:auraFish");
        }
        if (this.name.equals("angel")) {
            this.field_149761_L = iconRegister.func_94245_a("aura:auraAngel");
            this.top = iconRegister.func_94245_a("aura:auraAngelTop");
        }
        if (this.name.equals("loot")) {
            this.field_149761_L = iconRegister.func_94245_a("aura:auraLoot");
            this.top = iconRegister.func_94245_a("aura:auraLootTop");
        }
        if (this.name.equals("nether")) {
            this.field_149761_L = iconRegister.func_94245_a("aura:ritualNether");
        }
        if (this.name.equals("end")) {
            this.field_149761_L = iconRegister.func_94245_a("aura:ritualEnd");
        }
        if (this.name.equals("potion")) {
            this.field_149761_L = iconRegister.func_94245_a("aura:brewer");
        }
        if (this.name.equals("enchant")) {
            this.field_149761_L = iconRegister.func_94245_a("aura:enchanter");
        }
        if (this.name.equals("oreAdv")) {
            this.field_149761_L = iconRegister.func_94245_a("aura:auraOreAdv");
        }
        if (this.name.equals("dye")) {
            this.field_149761_L = iconRegister.func_94245_a("aura:dye");
        }
        if (this.name.equals("miner")) {
            this.field_149761_L = iconRegister.func_94245_a("aura:miner");
        }
    }

    public IIcon func_149691_a(int side, int meta) {
        if (this.top != null && this.side != null && this.front != null) {
            if (side == 1 || side == 0) {
                return this.top;
            }
            if (side == meta) {
                return this.front;
            }
            return this.side;
        }
        if (this.top != null) {
            if (side == 1 || side == 0) {
                return this.top;
            }
            return this.field_149761_L;
        }
        return this.field_149761_L;
    }

    @Override
    public ThaumicTinkererRecipe getRecipeItem() {
        if (this.name != null) {
            if (this.name.equals("plant")) {
                return new PylonRecipe(new ItemStack((Block)this), new PylonRecipeComponent(new AuraQuantity(EnumAura.GREEN_AURA, 100000), ItemMaterial.getGem(EnumAura.GREEN_AURA)));
            }
            if (this.name.equals("ore")) {
                return new CraftingBenchRecipe(new ItemStack((Block)this), "IFI", "FIF", "IFI", Character.valueOf('F'), new ItemStack(Blocks.field_150460_al), Character.valueOf('I'), ItemAuraCrystal.getCrystalFromAura(EnumAura.WHITE_AURA));
            }
            if (this.name.equals("loot")) {
                return new PylonRecipe(new ItemStack((Block)this), new PylonRecipeComponent(new AuraQuantity(EnumAura.YELLOW_AURA, 100000), ItemMaterial.getGem(EnumAura.YELLOW_AURA)));
            }
            if (this.name.equals("mob")) {
                return new PylonRecipe(new ItemStack((Block)this), new PylonRecipeComponent(new AuraQuantity(EnumAura.VIOLET_AURA, 100000), ItemMaterial.getGem(EnumAura.VIOLET_AURA)));
            }
            if (this.name.equals("angel")) {
                return new PylonRecipe(new ItemStack((Block)this), new PylonRecipeComponent(new AuraQuantity(EnumAura.WHITE_AURA, 300000), ItemMaterial.getPrism()), new PylonRecipeComponent(new AuraQuantity(EnumAura.WHITE_AURA, 200000), new ItemStack(Items.field_151042_j)), new PylonRecipeComponent(new AuraQuantity(EnumAura.WHITE_AURA, 200000), new ItemStack(Items.field_151042_j)), new PylonRecipeComponent(new AuraQuantity(EnumAura.WHITE_AURA, 200000), new ItemStack(Items.field_151042_j)));
            }
            if (this.name.equals("nether")) {
                return new PylonRecipe(new ItemStack((Block)this), new PylonRecipeComponent(new AuraQuantity(EnumAura.RED_AURA, 100000), ItemMaterial.getGem(EnumAura.RED_AURA)));
            }
            if (this.name.equals("potion")) {
                return new PylonRecipe(new ItemStack((Block)this), new PylonRecipeComponent(new AuraQuantity(EnumAura.WHITE_AURA, 100000), ItemMaterial.getGem(EnumAura.ORANGE_AURA)));
            }
            if (this.name.equals("enchant")) {
                return new PylonRecipe(new ItemStack((Block)this), new PylonRecipeComponent(new AuraQuantity(EnumAura.WHITE_AURA, 250000), ItemMaterial.getGem(EnumAura.BLACK_AURA)));
            }
            if (this.name.equals("oreAdv")) {
                return new CraftingBenchRecipe(new ItemStack((Block)this), "GPG", "GCG", "GGG", Character.valueOf('P'), ItemMaterial.getPrism(), Character.valueOf('G'), new ItemStack(Blocks.field_150359_w), Character.valueOf('C'), new ItemStack((Block)ConsumerBlock.getBlockFromName("ore")));
            }
            if (this.name.equals("dye")) {
                return new CraftingBenchRecipe(new ItemStack((Block)this), "CCC", "CFC", "CCC", Character.valueOf('F'), new ItemStack((Item)Items.field_151097_aZ), Character.valueOf('C'), Blocks.field_150325_L);
            }
            if (this.name.equals("miner")) {
                return new CraftingBenchRecipe(new ItemStack((Block)this), "PAP", "IRI", "IRI", Character.valueOf('P'), ItemMaterial.getPrism(), Character.valueOf('A'), new ItemStack(Items.field_151046_w), Character.valueOf('I'), new ItemStack(Items.field_151042_j), Character.valueOf('R'), BlockRegistry.getFirstItemFromClass(ItemRedHole.class));
            }
            if (this.name.equals("end")) {
                return new CraftingBenchRecipe(new ItemStack((Block)this), "EPE", "ENE", "EEE", Character.valueOf('P'), ItemMaterial.getPrism(), Character.valueOf('E'), new ItemStack(Blocks.field_150377_bs), Character.valueOf('N'), new ItemStack((Block)ConsumerBlock.getBlockFromName("nether")));
            }
            if (this.name.equals("fish")) {
                return new CraftingBenchRecipe(new ItemStack((Block)this), "RRR", "III", Character.valueOf('R'), new ItemStack((Item)Items.field_151112_aM), Character.valueOf('I'), ItemMaterial.getIngot(EnumAura.BLUE_AURA));
            }
        }
        return new CraftingBenchRecipe(new ItemStack((Block)this), "FFF", "FIF", "FFF", Character.valueOf('F'), new ItemStack(Blocks.field_150460_al), Character.valueOf('I'), ItemAuraCrystal.getCrystalFromAura(EnumAura.WHITE_AURA));
    }

    @Override
    public int getCreativeTabPriority() {
        return 0;
    }

    @Override
    public ArrayList<Object> getSpecialParameters() {
        ArrayList<Object> result = new ArrayList<Object>();
        result.add("plant");
        result.add("ore");
        result.add("loot");
        result.add("mob");
        result.add("angel");
        result.add("nether");
        result.add("enchant");
        result.add("potion");
        result.add("dye");
        result.add("oreAdv");
        result.add("miner");
        result.add("fish");
        result.add("end");
        return result;
    }

    @Override
    public String getBlockName() {
        return "consumerBlock" + this.name;
    }

    @Override
    public boolean shouldRegister() {
        return true;
    }

    @Override
    public boolean shouldDisplayInTab() {
        return true;
    }

    @Override
    public Class<? extends ItemBlock> getItemBlock() {
        return null;
    }

    @Override
    public Class<? extends TileEntity> getTileEntity() {
        if (this.name != null) {
            if (this.name.equals("plant")) {
                return PlanterTile.class;
            }
            if (this.name.equals("ore")) {
                return ProcessorTile.class;
            }
            if (this.name.equals("oreAdv")) {
                return ProcessorTileAdv.class;
            }
            if (this.name.equals("loot")) {
                return LootTile.class;
            }
            if (this.name.equals("mob")) {
                return SpawnTile.class;
            }
            if (this.name.equals("angel")) {
                return AngelSteelTile.class;
            }
            if (this.name.equals("nether")) {
                return TileRitualNether.class;
            }
            if (this.name.equals("potion")) {
                return PotionTile.class;
            }
            if (this.name.equals("enchant")) {
                return EnchanterTile.class;
            }
            if (this.name.equals("dye")) {
                return DyeTile.class;
            }
            if (this.name.equals("miner")) {
                return MinerTile.class;
            }
            if (this.name.equals("end")) {
                return TileRitualEnd.class;
            }
            if (this.name.equals("fish")) {
                return FisherTile.class;
            }
        }
        return FurnaceTile.class;
    }

    public boolean func_149740_M() {
        return true;
    }

    public int func_149736_g(World world, int x, int y, int z, int meta) {
        TileEntity tileEntity = world.func_147438_o(x, y, z);
        if (tileEntity instanceof ConsumerTile) {
            return (int)(15.0 * ((double)((ConsumerTile)tileEntity).progress / (double)((ConsumerTile)tileEntity).getMaxProgress()));
        }
        return super.func_149736_g(world, x, y, z, meta);
    }

    public TileEntity func_149915_a(World world, int meta) {
        try {
            return this.getTileEntity().newInstance();
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        return null;
    }

    @Override
    public List<String> getTooltipData(World world, EntityPlayer player, int x, int y, int z) {
        ArrayList<String> result = new ArrayList<String>();
        if (world.func_147438_o(x, y, z) instanceof ConsumerTile) {
            ConsumerTile consumerTile = (ConsumerTile)world.func_147438_o(x, y, z);
            result.add("Progress: " + consumerTile.progress + " / " + consumerTile.getMaxProgress());
            result.add("Power per progress: " + consumerTile.getPowerPerProgress());
            result.add("Last Power: " + consumerTile.lastPower);
        }
        return result;
    }
}

