/*
 * Decompiled with CFR 0.152.
 */
package pixlepix.auracascade.block;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import pixlepix.auracascade.AuraCascade;
import pixlepix.auracascade.data.recipe.ProcessorRecipe;
import pixlepix.auracascade.lexicon.page.PageCraftingRecipe;
import pixlepix.auracascade.registry.BlockRegistry;
import pixlepix.auracascade.registry.ITTinkererBlock;
import pixlepix.auracascade.registry.ThaumicTinkererRecipe;
import pixlepix.auracascade.registry.ThaumicTinkererRecipeMulti;

public class BlockExplosionContainer
extends Block
implements ITTinkererBlock {
    public String type;

    public BlockExplosionContainer() {
        super(Material.field_151576_e);
        this.func_149752_b(2000.0f);
        this.type = "Dirt";
        this.func_149675_a(true);
        this.func_149711_c(2.0f);
    }

    public BlockExplosionContainer(String s) {
        this();
        this.type = s;
        if (this.type.equals("Glass")) {
            this.func_149713_g(1);
        }
    }

    public static BlockExplosionContainer getBlockFromName(String name) {
        ArrayList<Block> blockList = BlockRegistry.getBlockFromClass(BlockExplosionContainer.class);
        for (Block b : blockList) {
            if (((BlockExplosionContainer)b).type == null || !((BlockExplosionContainer)b).type.equals(name)) continue;
            return (BlockExplosionContainer)b;
        }
        return null;
    }

    public static PageCraftingRecipe getRecipe(String unloc, String name) {
        return new PageCraftingRecipe(unloc, BlockRegistry.getRecipe(BlockExplosionContainer.getBlockFromName(name)));
    }

    public int func_149660_a(World world, int x, int y, int z, int side, float hitX, float hitY, float hitZ, int meta) {
        super.func_149660_a(world, x, y, z, side, hitX, hitY, hitZ, meta);
        world.func_147464_a(x, y, z, (Block)this, this.func_149738_a(world));
        return meta;
    }

    public int func_149738_a(World world) {
        return 100;
    }

    public void func_149674_a(World world, int x, int y, int z, Random rand) {
        int meta;
        super.func_149674_a(world, x, y, z, rand);
        if (rand.nextDouble() < this.getChanceToRepair() && (meta = world.func_72805_g(x, y, z)) > 0) {
            world.func_72921_c(x, y, z, meta - 1, 3);
        }
        world.func_147464_a(x, y, z, (Block)this, this.func_149738_a(world) + rand.nextInt(5));
    }

    public boolean canRenderInPass(int pass) {
        AuraCascade.proxy.renderPass = pass;
        return true;
    }

    public boolean func_149686_d() {
        return this.func_149662_c();
    }

    public double getChanceToResist() {
        return 1.0 - 1.0 / ((double)this.getVirtualHealth() / 16.0);
    }

    public double getChanceToRepair() {
        return 1.0 / ((double)this.getRepairSeconds() / 5.0);
    }

    public int getRepairSeconds() {
        if (this.type.equals("Dirt")) {
            return 120;
        }
        if (this.type.equals("Wood")) {
            return 5;
        }
        if (this.type.equals("Glass")) {
            return 120;
        }
        if (this.type.equals("Cobblestone")) {
            return 30;
        }
        if (this.type.equals("Stone")) {
            return 60;
        }
        if (this.type.equals("Obsidian")) {
            return 6000;
        }
        return 0;
    }

    public int getVirtualHealth() {
        if (this.type.equals("Dirt")) {
            return 50;
        }
        if (this.type.equals("Wood")) {
            return 30;
        }
        if (this.type.equals("Glass")) {
            return 16;
        }
        if (this.type.equals("Cobblestone")) {
            return 75;
        }
        if (this.type.equals("Stone")) {
            return 100;
        }
        if (this.type.equals("Obsidian")) {
            return 1600;
        }
        return 0;
    }

    public void func_149651_a(IIconRegister register) {
        this.field_149761_L = register.func_94245_a("aura:fortified" + this.type);
    }

    @Override
    public ArrayList<Object> getSpecialParameters() {
        ArrayList<Object> result = new ArrayList<Object>();
        result.add("Wood");
        result.add("Glass");
        result.add("Cobblestone");
        result.add("Stone");
        result.add("Obsidian");
        return result;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_149646_a(IBlockAccess world, int x, int y, int z, int side) {
        if (!this.type.equals("Glass")) {
            return true;
        }
        Block block = world.func_147439_a(x, y, z);
        return block != this;
    }

    public int func_149701_w() {
        return 1;
    }

    @Override
    public String getBlockName() {
        return "fortified" + this.type;
    }

    @Override
    public boolean shouldRegister() {
        return true;
    }

    @Override
    public boolean shouldDisplayInTab() {
        return true;
    }

    public IIcon func_149691_a(int side, int meta) {
        return this.field_149761_L;
    }

    public IIcon func_149673_e(IBlockAccess world, int x, int y, int z, int side) {
        int meta = world.func_72805_g(x, y, z);
        if (AuraCascade.proxy.renderPass == 1) {
            if (meta != 0) {
                return AuraCascade.proxy.breakingIcons[this.getCrackedStage(meta)];
            }
            return AuraCascade.proxy.blankIcon;
        }
        return this.field_149761_L;
    }

    public int getCrackedStage(int meta) {
        if (meta <= 5) {
            return meta - 1;
        }
        return (int)(4.0 + Math.ceil((meta - 5) / 2));
    }

    @Override
    public Class<? extends ItemBlock> getItemBlock() {
        return null;
    }

    @Override
    public Class<? extends TileEntity> getTileEntity() {
        return null;
    }

    public boolean func_149662_c() {
        return this.type == null || !this.type.equals("Glass");
    }

    @Override
    public ThaumicTinkererRecipe getRecipeItem() {
        if (this.type.equals("Dirt")) {
            return new ProcessorRecipe(new ItemStack((Block)this), false, new ItemStack(Blocks.field_150377_bs), new ItemStack(Blocks.field_150346_d));
        }
        if (this.type.equals("Wood")) {
            return new ThaumicTinkererRecipeMulti(new ProcessorRecipe(new ItemStack((Block)this), false, new ItemStack(Blocks.field_150377_bs), new ItemStack(Blocks.field_150344_f)), new ProcessorRecipe(new ItemStack((Block)this), false, new ItemStack(Blocks.field_150377_bs), new ItemStack(Blocks.field_150344_f, 1, 1)), new ProcessorRecipe(new ItemStack((Block)this), false, new ItemStack(Blocks.field_150377_bs), new ItemStack(Blocks.field_150344_f, 1, 2)), new ProcessorRecipe(new ItemStack((Block)this), false, new ItemStack(Blocks.field_150377_bs), new ItemStack(Blocks.field_150344_f, 1, 3)), new ProcessorRecipe(new ItemStack((Block)this), false, new ItemStack(Blocks.field_150377_bs), new ItemStack(Blocks.field_150344_f, 1, 4)), new ProcessorRecipe(new ItemStack((Block)this), false, new ItemStack(Blocks.field_150377_bs), new ItemStack(Blocks.field_150344_f, 1, 5)));
        }
        if (this.type.equals("Glass")) {
            return new ProcessorRecipe(new ItemStack((Block)this), false, new ItemStack(Blocks.field_150377_bs), new ItemStack(Blocks.field_150359_w));
        }
        if (this.type.equals("Cobblestone")) {
            return new ProcessorRecipe(new ItemStack((Block)this), false, new ItemStack(Blocks.field_150377_bs), new ItemStack(Blocks.field_150347_e));
        }
        if (this.type.equals("Stone")) {
            return new ProcessorRecipe(new ItemStack((Block)this), false, new ItemStack(Blocks.field_150377_bs), new ItemStack(Blocks.field_150348_b));
        }
        if (this.type.equals("Obsidian")) {
            return new ProcessorRecipe(new ItemStack((Block)this), false, new ItemStack(Blocks.field_150377_bs), new ItemStack(Blocks.field_150343_Z));
        }
        return null;
    }

    @Override
    public int getCreativeTabPriority() {
        return 23;
    }
}

