/*
 * Decompiled with CFR 0.152.
 */
package de.npe.gameanalytics;

import com.google.gson.Gson;
import de.npe.gameanalytics.Analytics;
import de.npe.gameanalytics.events.GAErrorEvent;
import de.npe.gameanalytics.events.GAEvent;
import de.npe.gameanalytics.util.ACLock;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.security.MessageDigest;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.Semaphore;
import javax.xml.bind.DatatypeConverter;

final class EventHandler {
    private static final Queue<GAEvent> immediateEvents = new ArrayDeque<GAEvent>(32);
    private static final Map<Analytics.KeyPair, Map<String, List<GAEvent>>> events = new HashMap<Analytics.KeyPair, Map<String, List<GAEvent>>>(8);
    private static boolean init = true;
    private static Thread sendImmediateThread;
    private static ACLock immediateEvents_lock;
    private static Semaphore sendSemaphore;
    private static ACLock getEventsForGame_lock;
    private static ACLock getCategoryEvents_lock;
    private static ACLock sendData_lock;
    private static ACLock errorSend_lock;

    EventHandler() {
    }

    private static Map<String, List<GAEvent>> getEventsForGame(Analytics.KeyPair keyPair) {
        try (ACLock acl = getEventsForGame_lock.lockAC();){
            Map<String, List<GAEvent>> gameEvents = events.get(keyPair);
            if (gameEvents == null) {
                gameEvents = new HashMap<String, List<GAEvent>>();
                events.put(keyPair, gameEvents);
            }
            Map<String, List<GAEvent>> map = gameEvents;
            return map;
        }
    }

    private static List<GAEvent> getCategoryEvents(Map<String, List<GAEvent>> gameEvents, String category) {
        try (ACLock acl = getCategoryEvents_lock.lockAC();){
            List<GAEvent> categoryEvents = gameEvents.get(category);
            if (categoryEvents == null) {
                categoryEvents = new ArrayList<GAEvent>(16);
                gameEvents.put(category, categoryEvents);
            }
            List<GAEvent> list = categoryEvents;
            return list;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void add(GAEvent event) {
        try {
            List<GAEvent> categoryEvents;
            Map<String, List<GAEvent>> gameEvents = EventHandler.getEventsForGame(event.keyPair);
            List<GAEvent> list = categoryEvents = EventHandler.getCategoryEvents(gameEvents, event.category());
            synchronized (list) {
                categoryEvents.add(event);
            }
        }
        catch (Exception ex) {
            System.err.println("Failed to add GAEvent to event queue: " + event);
            ex.printStackTrace(System.err);
        }
        EventHandler.init();
    }

    static void queueImmediateSend(GAEvent event) {
        boolean added = false;
        try (ACLock acl = immediateEvents_lock.lockAC();){
            added = immediateEvents.offer(event);
        }
        if (added) {
            sendSemaphore.release();
        } else {
            System.err.println("Could not add event to immediate events queue: " + event);
        }
        EventHandler.init();
    }

    static void sendErrorNow(final GAErrorEvent event, boolean useThread) {
        if (useThread) {
            Thread errorSendThread = new Thread("GA-send-error-now"){

                @Override
                public void run() {
                    try (ACLock acl = errorSend_lock.lockAC();){
                        RESTHelper.sendSingleEvent(event);
                    }
                }
            };
            errorSendThread.start();
        } else {
            try (ACLock acl = errorSend_lock.lockAC();){
                RESTHelper.sendSingleEvent(event);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void init() {
        if (!init) {
            return;
        }
        Class<EventHandler> clazz = EventHandler.class;
        synchronized (EventHandler.class) {
            if (!init) {
                // ** MonitorExit[var0] (shouldn't be in output)
                return;
            }
            init = false;
            // ** MonitorExit[var0] (shouldn't be in output)
            int sleepTime = 10000;
            Thread sendThread = new Thread("GA-DataSendThread"){

                @Override
                public void run() {
                    while (true) {
                        try {
                            while (true) {
                                2.sleep(10000L);
                                EventHandler.sendData();
                            }
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                            continue;
                        }
                        break;
                    }
                }
            };
            sendThread.setDaemon(true);
            sendThread.start();
            sendImmediateThread = new Thread("GA-DataSendImmediatelyThread"){

                @Override
                public void run() {
                    while (true) {
                        GAEvent event;
                        sendSemaphore.acquireUninterruptibly();
                        try (ACLock acl = immediateEvents_lock.lockAC();){
                            event = (GAEvent)immediateEvents.poll();
                        }
                        if (event != null) {
                            RESTHelper.sendSingleEvent(event);
                            continue;
                        }
                        System.err.println("Immediate event queue did not contain an event. Something released a permit without adding an event first.");
                    }
                }
            };
            sendImmediateThread.setDaemon(true);
            sendImmediateThread.start();
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void sendData() {
        try (ACLock acl = sendData_lock.lockAC();){
            Set<Analytics.KeyPair> keyPairs = events.keySet();
            for (Analytics.KeyPair keyPair : keyPairs) {
                Map<String, List<GAEvent>> gameEvents = EventHandler.getEventsForGame(keyPair);
                if (gameEvents.isEmpty()) continue;
                ArrayList<String> categories = new ArrayList<String>(gameEvents.keySet());
                for (String category : categories) {
                    ArrayList<GAEvent> categoryEventsCopy;
                    List<GAEvent> categoryEvents;
                    List<GAEvent> list = categoryEvents = gameEvents.get(category);
                    synchronized (list) {
                        if (categoryEvents.isEmpty()) {
                            continue;
                        }
                        categoryEventsCopy = new ArrayList<GAEvent>(categoryEvents);
                        categoryEvents.clear();
                    }
                    RESTHelper.sendData(keyPair, category, categoryEventsCopy);
                }
            }
        }
    }

    static {
        immediateEvents_lock = new ACLock(true);
        sendSemaphore = new Semaphore(0);
        getEventsForGame_lock = new ACLock(true);
        getCategoryEvents_lock = new ACLock(true);
        sendData_lock = new ACLock(true);
        errorSend_lock = new ACLock(true);
    }

    private static class RESTHelper {
        private static final Gson gson = new Gson();
        private static final String contentType = "application/json; charset=utf-8";
        private static final String accept = "application/json";

        private RESTHelper() {
        }

        static void sendSingleEvent(GAEvent event) {
            try {
                RESTHelper.sendData(event.keyPair, event.category(), Arrays.asList(event));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        static void sendData(Analytics.KeyPair keyPair, String category, List<GAEvent> events) {
            String[] result = RESTHelper.sendAndGetResponse(keyPair, category, events);
            if (!"{\"status\":\"ok\"}".equals(result[0])) {
                System.err.println("Failed to send analytics event data. Result of attempt: " + result[0] + " | Authentication hash used: " + result[1] + " | Data sent: " + result[2]);
            }
        }

        private static String[] sendAndGetResponse(Analytics.KeyPair keyPair, String category, List<GAEvent> events) {
            try {
                String postData = gson.toJson(events);
                byte[] postBytes = postData.getBytes("UTF-8");
                byte[] authData = (postData + keyPair.secretKey).getBytes("UTF-8");
                String hashedAuthData = DatatypeConverter.printHexBinary((byte[])MessageDigest.getInstance("MD5").digest(authData)).toLowerCase();
                URL url = new URL("http://api.gameanalytics.com/1/" + keyPair.gameKey + "/" + category);
                HttpURLConnection connection = (HttpURLConnection)url.openConnection();
                connection.setDoOutput(true);
                connection.setRequestMethod("POST");
                connection.setRequestProperty("Authorization", hashedAuthData);
                connection.setRequestProperty("Accept", accept);
                connection.setRequestProperty("Content-Type", contentType);
                connection.setRequestProperty("Content-Length", String.valueOf(postBytes.length));
                StringBuilder responseSB = new StringBuilder();
                try (OutputStream os = connection.getOutputStream();){
                    os.write(postBytes);
                    try (BufferedReader br = new BufferedReader(new InputStreamReader(connection.getInputStream(), "UTF-8"));){
                        String line;
                        while ((line = br.readLine()) != null) {
                            responseSB.append(line);
                        }
                    }
                }
                return new String[]{responseSB.toString(), hashedAuthData, postData};
            }
            catch (Exception ex) {
                return new String[]{ex.getMessage(), "null", "null"};
            }
        }
    }
}

