/*
 * Decompiled with CFR 0.152.
 */
package com.rota.ee3help.commands;

import com.pahimar.ee3.api.exchange.EnergyValue;
import com.pahimar.ee3.exchange.EnergyValueRegistry;
import com.pahimar.ee3.exchange.WrappedStack;
import com.rota.ee3help.EE3Help;
import com.rota.ee3help.Helper;
import com.rota.ee3help.commands.CommandModifyBase;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import net.minecraft.command.ICommandSender;
import net.minecraft.util.EnumChatFormatting;

public class CommandRemove
extends CommandModifyBase {
    public ArrayList<WrappedStack> entries = new ArrayList();
    Map<WrappedStack, EnergyValue> valuesPre;

    private void buildList() {
        this.entries.clear();
        this.valuesPre = Helper.loadPre();
        for (Map.Entry<WrappedStack, EnergyValue> entry : this.valuesPre.entrySet()) {
            this.entries.add(entry.getKey());
        }
        Collections.sort(this.entries);
    }

    private void remove(int i) {
        if (i < 0 || i >= this.entries.size()) {
            return;
        }
        this.valuesPre.remove(this.entries.get(i));
        this.entries.remove(i);
        EnergyValueRegistry.getInstance().setShouldRegenNextRestart(true);
        Helper.savePre(this.valuesPre);
    }

    private void remove(int i, int j) {
        if (i < 0 || i >= this.entries.size() || j < 0 || j >= this.entries.size() || j < i) {
            return;
        }
        for (WrappedStack w : this.entries.subList(i, j + 1)) {
            this.valuesPre.remove(w);
        }
        this.entries.subList(i, j + 1).clear();
        EnergyValueRegistry.getInstance().setShouldRegenNextRestart(true);
        Helper.savePre(this.valuesPre);
    }

    @Override
    public String func_71517_b() {
        return "remove";
    }

    @Override
    public String func_71518_a(ICommandSender cs) {
        return "remove <index>, remove <start> <end>";
    }

    @Override
    public void func_71515_b(ICommandSender cs, String[] args) {
        if (!EE3Help.listAccurate) {
            Helper.toChat(cs, EnumChatFormatting.RED + "Indices may be innacurate, run 'list' first.");
            return;
        }
        try {
            this.buildList();
            switch (args.length) {
                case 0: {
                    Helper.toChatErr(cs, "remove <index>");
                    Helper.toChatErr(cs, "remove <start> <end>");
                    break;
                }
                case 1: {
                    this.remove(Integer.parseInt(args[0]));
                    Helper.toChat(cs, EnumChatFormatting.LIGHT_PURPLE + "(-) REMOVE");
                    break;
                }
                case 2: {
                    this.remove(Integer.parseInt(args[0]), Integer.parseInt(args[1]));
                    Helper.toChat(cs, EnumChatFormatting.LIGHT_PURPLE + "(-) REMOVE RANGE");
                    break;
                }
                default: {
                    Helper.toChatErr(cs, "Invalid number of arguments for operation.");
                    Helper.toChatErr(cs, "remove <index>");
                    Helper.toChatErr(cs, "remove <start> <end>");
                    break;
                }
            }
        }
        catch (NumberFormatException e) {
            Helper.toChatErr(cs, "Non-number in numeric field.");
        }
        this.resetFlag();
    }
}

