/*
 * Decompiled with CFR 0.152.
 */
package com.rota.ee3help.commands;

import com.pahimar.ee3.api.exchange.EnergyValue;
import com.pahimar.ee3.exchange.OreStack;
import com.pahimar.ee3.exchange.WrappedStack;
import com.rota.ee3help.EE3Help;
import com.rota.ee3help.Helper;
import com.rota.ee3help.commands.CommandModifyBase;
import cpw.mods.fml.common.FMLLog;
import cpw.mods.fml.common.registry.GameData;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import net.minecraft.command.ICommandSender;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumChatFormatting;
import net.minecraftforge.fluids.FluidStack;

public class CommandList
extends CommandModifyBase {
    public ArrayList<WrappedStack> entries = new ArrayList();
    Map<WrappedStack, EnergyValue> valuesPre;

    private void buildList() {
        this.entries.clear();
        this.valuesPre = Helper.loadPre();
        for (Map.Entry<WrappedStack, EnergyValue> entry : this.valuesPre.entrySet()) {
            this.entries.add(entry.getKey());
        }
        Collections.sort(this.entries);
    }

    private String getInfo(WrappedStack w) {
        try {
            String name;
            Object wrappedStack = w.getWrappedObject();
            Field fieldObjectType = w.getClass().getDeclaredField("objectType");
            Field fieldStackSize = w.getClass().getDeclaredField("stackSize");
            fieldObjectType.setAccessible(true);
            fieldStackSize.setAccessible(true);
            String objectType = (String)fieldObjectType.get(w);
            int stackSize = (Integer)fieldStackSize.get(w);
            if (wrappedStack instanceof ItemStack) {
                ItemStack itemStack = (ItemStack)wrappedStack;
                name = GameData.getItemRegistry().func_148750_c((Object)itemStack.func_77973_b()) + ":" + itemStack.func_77960_j();
            } else if (wrappedStack instanceof OreStack) {
                OreStack oreStack = (OreStack)wrappedStack;
                name = oreStack.oreName;
            } else if (wrappedStack instanceof FluidStack) {
                FluidStack fluidStack = (FluidStack)wrappedStack;
                name = fluidStack.getFluid().getName();
            } else {
                name = "null-wrappedstack";
            }
            return objectType + " " + name;
        }
        catch (NoSuchFieldException e) {
            FMLLog.getLogger().error("WrappedStack has been updated, this field name is invalid: " + e.getMessage());
        }
        catch (Exception e) {
            FMLLog.getLogger().error("Could not access field: " + e.getMessage());
        }
        return "PARSE_ERROR:CHECKLOG";
    }

    @Override
    public String func_71517_b() {
        return "list";
    }

    @Override
    public String func_71518_a(ICommandSender cs) {
        return "list, list <page>";
    }

    @Override
    public void func_71515_b(ICommandSender cs, String[] args) {
        try {
            this.buildList();
            EE3Help.listAccurate = true;
            int pageLength = 9;
            int pages = 0;
            pages = (int)Math.ceil((double)this.entries.size() / (double)pageLength);
            if (args.length == 0) {
                Helper.toChat(cs, EnumChatFormatting.AQUA + "Pages: " + pages + ", list <page>");
            } else if (args.length >= 1) {
                int index;
                if (pages == 0) {
                    Helper.toChat(cs, EnumChatFormatting.GOLD + "No Entries.");
                    return;
                }
                int page = Integer.parseInt(args[0]);
                page = page < 1 ? 1 : page;
                page = page > pages ? pages : page;
                Helper.toChat(cs, EnumChatFormatting.GRAY + "---- Page " + page + "/" + pages + " ----");
                for (int i = index = page * pageLength - pageLength; i < index + pageLength && i < this.entries.size(); ++i) {
                    Helper.toChat(cs, EnumChatFormatting.GOLD + "(" + String.format("%4s", i) + ") " + this.getInfo(this.entries.get(i)) + " " + EnumChatFormatting.BLUE + "EMC: " + EnumChatFormatting.RED + this.valuesPre.get(this.entries.get(i)));
                }
            }
        }
        catch (NumberFormatException e) {
            Helper.toChatErr(cs, "Non-number in numeric field.");
        }
    }
}

