/*
 * Decompiled with CFR 0.152.
 */
package com.rota.ee3help.commands;

import com.rota.ee3help.DataTracker;
import com.rota.ee3help.Helper;
import com.rota.ee3help.commands.CommandForceRegen;
import com.rota.ee3help.commands.CommandModifyBase;
import net.minecraft.command.ICommandSender;
import net.minecraft.util.EnumChatFormatting;

public class CommandData
extends CommandModifyBase {
    static final int MODE_WORLD = 0;
    static final int MODE_USER = 1;

    @Override
    public String func_71517_b() {
        return "data";
    }

    @Override
    public String func_71518_a(ICommandSender cs) {
        return "data";
    }

    public void list(ICommandSender cs, int page) {
        int index;
        DataTracker.buildList();
        DataTracker.listAccurate = true;
        int pageLength = 9;
        int pages = 0;
        pages = (int)Math.ceil((double)DataTracker.dataList.size() / (double)pageLength);
        if (page < 0) {
            Helper.toChat(cs, EnumChatFormatting.BLUE + "Pages: " + pages + ", list <page>");
            return;
        }
        if (pages == 0) {
            Helper.toChat(cs, EnumChatFormatting.GOLD + "No Entries.");
            return;
        }
        page = page < 1 ? 1 : page;
        page = page > pages ? pages : page;
        Helper.toChat(cs, EnumChatFormatting.GRAY + "---- Page " + page + "/" + pages + " ----");
        for (int i = index = page * pageLength - pageLength; i < index + pageLength && i < DataTracker.dataList.size(); ++i) {
            Helper.toChat(cs, EnumChatFormatting.GOLD + "(" + String.format("%4s", i) + ") " + DataTracker.data.get(DataTracker.dataList.get(i)));
        }
    }

    @Override
    public void func_71515_b(ICommandSender cs, String[] args) {
        try {
            switch (args.length) {
                case 0: {
                    Helper.toChatErr(cs, "data list <page>");
                    Helper.toChatErr(cs, "data import <index>");
                    Helper.toChatErr(cs, "data export");
                    break;
                }
                case 1: {
                    if (args[0].equalsIgnoreCase("list")) {
                        this.list(cs, -1);
                        break;
                    }
                    if (args[0].equalsIgnoreCase("import")) {
                        Helper.toChatErr(cs, "data import <index>");
                        break;
                    }
                    if (args[0].equalsIgnoreCase("export")) {
                        DataTracker.exportData();
                        Helper.toChat(cs, EnumChatFormatting.GREEN + "(!) Exported Data");
                    }
                    break;
                }
                case 2: {
                    if (args[0].equalsIgnoreCase("list")) {
                        this.list(cs, Integer.parseInt(args[1]));
                        break;
                    }
                    if (args[0].equalsIgnoreCase("import")) {
                        if (DataTracker.listAccurate) {
                            DataTracker.importData(Integer.parseInt(args[1]));
                            Helper.toChat(cs, EnumChatFormatting.GREEN + "(!) Imported Data");
                            new CommandForceRegen().func_71515_b(cs, new String[0]);
                            break;
                        }
                        Helper.toChatErr(cs, "Indices may be innacurate, run 'data list' first. ");
                    }
                    break;
                }
                default: {
                    Helper.toChatErr(cs, "Invalid number of arguments for operation.");
                    Helper.toChatErr(cs, "data list <page>");
                    Helper.toChatErr(cs, "data import <index>");
                    Helper.toChatErr(cs, "data export");
                    break;
                }
            }
        }
        catch (NumberFormatException e) {
            Helper.toChatErr(cs, "Non-number in numeric field.");
        }
    }
}

