/*
 * Decompiled with CFR 0.152.
 */
package com.rota.ee3help.commands;

import com.pahimar.ee3.api.exchange.EnergyValue;
import com.pahimar.ee3.exchange.EnergyValueRegistry;
import com.pahimar.ee3.exchange.OreStack;
import com.pahimar.ee3.exchange.WrappedStack;
import com.rota.ee3help.Helper;
import com.rota.ee3help.commands.CommandModifyBase;
import cpw.mods.fml.common.registry.GameData;
import java.util.Map;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.RegistryNamespaced;
import net.minecraftforge.oredict.OreDictionary;

public class CommandAddOreRange
extends CommandModifyBase {
    EnergyValueRegistry registryValues = EnergyValueRegistry.getInstance();
    static RegistryNamespaced registryNames = GameData.getItemRegistry();

    public static void addOreRangeForRange(String name, int start, int end, float value) {
        for (int i = start; i <= end; ++i) {
            CommandAddOreRange.addOreRange(name, i, value);
        }
    }

    public static void addOreRange(String name, int damageValue, float value) {
        if (!registryNames.func_148741_d(name)) {
            return;
        }
        ItemStack iStack = new ItemStack((Item)registryNames.func_82594_a(name));
        Map<WrappedStack, EnergyValue> valuesPre = Helper.loadPre();
        iStack.func_77964_b(damageValue);
        int[] oreIDs = OreDictionary.getOreIDs((ItemStack)iStack);
        if (oreIDs.length == 0) {
            return;
        }
        for (int i : oreIDs) {
            WrappedStack w = WrappedStack.wrap((Object)new OreStack(OreDictionary.getOreName((int)i)));
            EnergyValue e = new EnergyValue(value);
            if (w == null || e == null || Float.compare(e.getValue(), 0.0f) <= 0) continue;
            if (valuesPre.containsKey(w)) {
                valuesPre.replace(w, e);
                continue;
            }
            valuesPre.put(w, e);
        }
        EnergyValueRegistry.getInstance().setShouldRegenNextRestart(true);
        Helper.savePre(valuesPre);
    }

    @Override
    public String func_71517_b() {
        return "add-ore-range";
    }

    @Override
    public String func_71518_a(ICommandSender cs) {
        return "Use command with no arguments.";
    }

    @Override
    public void func_71515_b(ICommandSender cs, String[] args) {
        this.resetFlag();
        try {
            switch (args.length) {
                case 0: {
                    Helper.toChatErr(cs, "add-ore-range <emcvalue>, Uses held item");
                    Helper.toChatErr(cs, "add-ore-range <id/name> <emcvalue> (DMG=0|N/A)");
                    Helper.toChatErr(cs, "add-ore-range <id/name> <damagevalue> <emcvalue>");
                    break;
                }
                case 1: {
                    if (cs instanceof EntityPlayer) {
                        EntityPlayer player = (EntityPlayer)cs;
                        ItemStack iStack = player.func_70694_bm();
                        if (iStack != null) {
                            String name = registryNames.func_148750_c((Object)iStack.func_77973_b());
                            float value = Float.parseFloat(args[0]);
                            int dmg = iStack.func_77960_j();
                            CommandAddOreRange.addOreRange(name, dmg, value);
                            Helper.toChat(cs, EnumChatFormatting.GREEN + "(+) ORE RANGE FOR: " + name);
                            break;
                        }
                        Helper.toChatErr(cs, "(X) Invalid item.");
                    }
                    break;
                }
                case 2: {
                    String name = Helper.getItemName(args[0]);
                    float value = Float.parseFloat(args[1]);
                    int dmg = 0;
                    if (name != null) {
                        CommandAddOreRange.addOreRange(name, dmg, value);
                        Helper.toChat(cs, EnumChatFormatting.GREEN + "(+) ORE RANGE FOR: " + name);
                        break;
                    }
                    Helper.toChatErr(cs, "(X) Invalid item.");
                    break;
                }
                case 3: {
                    String name = Helper.getItemName(args[0]);
                    int dmg = Integer.parseInt(args[1]);
                    float value = Float.parseFloat(args[2]);
                    if (name != null) {
                        CommandAddOreRange.addOreRange(name, dmg, value);
                        Helper.toChat(cs, EnumChatFormatting.GREEN + "(+) ORE RANGE FOR: " + name);
                        break;
                    }
                    Helper.toChatErr(cs, "(X) Invalid item.");
                    break;
                }
                default: {
                    Helper.toChatErr(cs, "Invalid number of arguments for operation.");
                    Helper.toChatErr(cs, "add-ore-range <emcvalue>, Uses held item");
                    Helper.toChatErr(cs, "add-ore-range <id/name> <emcvalue> (DMG=0|N/A)");
                    Helper.toChatErr(cs, "add-ore-range <id/name> <damagevalue> <emcvalue>");
                }
            }
        }
        catch (NumberFormatException e) {
            Helper.toChatErr(cs, "Non-number in numeric field.");
        }
    }
}

