/*
 * Decompiled with CFR 0.152.
 */
package com.rota.ee3help.commands;

import com.pahimar.ee3.api.exchange.EnergyValue;
import com.pahimar.ee3.exchange.EnergyValueRegistry;
import com.pahimar.ee3.exchange.OreStack;
import com.pahimar.ee3.exchange.WrappedStack;
import com.rota.ee3help.Helper;
import com.rota.ee3help.commands.CommandModifyBase;
import cpw.mods.fml.common.registry.GameData;
import java.util.Map;
import net.minecraft.command.ICommandSender;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.RegistryNamespaced;
import net.minecraftforge.oredict.OreDictionary;

public class CommandAddOre
extends CommandModifyBase {
    EnergyValueRegistry registryValues = EnergyValueRegistry.getInstance();
    RegistryNamespaced registryNames = GameData.getItemRegistry();

    private void addOre(String name, float value) {
        Map<WrappedStack, EnergyValue> valuesPre = Helper.loadPre();
        WrappedStack w = WrappedStack.wrap((Object)new OreStack(name));
        EnergyValue e = new EnergyValue(value);
        if (w != null && e != null && Float.compare(e.getValue(), 0.0f) > 0) {
            if (valuesPre.containsKey(w)) {
                valuesPre.replace(w, e);
            } else {
                valuesPre.put(w, e);
            }
        }
        EnergyValueRegistry.getInstance().setShouldRegenNextRestart(true);
        Helper.savePre(valuesPre);
    }

    @Override
    public String func_71517_b() {
        return "add-ore";
    }

    @Override
    public String func_71518_a(ICommandSender cs) {
        return "Use command with no arguments.";
    }

    @Override
    public void func_71515_b(ICommandSender cs, String[] args) {
        this.resetFlag();
        try {
            switch (args.length) {
                case 0: {
                    Helper.toChatErr(cs, "add-ore <orename> <emcvalue>");
                    break;
                }
                case 2: {
                    if (OreDictionary.doesOreNameExist((String)args[0])) {
                        this.addOre(args[0], Float.parseFloat(args[1]));
                        Helper.toChat(cs, EnumChatFormatting.GREEN + "(+) ORE: " + args[0]);
                        break;
                    }
                    Helper.toChatErr(cs, "(X) Invalid OreDict name.");
                    break;
                }
                default: {
                    Helper.toChatErr(cs, "Invalid number of arguments for operation.");
                    Helper.toChatErr(cs, "add-ore <orename> <emcvalue>");
                    break;
                }
            }
        }
        catch (NumberFormatException e) {
            Helper.toChatErr(cs, "Non-number in numeric field.");
        }
    }
}

