/*
 * Decompiled with CFR 0.152.
 */
package com.rota.ee3help;

import cpw.mods.fml.common.FMLLog;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.lang.reflect.Field;
import java.util.ArrayList;

public class Configuration {
    public static final String CONFIG_DIR = "config";
    public static final String CONFIG_NAME = "ee3h.cfg";
    File dir = new File("config");
    File config = new File("config" + File.separator + "ee3h.cfg");
    public static final String DESCRIPTION_AUTO_OREDICT = "Automatically add all Ore Dictionary entries for added items.";
    public boolean auto_oredict;

    public Configuration() {
        this.dir.mkdirs();
        if (!this.config.exists()) {
            this.setDefault();
            this.writeConfig();
            return;
        }
        this.readConfig();
    }

    public void setDefault() {
        this.auto_oredict = true;
    }

    public void writeConfig() {
        try {
            PrintWriter pw = new PrintWriter(this.config);
            pw.println("# Automatically add all Ore Dictionary entries for added items.");
            pw.print("auto_oredict = " + this.auto_oredict);
            pw.close();
        }
        catch (IOException e) {
            FMLLog.getLogger().error(e.getMessage() + "\n" + e.getStackTrace().toString());
        }
    }

    public void readConfig() {
        ArrayList<String> lines = new ArrayList<String>();
        try {
            BufferedReader br = new BufferedReader(new FileReader(this.config));
            String line = null;
            while ((line = br.readLine()) != null) {
                if ((line = line.trim()).startsWith("#") || line.isEmpty()) continue;
                lines.add(line.replaceAll("\\s", "").toLowerCase());
            }
            for (String s : lines) {
                String[] splitS = s.split("=");
                if (splitS.length != 2) continue;
                try {
                    Field f = this.getClass().getField(splitS[0]);
                    if (f.getType() != Boolean.TYPE) continue;
                    f.set(this, Boolean.parseBoolean(splitS[1]));
                }
                catch (NoSuchFieldException e) {
                    FMLLog.getLogger().error("Bogus entry in config. Regenerate/correct ee3h.cfg.");
                    this.setDefault();
                }
                catch (IllegalArgumentException e) {
                    FMLLog.getLogger().error("Non-boolean value for boolean configuration");
                    this.setDefault();
                }
                catch (SecurityException e) {
                    FMLLog.getLogger().error(e.getMessage());
                    this.setDefault();
                }
                catch (IllegalAccessException e) {
                    FMLLog.getLogger().error(e.getMessage());
                    this.setDefault();
                }
            }
            br.close();
        }
        catch (IOException e) {
            FMLLog.getLogger().error(e.getMessage() + "\n" + e.getStackTrace().toString());
            this.setDefault();
        }
    }
}

