/*
 * Decompiled with CFR 0.152.
 */
package flaxbeard.steamcraft.world;

import cpw.mods.fml.common.IWorldGenerator;
import flaxbeard.steamcraft.Config;
import flaxbeard.steamcraft.SteamcraftBlocks;
import java.util.Random;
import net.minecraft.init.Blocks;
import net.minecraft.world.World;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.gen.feature.WorldGenMinable;

public class SteamcraftOreGen
implements IWorldGenerator {
    public void generate(Random random, int chunkX, int chunkZ, World world, IChunkProvider chunkGenerator, IChunkProvider chunkProvider) {
        try {
            String zincDims = Config.zincDims.replaceAll("[a-zA-Z\\s]", "");
            String[] zincArray = zincDims.split(";");
            int[] zincIDs = new int[zincArray.length];
            for (int i = 0; i < zincArray.length; ++i) {
                zincIDs[i] = Integer.parseInt(zincArray[i]);
            }
            for (int id : zincIDs) {
                if (id != world.field_73011_w.field_76574_g) continue;
                this.generateExtra(world, random, chunkX * 16, chunkZ * 16, id);
            }
        }
        catch (NumberFormatException exception) {
            // empty catch block
        }
        try {
            String copperDims = Config.copperDims.replaceAll("[a-zA-Z\\s]", "");
            String[] copperArray = copperDims.split(";");
            int[] copperIDs = new int[copperArray.length];
            for (int i = 0; i < copperArray.length; ++i) {
                copperIDs[i] = Integer.parseInt(copperArray[i]);
            }
            for (int id : copperIDs) {
                if (id != world.field_73011_w.field_76574_g) continue;
                this.generateExtra(world, random, chunkX * 16, chunkZ * 16, id);
            }
        }
        catch (NumberFormatException exception) {
            // empty catch block
        }
        switch (world.field_73011_w.field_76574_g) {
            case -1: {
                this.generateNether(world, random, chunkX * 16, chunkZ * 16);
                break;
            }
            case 0: {
                this.generateSurface(world, random, chunkX * 16, chunkZ * 16);
                break;
            }
            case 1: {
                this.generateEnd(world, random, chunkX * 16, chunkZ * 16);
            }
        }
    }

    private void generateEnd(World world, Random random, int i, int j) {
        int z;
        int y;
        int x;
        int k;
        if (Config.genCopperEnd) {
            for (k = 0; k < 10; ++k) {
                x = i + random.nextInt(16);
                y = random.nextInt(128);
                z = j + random.nextInt(16);
                new WorldGenMinable(SteamcraftBlocks.steamcraftOre, 0, 10, Blocks.field_150377_bs).func_76484_a(world, random, x, y, z);
            }
        }
        if (Config.genZincEnd) {
            for (k = 0; k < 10; ++k) {
                x = i + random.nextInt(16);
                y = random.nextInt(128);
                z = j + random.nextInt(16);
                new WorldGenMinable(SteamcraftBlocks.steamcraftOre, 1, 7, Blocks.field_150377_bs).func_76484_a(world, random, x, y, z);
            }
        }
    }

    private void generateSurface(World world, Random random, int i, int j) {
        int z;
        int y;
        int x;
        int k;
        if (Config.genCopperOverworld) {
            for (k = 0; k < 10; ++k) {
                x = i + random.nextInt(16);
                y = random.nextInt(80);
                z = j + random.nextInt(16);
                new WorldGenMinable(SteamcraftBlocks.steamcraftOre, 0, 10, Blocks.field_150348_b).func_76484_a(world, random, x, y, z);
            }
        }
        if (Config.genZincOverworld) {
            for (k = 0; k < 10; ++k) {
                x = i + random.nextInt(16);
                y = random.nextInt(75);
                z = j + random.nextInt(16);
                new WorldGenMinable(SteamcraftBlocks.steamcraftOre, 1, 7, Blocks.field_150348_b).func_76484_a(world, random, x, y, z);
            }
        }
    }

    private void generateNether(World world, Random random, int i, int j) {
        int z;
        int y;
        int x;
        int k;
        if (Config.genCopperNether) {
            for (k = 0; k < 10; ++k) {
                x = i + random.nextInt(16);
                y = random.nextInt(128);
                z = j + random.nextInt(16);
                new WorldGenMinable(SteamcraftBlocks.steamcraftOre, 0, 10, Blocks.field_150424_aL).func_76484_a(world, random, x, y, z);
            }
        }
        if (Config.genZincNether) {
            for (k = 0; k < 10; ++k) {
                x = i + random.nextInt(16);
                y = random.nextInt(128);
                z = j + random.nextInt(16);
                new WorldGenMinable(SteamcraftBlocks.steamcraftOre, 1, 7, Blocks.field_150424_aL).func_76484_a(world, random, x, y, z);
            }
        }
    }

    private void generateExtra(World world, Random random, int i, int j, int id) {
        if (this.checkConfigForInvalidIntegers(id)) {
            int z;
            int y;
            int x;
            int k;
            if (Config.genZincExtras) {
                for (k = 0; k < 10; ++k) {
                    x = i + random.nextInt(16);
                    y = random.nextInt(128);
                    z = j + random.nextInt(16);
                    new WorldGenMinable(SteamcraftBlocks.steamcraftOre, 1, 7, Blocks.field_150348_b).func_76484_a(world, random, x, y, z);
                }
            }
            if (Config.genCopperExtras) {
                for (k = 0; k < 10; ++k) {
                    x = i + random.nextInt(16);
                    y = random.nextInt(128);
                    z = j + random.nextInt(16);
                    new WorldGenMinable(SteamcraftBlocks.steamcraftOre, 0, 7, Blocks.field_150348_b).func_76484_a(world, random, x, y, z);
                }
            }
        }
    }

    public boolean checkConfigForInvalidIntegers(int id) {
        return id != 0 && id != -1 && id != 1;
    }
}

