/*
 * Decompiled with CFR 0.152.
 */
package flaxbeard.steamcraft.tile;

import flaxbeard.steamcraft.Config;
import flaxbeard.steamcraft.SteamcraftBlocks;
import flaxbeard.steamcraft.api.ISteamTransporter;
import flaxbeard.steamcraft.api.IWrenchDisplay;
import flaxbeard.steamcraft.api.IWrenchable;
import flaxbeard.steamcraft.api.steamnet.SteamNetwork;
import flaxbeard.steamcraft.api.tile.SteamTransporterTileEntity;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S35PacketUpdateTileEntity;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.oredict.OreDictionary;
import org.lwjgl.opengl.GL11;

public class TileEntitySmasher
extends SteamTransporterTileEntity
implements ISteamTransporter,
IWrenchable,
IWrenchDisplay {
    public static final SmashablesRegistry REGISTRY = new SmashablesRegistry();
    public int spinup = 0;
    public float extendedLength = 0.0f;
    public Block smooshingBlock;
    public int smooshingMeta;
    public int extendedTicks = 0;
    public ArrayList<ItemStack> smooshedStack;
    private boolean hasBlockUpdate = false;
    private boolean isActive = false;
    private boolean isBreaking = false;
    private boolean shouldStop = false;
    private boolean isInitialized = false;
    private boolean running = false;
    private boolean smashNextRound = false;
    private boolean noSmashDrops = false;
    private boolean hasBeenSet = false;

    public TileEntitySmasher() {
        super(ForgeDirection.VALID_DIRECTIONS);
    }

    @Override
    public void func_145839_a(NBTTagCompound access) {
        super.func_145839_a(access);
        this.extendedLength = access.func_74760_g("extendedLength");
        this.extendedTicks = access.func_74762_e("extendedTicks");
        this.spinup = access.func_74762_e("spinup");
        this.noSmashDrops = access.func_74767_n("noSmashDrops");
        this.hasBeenSet = access.func_74767_n("hasBeenSet");
        this.smooshingBlock = Block.func_149729_e((int)access.func_74762_e("block"));
        this.smooshingMeta = access.func_74762_e("smooshingMeta");
        NBTTagList nbttaglist = (NBTTagList)access.func_74781_a("Items");
        this.smooshedStack = new ArrayList();
        for (int i = 0; i < nbttaglist.func_74745_c(); ++i) {
            NBTTagCompound nbttagcompound1 = nbttaglist.func_150305_b(i);
            this.smooshedStack.add(ItemStack.func_77949_a((NBTTagCompound)nbttagcompound1));
        }
    }

    @Override
    public void func_145841_b(NBTTagCompound access) {
        super.func_145841_b(access);
        access.func_74757_a("noSmashDrops", this.noSmashDrops);
        access.func_74757_a("hasBeenSet", this.hasBeenSet);
        access.func_74768_a("spinup", this.spinup);
        access.func_74776_a("extendedLength", this.extendedLength);
        access.func_74768_a("extendedTicks", this.extendedTicks);
        access.func_74768_a("block", Block.func_149682_b((Block)this.smooshingBlock));
        access.func_74768_a("smooshingMeta", this.smooshingMeta);
        NBTTagList nbttaglist = new NBTTagList();
        if (this.smooshedStack != null) {
            for (int i = 0; i < this.smooshedStack.size(); ++i) {
                NBTTagCompound nbttagcompound1 = new NBTTagCompound();
                this.smooshedStack.get(i).func_77955_b(nbttagcompound1);
                nbttaglist.func_74742_a((NBTBase)nbttagcompound1);
            }
        }
        access.func_74782_a("Items", (NBTBase)nbttaglist);
    }

    @Override
    public Packet func_145844_m() {
        NBTTagCompound access = super.getDescriptionTag();
        access.func_74768_a("spinup", this.spinup);
        access.func_74776_a("extendedLength", this.extendedLength);
        access.func_74768_a("extendedTicks", this.extendedTicks);
        access.func_74768_a("block", Block.func_149682_b((Block)this.smooshingBlock));
        access.func_74768_a("smooshingMeta", this.smooshingMeta);
        access.func_74757_a("running", this.running);
        access.func_74757_a("noSmashDrops", this.noSmashDrops);
        access.func_74757_a("hasBeenSet", this.hasBeenSet);
        return new S35PacketUpdateTileEntity(this.field_145851_c, this.field_145848_d, this.field_145849_e, 1, access);
    }

    private void decodeAndCreateParticles(int flags) {
        if (this.field_145850_b.field_72995_K) {
            int[] tgt = this.getTarget(1);
            int x = tgt[0];
            int y = this.field_145848_d;
            int z = tgt[1];
            if (this.extendedTicks > 15) {
                float xV = 0.0f;
                float zV = 0.0f;
                double xO = 0.0;
                double zO = 0.0;
                switch (this.func_145832_p()) {
                    case 2: {
                        zV = 0.05f;
                        zO = 0.1;
                        break;
                    }
                    case 3: {
                        zV = -0.05f;
                        zO = -0.1;
                        break;
                    }
                    case 4: {
                        xV = 0.05f;
                        xO = 0.1;
                        break;
                    }
                    case 5: {
                        xV = -0.05f;
                        xO = -0.1;
                        break;
                    }
                }
                this.field_145850_b.func_72869_a("smoke", (double)this.field_145851_c + 0.5 + xO, (double)y + 1.1, (double)this.field_145849_e + 0.5 + zO, (double)xV, (double)0.05f, (double)zV);
            }
        }
    }

    @Override
    public void onDataPacket(NetworkManager net, S35PacketUpdateTileEntity pkt) {
        super.onDataPacket(net, pkt);
        NBTTagCompound access = pkt.func_148857_g();
        this.extendedLength = access.func_74760_g("extendedLength");
        this.extendedTicks = access.func_74762_e("extendedTicks");
        this.spinup = access.func_74762_e("spinup");
        this.smooshingBlock = Block.func_149729_e((int)access.func_74762_e("block"));
        this.smooshingMeta = access.func_74762_e("smooshingMeta");
        this.running = access.func_74767_n("running");
        this.noSmashDrops = access.func_74767_n("noSmashDrops");
        this.hasBeenSet = access.func_74767_n("hasBeenSet");
        this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
    }

    @Override
    public void func_145845_h() {
        int y;
        if (!this.isInitialized) {
            ForgeDirection myDir = this.myDir();
            this.addSideToGaugeBlacklist(myDir);
            ForgeDirection[] directions = new ForgeDirection[5];
            int i = 0;
            for (ForgeDirection direction : ForgeDirection.values()) {
                if (direction == myDir || direction == ForgeDirection.UP) continue;
                directions[i] = direction;
                ++i;
            }
            this.setDistributionDirections(directions);
            this.isInitialized = true;
            if (!this.field_145850_b.field_72995_K) {
                // empty if block
            }
        }
        super.func_145845_h();
        if (!this.field_145850_b.field_72995_K) {
            int[] target = this.getTarget(1);
            int x = target[0];
            y = this.field_145848_d;
            int z = target[1];
            if (this.spinup == 1) {
                this.field_145850_b.func_72908_a((double)((float)this.field_145851_c + 0.5f), (double)((float)this.field_145848_d + 0.5f), (double)((float)this.field_145849_e + 0.5f), "steamcraft:hiss", Block.field_149788_p.func_150497_c(), 0.9f);
            }
            if (this.extendedTicks > 15) {
                this.field_145850_b.func_72908_a((double)((float)this.field_145851_c + 0.5f), (double)((float)this.field_145848_d + 0.5f), (double)((float)this.field_145849_e + 0.5f), "steamcraft:leaking", 2.0f, 0.9f);
            }
            if (this.extendedTicks == 5) {
                this.field_145850_b.func_72908_a((double)((float)this.field_145851_c + 0.5f), (double)((float)this.field_145848_d + 0.5f), (double)((float)this.field_145849_e + 0.5f), "random.break", 0.5f, (float)(0.75 + Math.random() * (double)0.1f));
            }
            if (this.extendedTicks > 0 && this.extendedTicks < 6 && this.smooshingBlock != null && this.smooshingBlock.field_149762_H != null) {
                this.field_145850_b.func_72908_a((double)((float)this.field_145851_c + 0.5f), (double)((float)this.field_145848_d + 0.5f), (double)((float)this.field_145849_e + 0.5f), this.smooshingBlock.field_149762_H.func_150495_a(), 0.5f, (float)(0.75 + Math.random() * (double)0.1f));
            }
            if (this.shouldStop) {
                this.spinup = 0;
                this.extendedLength = 0.0f;
                this.extendedTicks = 0;
                this.isActive = false;
                this.shouldStop = false;
                this.isBreaking = false;
                this.running = false;
                this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
                return;
            }
            if (!this.smashNextRound && this.hasSomethingToSmash() && this.hasPartner() && this.getSteamShare() > 1000 && !this.isActive) {
                this.smashNextRound = true;
                return;
            }
            boolean smashThisRound = false;
            if (this.smashNextRound) {
                smashThisRound = true;
                this.smashNextRound = false;
            }
            if (smashThisRound && this.hasSomethingToSmash() && !this.isActive) {
                this.decrSteam(1000);
                this.running = true;
                this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
                this.isActive = true;
                this.isBreaking = true;
            }
            if (this.isActive) {
                if (this.isBreaking) {
                    TileEntitySmasher partner;
                    if (!this.hasSomethingToSmash() && this.spinup < 40 && this.func_145832_p() % 2 == 0) {
                        this.shouldStop = true;
                        int[] tc = this.getTarget(2);
                        partner = (TileEntitySmasher)this.field_145850_b.func_147438_o(tc[0], this.field_145848_d, tc[1]);
                        partner.shouldStop = true;
                        return;
                    }
                    if (this.spinup < 41) {
                        if (this.spinup == 40) {
                            if (!this.field_145850_b.func_147437_c(x, y, z) && this.field_145850_b.func_147439_a(x, y, z) != Blocks.field_150357_h && this.field_145850_b.func_147438_o(x, y, z) == null && this.field_145850_b.func_147439_a(x, y, z).func_149712_f(this.field_145850_b, x, y, z) < 50.0f) {
                                ++this.spinup;
                                if (this.func_145832_p() % 2 == 0) {
                                    try {
                                        this.smooshingBlock = this.field_145850_b.func_147439_a(x, y, z);
                                        this.smooshingMeta = this.field_145850_b.func_72805_g(x, y, z);
                                        this.smooshedStack = this.smooshingBlock.getDrops(this.field_145850_b, x, y, z, this.smooshingMeta, 0);
                                    }
                                    catch (Exception e) {
                                        e.printStackTrace();
                                    }
                                    this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
                                    this.field_145850_b.func_147449_b(x, y, z, SteamcraftBlocks.dummy);
                                }
                            } else if (this.hasPartner()) {
                                int[] pc = this.getTarget(2);
                                partner = (TileEntitySmasher)this.field_145850_b.func_147438_o(pc[0], this.field_145848_d, pc[1]);
                                if (partner.spinup < 41) {
                                    this.shouldStop = true;
                                }
                                if (partner.spinup >= 41 && partner.shouldStop) {
                                    this.shouldStop = true;
                                }
                                if (this.shouldStop) {
                                    ++this.spinup;
                                    return;
                                }
                            }
                        }
                        ++this.spinup;
                    } else if (this.extendedLength < 0.5f && !this.shouldStop) {
                        this.extendedLength += 0.1f;
                        if (this.extendedTicks == 3 && this.func_145832_p() % 2 == 0 && !this.field_145850_b.field_72995_K) {
                            this.spawnItems(x, y, z);
                        }
                        ++this.extendedTicks;
                    } else {
                        this.isBreaking = false;
                        this.spinup = 0;
                    }
                } else if (this.extendedLength > 0.0f) {
                    this.extendedLength -= 0.025f;
                    ++this.extendedTicks;
                    if (this.extendedLength < 0.0f) {
                        this.extendedLength = 0.0f;
                    }
                } else {
                    this.isActive = false;
                    this.running = false;
                    this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
                    this.extendedTicks = 0;
                    if (this.field_145850_b.func_147439_a(x, y, z) == SteamcraftBlocks.dummy) {
                        this.field_145850_b.func_147468_f(x, y, z);
                    }
                }
            } else if (this.field_145850_b.func_147439_a(x, y, z) == SteamcraftBlocks.dummy && this.func_145832_p() % 2 == 0) {
                this.field_145850_b.func_147468_f(x, y, z);
            }
        } else if (this.running) {
            this.decodeAndCreateParticles(1);
            if (this.spinup < 40) {
                ++this.spinup;
            } else if (this.spinup == 40) {
                int[] tc = this.getTarget(1);
                int x = tc[0];
                y = tc[1];
                int z = tc[2];
                ++this.spinup;
                if (!this.field_145850_b.func_147437_c(x, y, z) && this.field_145850_b.func_147438_o(x, y, z) == null && this.field_145850_b.func_147439_a(x, y, z).func_149712_f(this.field_145850_b, x, y, z) < 50.0f && this.func_145832_p() % 2 == 0) {
                    try {
                        this.smooshingBlock = this.field_145850_b.func_147439_a(x, y, z);
                        this.smooshingMeta = this.field_145850_b.func_72805_g(x, y, z);
                    }
                    catch (Exception e) {}
                }
            } else if (this.extendedTicks < 25) {
                ++this.extendedTicks;
            }
        } else {
            this.spinup = 0;
            this.extendedTicks = 0;
        }
    }

    private void spawnItems(int x, int y, int z) {
        if (this.smooshedStack != null) {
            for (ItemStack stack : this.smooshedStack) {
                EntityItem entityItem;
                boolean isSmashableOre;
                ItemStack output = REGISTRY.getOutput(stack);
                boolean bl = isSmashableOre = output != null;
                if (Block.func_149634_a((Item)stack.func_77973_b()) == Blocks.field_150347_e && !this.noSmashDrops) {
                    output = new ItemStack(Blocks.field_150351_n);
                } else if (Block.func_149634_a((Item)stack.func_77973_b()) == Blocks.field_150351_n && !this.noSmashDrops) {
                    output = new ItemStack((Block)Blocks.field_150354_m);
                }
                if (isSmashableOre && !this.noSmashDrops) {
                    if (this.field_145850_b.field_73012_v.nextInt(Config.chance) == 0) {
                        output.field_77994_a *= 2;
                    }
                    entityItem = new EntityItem(this.field_145850_b, (double)((float)x + 0.5f), (double)((float)y + 0.1f), (double)((float)z + 0.5f), output);
                    this.field_145850_b.func_72838_d((Entity)entityItem);
                    this.smooshedStack = null;
                    continue;
                }
                if (output != null) {
                    entityItem = new EntityItem(this.field_145850_b, (double)((float)x + 0.5f), (double)((float)y + 0.1f), (double)((float)z + 0.5f), output);
                    this.field_145850_b.func_72838_d((Entity)entityItem);
                    this.smooshedStack = null;
                    continue;
                }
                if (output != null) continue;
                output = stack;
                entityItem = new EntityItem(this.field_145850_b, (double)((float)x + 0.5f), (double)((float)y + 0.1f), (double)((float)z + 0.5f), output);
                this.field_145850_b.func_72838_d((Entity)entityItem);
            }
        }
    }

    private boolean hasSomethingToSmash() {
        int z;
        int y;
        int[] target = this.getTarget(1);
        int x = target[0];
        return !this.field_145850_b.func_147437_c(x, y = this.field_145848_d, z = target[1]) && this.field_145850_b.func_147439_a(x, y, z) != Blocks.field_150357_h && this.field_145850_b.func_147438_o(x, y, z) == null && this.field_145850_b.func_147439_a(x, y, z).func_149712_f(this.field_145850_b, x, y, z) < 50.0f;
    }

    public boolean hasPartner() {
        int[] target = this.getTarget(2);
        int x = target[0];
        int y = this.field_145848_d;
        int z = target[1];
        int opposite = target[2];
        if (this.field_145850_b.func_147439_a(x, y, z) == SteamcraftBlocks.smasher && ((TileEntitySmasher)this.field_145850_b.func_147438_o(x, y, z)).getSteamShare() > 100 && this.field_145850_b.func_72805_g(x, y, z) == opposite) {
            TileEntitySmasher partner = (TileEntitySmasher)this.field_145850_b.func_147438_o(x, y, z);
            if (partner.noSmashDrops != this.noSmashDrops) {
                if (this.hasBeenSet && !partner.hasBeenSet) {
                    partner.noSmashDrops = this.noSmashDrops;
                } else {
                    this.noSmashDrops = !this.hasBeenSet && partner.hasBeenSet ? partner.noSmashDrops : partner.noSmashDrops;
                }
                this.hasBeenSet = true;
                partner.hasBeenSet = true;
            }
            return true;
        }
        return false;
    }

    private int[] getTarget(int distance) {
        int x = this.field_145851_c;
        int z = this.field_145849_e;
        int opposite = 0;
        int meta = this.func_145832_p();
        opposite = meta % 2 == 0 ? meta + 1 : meta - 1;
        switch (meta) {
            case 2: {
                z -= distance;
                opposite = 3;
                break;
            }
            case 3: {
                z += distance;
                opposite = 2;
                break;
            }
            case 4: {
                x -= distance;
                opposite = 5;
                break;
            }
            case 5: {
                x += distance;
                opposite = 4;
                break;
            }
        }
        return new int[]{x, z, opposite};
    }

    public void blockUpdate() {
        this.hasBlockUpdate = true;
    }

    public boolean hasUpdate() {
        return this.hasBlockUpdate;
    }

    public ForgeDirection myDir() {
        int meta = this.field_145850_b.func_72805_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        switch (meta) {
            case 2: {
                return ForgeDirection.NORTH;
            }
            case 3: {
                return ForgeDirection.SOUTH;
            }
            case 4: {
                return ForgeDirection.WEST;
            }
            case 5: {
                return ForgeDirection.EAST;
            }
        }
        return ForgeDirection.NORTH;
    }

    @Override
    public boolean onWrench(ItemStack stack, EntityPlayer player, World world, int x, int y, int z, int side, float xO, float yO, float zO) {
        if (player.func_70093_af()) {
            this.hasBeenSet = true;
            this.noSmashDrops = !this.noSmashDrops;
            int[] target = this.getTarget(2);
            int x2 = target[0];
            int y2 = this.field_145848_d;
            int z2 = target[1];
            int opposite = target[2];
            if (this.field_145850_b.func_147439_a(x2, y2, z2) == SteamcraftBlocks.smasher && this.field_145850_b.func_72805_g(x2, y2, z2) == opposite) {
                ((TileEntitySmasher)this.field_145850_b.func_147438_o((int)x2, (int)y2, (int)z2)).noSmashDrops = this.noSmashDrops;
                ((TileEntitySmasher)this.field_145850_b.func_147438_o((int)x2, (int)y2, (int)z2)).hasBeenSet = true;
                this.field_145850_b.func_147471_g(x2, y2, z2);
            }
            this.field_145850_b.func_147471_g(x, y, z);
            return true;
        }
        int steam = this.getSteamShare();
        this.getNetwork().split(this, true);
        ForgeDirection[] directions = new ForgeDirection[5];
        int i = 0;
        for (ForgeDirection direction : ForgeDirection.values()) {
            if (direction == this.myDir() || direction == ForgeDirection.UP) continue;
            directions[i] = direction;
            ++i;
        }
        this.setDistributionDirections(directions);
        SteamNetwork.newOrJoin(this);
        this.getNetwork().addSteam(steam);
        return true;
    }

    @Override
    public void displayWrench(RenderGameOverlayEvent.Post event) {
        GL11.glPushMatrix();
        int color = Minecraft.func_71410_x().field_71439_g.func_70093_af() ? 0xC6C6C6 : 0x777777;
        int x = event.resolution.func_78326_a() / 2 - 8;
        int y = event.resolution.func_78328_b() / 2 - 8;
        Minecraft.func_71410_x().field_71466_p.func_78261_a(StatCollector.func_74838_a((String)("steamcraft.smasher." + this.noSmashDrops)), x + 15, y + 13, color);
        GL11.glPopMatrix();
    }

    public static class SmashablesRegistry {
        private final Map<Item, ItemStack> wildcards = new HashMap<Item, ItemStack>();
        private final Map<String, ItemStack> oreDicts = new HashMap<String, ItemStack>();
        private final Map<ItemStack, ItemStack> registry = new HashMap<ItemStack, ItemStack>();

        public ItemStack getOutput(ItemStack input) {
            ItemStack output;
            block5: {
                block4: {
                    if (input == null) {
                        return null;
                    }
                    output = null;
                    if (input.func_77960_j() != Short.MAX_VALUE) break block4;
                    output = this.wildcards.get(input.func_77973_b());
                    break block5;
                }
                int[] ids = OreDictionary.getOreIDs((ItemStack)input);
                if (ids != null && ids.length > 0) {
                    int id;
                    int[] arr$ = ids;
                    int len$ = arr$.length;
                    for (int i$ = 0; i$ < len$ && (output = this.oreDicts.get(OreDictionary.getOreName((int)(id = arr$[i$])))) == null; ++i$) {
                    }
                }
                if (output != null) break block5;
                for (Map.Entry<ItemStack, ItemStack> entry : this.registry.entrySet()) {
                    if (ItemStack.func_77989_b((ItemStack)entry.getKey(), (ItemStack)input) && (output = entry.getValue()) != null) break;
                }
            }
            return ItemStack.func_77944_b((ItemStack)output);
        }

        public void registerSmashable(String input, ItemStack output) {
            this.oreDicts.put(input, output);
        }

        public void registerSmashable(Block input, ItemStack output) {
            this.registerSmashable(new ItemStack(input, 1, Short.MAX_VALUE), output);
        }

        public void registerSmashable(Item input, ItemStack output) {
            this.registerSmashable(new ItemStack(input, 1, Short.MAX_VALUE), output);
        }

        public void registerSmashable(ItemStack input, ItemStack output) {
            if (input.func_77960_j() == Short.MAX_VALUE) {
                this.wildcards.put(input.func_77973_b(), output);
            } else {
                this.registry.put(input, output);
            }
        }
    }
}

