/*
 * Decompiled with CFR 0.152.
 */
package flaxbeard.steamcraft.tile;

import flaxbeard.steamcraft.api.ISteamTransporter;
import flaxbeard.steamcraft.block.BlockRuptureDisc;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S35PacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.util.ForgeDirection;

public class TileEntityRuptureDisc
extends TileEntity {
    private boolean isLeaking = false;

    public Packet func_145844_m() {
        NBTTagCompound access = new NBTTagCompound();
        access.func_74757_a("isLeaking", this.isLeaking);
        return new S35PacketUpdateTileEntity(this.field_145851_c, this.field_145848_d, this.field_145849_e, 1, access);
    }

    public void onDataPacket(NetworkManager net, S35PacketUpdateTileEntity pkt) {
        super.onDataPacket(net, pkt);
        NBTTagCompound access = pkt.func_148857_g();
        this.isLeaking = access.func_74767_n("isLeaking");
        this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
    }

    public void func_145845_h() {
        if (this.field_145850_b.field_72995_K) {
            if (this.isLeaking) {
                float offset = 0.625f;
                float xOffset = (float)this.myDir().getOpposite().offsetX * offset;
                float yOffset = (float)this.myDir().getOpposite().offsetY * offset;
                float zOffset = (float)this.myDir().getOpposite().offsetZ * offset;
                this.field_145850_b.func_72869_a("smoke", (double)((float)this.field_145851_c + 0.5f + xOffset), (double)((float)this.field_145848_d + 0.5f + yOffset), (double)((float)this.field_145849_e + 0.5f + zOffset), (double)((float)this.myDir().offsetX * 0.1f), (double)((float)this.myDir().offsetY * 0.1f), (double)((float)this.myDir().offsetZ * 0.1f));
            }
        } else {
            if (this.getPressure() > 1.1f && this.field_145850_b.func_72805_g(this.field_145851_c, this.field_145848_d, this.field_145849_e) < 6) {
                this.field_145850_b.func_72876_a(null, (double)((float)this.field_145851_c + 0.5f), (double)((float)this.field_145848_d + 0.5f), (double)((float)this.field_145849_e + 0.5f), 0.0f, true);
                this.field_145850_b.func_72921_c(this.field_145851_c, this.field_145848_d, this.field_145849_e, this.field_145850_b.func_72805_g(this.field_145851_c, this.field_145848_d, this.field_145849_e) + 10, 2);
            }
            if (this.field_145850_b.func_72805_g(this.field_145851_c, this.field_145848_d, this.field_145849_e) > 9) {
                int i = 0;
                if (this.getSteam() > 0) {
                    if (!this.isLeaking) {
                        this.isLeaking = true;
                        this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
                    }
                    this.field_145850_b.func_72908_a((double)((float)this.field_145851_c + 0.5f), (double)((float)this.field_145848_d + 0.5f), (double)((float)this.field_145849_e + 0.5f), "steamcraft:leaking", 2.0f, 0.9f);
                } else if (this.isLeaking) {
                    this.isLeaking = false;
                    this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
                }
                while (this.getSteam() > 0 && i < 10) {
                    this.drainSteam(10);
                    float offset = 0.625f;
                    float xOffset = (float)this.myDir().getOpposite().offsetX * offset;
                    float yOffset = (float)this.myDir().getOpposite().offsetY * offset;
                    float zOffset = (float)this.myDir().getOpposite().offsetZ * offset;
                    ++i;
                }
            } else if (this.isLeaking) {
                this.isLeaking = false;
                this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
            }
        }
    }

    private void drainSteam(int s) {
        ForgeDirection d = this.myDir().getOpposite();
        ISteamTransporter source = null;
        TileEntity te = this.field_145850_b.func_147438_o(this.field_145851_c + d.offsetX, this.field_145848_d, this.field_145849_e + d.offsetZ);
        if (te != null && te instanceof ISteamTransporter) {
            source = (ISteamTransporter)te;
            source.decrSteam(s);
        }
    }

    private int getSteam() {
        ForgeDirection d = this.myDir().getOpposite();
        ISteamTransporter source = null;
        TileEntity te = this.field_145850_b.func_147438_o(this.field_145851_c + d.offsetX, this.field_145848_d, this.field_145849_e + d.offsetZ);
        if (te != null && te instanceof ISteamTransporter) {
            source = (ISteamTransporter)te;
            if (this.field_145850_b.field_72995_K) {
                // empty if block
            }
            return source.getSteamShare();
        }
        return 0;
    }

    private float getPressure() {
        ForgeDirection d = this.myDir().getOpposite();
        ISteamTransporter source = null;
        TileEntity te = this.field_145850_b.func_147438_o(this.field_145851_c + d.offsetX, this.field_145848_d, this.field_145849_e + d.offsetZ);
        if (te != null && te instanceof ISteamTransporter) {
            source = (ISteamTransporter)te;
            return source.getPressure();
        }
        return 0.0f;
    }

    private ForgeDirection myDir() {
        return ForgeDirection.getOrientation((int)BlockRuptureDisc.getMeta(this.field_145850_b.func_72805_g(this.field_145851_c, this.field_145848_d, this.field_145849_e)));
    }
}

