/*
 * Decompiled with CFR 0.152.
 */
package flaxbeard.steamcraft.integration;

import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.relauncher.ReflectionHelper;
import flaxbeard.steamcraft.Config;
import flaxbeard.steamcraft.SteamcraftItems;
import flaxbeard.steamcraft.api.SteamcraftRegistry;
import flaxbeard.steamcraft.api.book.BookRecipeRegistry;
import flaxbeard.steamcraft.api.exosuit.ExosuitPlate;
import flaxbeard.steamcraft.api.exosuit.UtilPlates;
import flaxbeard.steamcraft.integration.thaumcraft.LifeEssenceCap;
import flaxbeard.steamcraft.item.ItemExosuitArmor;
import java.lang.reflect.Method;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.DamageSource;
import net.minecraft.world.WorldSavedData;
import net.minecraft.world.WorldServer;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.oredict.ShapedOreRecipe;

public class BloodMagicIntegration {
    public static Item reinforcedSlate;
    public static Block runeOfSelfSacrifice;

    public static void clickLeft(PlayerInteractEvent event) {
        if (!(event.world.field_72995_K || event.action != PlayerInteractEvent.Action.RIGHT_CLICK_AIR && event.action != PlayerInteractEvent.Action.RIGHT_CLICK_BLOCK)) {
            try {
                Class<?> energyBatteryClass = Class.forName("WayofTime.alchemicalWizardry.common.items.EnergyBattery");
                if (event.entityPlayer.func_70694_bm() != null && energyBatteryClass.isInstance(event.entityPlayer.func_70694_bm().func_77973_b())) {
                    LifeEssenceCap data = BloodMagicIntegration.getData(event.entityPlayer.func_70005_c_());
                    int cap = (Integer)ReflectionHelper.getPrivateValue(energyBatteryClass, (Object)event.entityPlayer.func_70694_bm().func_77973_b(), (int)0);
                    if (cap > data.cap) {
                        data.cap = cap;
                        data.func_76185_a();
                    }
                }
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
    }

    public static LifeEssenceCap getData(String name) {
        WorldServer world = MinecraftServer.func_71276_C().field_71305_c[0];
        LifeEssenceCap data = (LifeEssenceCap)world.func_72943_a(LifeEssenceCap.class, name + "cap");
        if (data == null) {
            data = new LifeEssenceCap(name + "cap");
            world.func_72823_a(name + "cap", (WorldSavedData)data);
        }
        return data;
    }

    public static void grabItems() {
        reinforcedSlate = GameRegistry.findItem((String)"AWWayofTime", (String)"reinforcedSlate");
        runeOfSelfSacrifice = GameRegistry.findBlock((String)"AWWayofTime", (String)"runeOfSelfSacrifice");
    }

    public static void addBloodMagicStuff() {
        if (Config.enableSadistPlate) {
            SteamcraftRegistry.addExosuitPlate(new ExosuitPlate("Sadist", new ItemStack(SteamcraftItems.exosuitPlate, 1, 10), "Sadist", "Sadist", "steamcraft.plate.sadist", new DamageSource[0]));
            BookRecipeRegistry.addRecipe("exoSadist", (IRecipe)new ShapedOreRecipe(new ItemStack(SteamcraftItems.exosuitPlate, 1, 10), new Object[]{" s ", "sbs", " s ", Character.valueOf('s'), reinforcedSlate, Character.valueOf('b'), runeOfSelfSacrifice}));
        }
    }

    public static void handleAttack(LivingHurtEvent event) {
        if (event.entityLiving instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)event.entityLiving;
            int bmPlates = 0;
            for (int i = 0; i < player.field_71071_by.field_70460_b.length; ++i) {
                ItemExosuitArmor armorItem;
                ItemStack armor = player.field_71071_by.field_70460_b[i];
                if (armor == null || !(armor.func_77973_b() instanceof ItemExosuitArmor) || !(armorItem = (ItemExosuitArmor)armor.func_77973_b()).hasPlates(armor) || UtilPlates.getPlate(armor.field_77990_d.func_74779_i("plate")).getIdentifier() != "Sadist") continue;
                ++bmPlates;
            }
            if (bmPlates > 0) {
                try {
                    Class<?> energyItemsClass = Class.forName("WayofTime.alchemicalWizardry.common.items.EnergyItems");
                    int lp = (int)event.ammount * 12 * bmPlates;
                    Method addEssence = energyItemsClass.getMethod("addEssenceToMaximum", String.class, Integer.TYPE, Integer.TYPE);
                    addEssence.invoke(energyItemsClass, player.func_70005_c_(), lp, BloodMagicIntegration.getData((String)player.func_70005_c_()).cap);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }
}

