/*
 * Decompiled with CFR 0.152.
 */
package flaxbeard.steamcraft.api.book;

import cpw.mods.fml.relauncher.ReflectionHelper;
import flaxbeard.steamcraft.api.book.BookPage;
import flaxbeard.steamcraft.api.book.BookRecipeRegistry;
import flaxbeard.steamcraft.api.book.ICraftingPage;
import flaxbeard.steamcraft.gui.GuiSteamcraftBook;
import java.util.ArrayList;
import java.util.Collection;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.entity.RenderItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.ShapedRecipes;
import net.minecraft.item.crafting.ShapelessRecipes;
import net.minecraft.util.MathHelper;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.oredict.ShapedOreRecipe;
import net.minecraftforge.oredict.ShapelessOreRecipe;
import org.apache.commons.lang3.ArrayUtils;

public class BookPageCrafting
extends BookPage
implements ICraftingPage {
    private static final ResourceLocation craftSquareTexture = new ResourceLocation("steamcraft:textures/gui/craftingSquare.png");
    private ItemStack output;
    private Object[] inputs = new Object[9];
    private boolean shapeless = false;
    private IRecipe[] recipe;

    public BookPageCrafting(String string, boolean shape, ItemStack op, Object ... ip) {
        super(string);
        this.output = op;
        this.inputs = ip;
        this.shapeless = shape;
    }

    public BookPageCrafting(String string, ItemStack op, Object ... ip) {
        super(string);
        this.output = op;
        this.inputs = ip;
    }

    public BookPageCrafting(String string, String ... keys) {
        this(string, BookPageCrafting.getRecipes(keys));
    }

    public BookPageCrafting(String string, IRecipe ... recipes) {
        super(string);
        this.output = recipes[0].func_77571_b();
        for (IRecipe recipe : recipes) {
            ArrayList<Object> newList;
            int i;
            if (recipe instanceof ShapedOreRecipe) {
                for (i = 0; i < 9; ++i) {
                    newList = new ArrayList<Object>();
                    if (this.inputs[i] != null) {
                        if (this.inputs[i] instanceof Collection) {
                            newList.addAll((Collection)this.inputs[i]);
                        } else {
                            newList.add(this.inputs[i]);
                        }
                    }
                    if (((ShapedOreRecipe)recipe).getInput().length > i && ((ShapedOreRecipe)recipe).getInput()[i] != null) {
                        if (((ShapedOreRecipe)recipe).getInput()[i] instanceof Collection) {
                            newList.addAll((Collection)((ShapedOreRecipe)recipe).getInput()[i]);
                        } else {
                            newList.add(((ShapedOreRecipe)recipe).getInput()[i]);
                        }
                    }
                    this.inputs[i] = newList;
                }
                continue;
            }
            if (recipe instanceof ShapedRecipes) {
                for (i = 0; i < 10; ++i) {
                    newList = new ArrayList();
                    if (this.inputs[i] != null) {
                        if (this.inputs[i] instanceof Collection) {
                            newList.addAll((Collection)this.inputs[i]);
                        } else {
                            newList.add(this.inputs[i]);
                        }
                    }
                    if (((ShapedRecipes)recipe).field_77574_d.length > i && ((ShapedRecipes)recipe).field_77574_d[i] != null) {
                        newList.add(((ShapedRecipes)recipe).field_77574_d[i]);
                    }
                    this.inputs[i] = newList;
                }
                continue;
            }
            if (recipe instanceof ShapelessRecipes) {
                this.shapeless = true;
                this.inputs = ArrayUtils.addAll((Object[])this.inputs, (Object[])((ShapelessRecipes)recipe).field_77579_b.toArray(new Object[0]));
                continue;
            }
            if (!(recipe instanceof ShapelessOreRecipe)) continue;
            this.shapeless = true;
            for (i = 0; i < 9; ++i) {
                newList = new ArrayList();
                if (this.inputs[i] != null) {
                    if (this.inputs[i] instanceof Collection) {
                        newList.addAll((Collection)this.inputs[i]);
                    } else {
                        newList.add(this.inputs[i]);
                    }
                }
                if (((ShapelessOreRecipe)recipe).getInput().size() > i && ((ShapelessOreRecipe)recipe).getInput().get(i) != null) {
                    if (((ShapelessOreRecipe)recipe).getInput().get(i) instanceof Collection) {
                        newList.addAll((Collection)((ShapelessOreRecipe)recipe).getInput().get(i));
                    } else {
                        newList.add(((ShapelessOreRecipe)recipe).getInput().get(i));
                    }
                }
                this.inputs[i] = newList;
            }
        }
        for (int i = 0; i < 9; ++i) {
            if (!(this.inputs[i] instanceof ArrayList)) continue;
            ArrayList seen = new ArrayList();
            for (ItemStack input : (ArrayList)this.inputs[i]) {
            }
        }
        this.recipe = recipes;
    }

    public static IRecipe[] getRecipes(String ... keys) {
        ArrayList<IRecipe> recipes = new ArrayList<IRecipe>();
        for (String key : keys) {
            recipes.add(BookRecipeRegistry.getRecipe(key));
        }
        return recipes.toArray(new IRecipe[0]);
    }

    @Override
    public void renderPage(int x, int y, FontRenderer fontRenderer, GuiSteamcraftBook book, RenderItem renderer, boolean isFirstPage, int mx, int my) {
        book.field_146297_k.func_110434_K().func_110577_a(craftSquareTexture);
        book.func_73729_b(x + 45, y + 55, 0, 0, 97, 59);
        if (this.shapeless) {
            book.func_73729_b(x + 120, y + 60, 100, 0, 17, 13);
        }
        int maxX = 3;
        int maxY = 3;
        if (this.recipe != null && this.recipe[0] != null && this.recipe[0] instanceof ShapedOreRecipe) {
            maxX = (Integer)ReflectionHelper.getPrivateValue(ShapedOreRecipe.class, (Object)((ShapedOreRecipe)this.recipe[0]), (int)4);
            maxY = (Integer)ReflectionHelper.getPrivateValue(ShapedOreRecipe.class, (Object)((ShapedOreRecipe)this.recipe[0]), (int)5);
        }
        for (int i = 0; i < maxY; ++i) {
            for (int j = 0; j < maxX; ++j) {
                ItemStack[] item;
                if (this.inputs.length <= maxX * i + j || this.inputs[maxX * i + j] == null) continue;
                if (this.inputs[maxX * i + j] instanceof Item) {
                    item = new ItemStack((Item)this.inputs[maxX * i + j]);
                    fontRenderer.func_78264_a(false);
                    this.drawItemStack((ItemStack)item, x + 49 + j * 19, y + 59 + i * 19, "", renderer, fontRenderer, true);
                    fontRenderer.func_78264_a(true);
                }
                if (this.inputs[maxX * i + j] instanceof ItemStack) {
                    item = (ItemStack)this.inputs[maxX * i + j];
                    fontRenderer.func_78264_a(false);
                    this.drawItemStack((ItemStack)item, x + 49 + j * 19, y + 59 + i * 19, "", renderer, fontRenderer, true);
                    fontRenderer.func_78264_a(true);
                }
                if (this.inputs[maxX * i + j] instanceof ItemStack[]) {
                    item = (ItemStack[])this.inputs[maxX * i + j];
                    int ticks = MathHelper.func_76128_c((double)((double)Minecraft.func_71410_x().field_71439_g.field_70173_aa % ((double)item.length * 20.0) / 20.0));
                    fontRenderer.func_78264_a(false);
                    this.drawItemStack(item[ticks], x + 49 + j * 19, y + 59 + i * 19, "", renderer, fontRenderer, true);
                    fontRenderer.func_78264_a(true);
                }
                if (!(this.inputs[maxX * i + j] instanceof ArrayList) || ((ArrayList)this.inputs[maxX * i + j]).size() <= 0) continue;
                ArrayList<ItemStack> list2 = new ArrayList<ItemStack>();
                for (ItemStack item2 : (ArrayList)this.inputs[maxX * i + j]) {
                    if (item2.func_77960_j() == Short.MAX_VALUE) {
                        ArrayList list = new ArrayList();
                        item2.func_77973_b().func_150895_a(item2.func_77973_b(), null, list);
                        for (Object item22 : list) {
                            list2.add((ItemStack)item22);
                        }
                        continue;
                    }
                    list2.add(item2);
                }
                ItemStack[] item3 = list2.toArray(new ItemStack[0]);
                int ticks = MathHelper.func_76128_c((double)((double)Minecraft.func_71410_x().field_71439_g.field_70173_aa % ((double)item3.length * 20.0) / 20.0));
                fontRenderer.func_78264_a(false);
                this.drawItemStack(item3[ticks], x + 49 + j * 19, y + 59 + i * 19, "", renderer, fontRenderer, true);
                fontRenderer.func_78264_a(true);
            }
        }
        fontRenderer.func_78264_a(false);
        this.drawItemStack(this.output, x + 45 + 76, y + 55 + 23, this.output.field_77994_a > 1 ? Integer.toString(this.output.field_77994_a) : "", renderer, fontRenderer, false);
        fontRenderer.func_78264_a(true);
        if (this.shapeless) {
            int ix = x + 120;
            int iy = y + 60;
            if (mx >= ix && mx <= ix + 17 && my >= iy && my <= iy + 13) {
                fontRenderer.func_78264_a(false);
                book.renderText("steamcraft.book.shapeless", mx, my);
                fontRenderer.func_78264_a(true);
            }
        }
    }

    @Override
    public ItemStack[] getCraftedItem() {
        return new ItemStack[]{this.output};
    }
}

