/*
 * Decompiled with CFR 0.152.
 */
package flaxbeard.steamcraft.api;

import flaxbeard.steamcraft.Steamcraft;
import flaxbeard.steamcraft.api.ISteamTransporter;
import flaxbeard.steamcraft.tile.TileEntitySteamPipe;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidHandler;

public class UtilSteamTransport {
    private static String[] boom = new String[]{"It can't withstand that kind of pressure!", "She's holding all she can, cap'n!", "Your pipes asplode", "Boom!"};

    public static void generalPressureEvent(World world, int x, int y, int z, float pressure, int capacity) {
        if (pressure > 1.2f) {
            ISteamTransporter trans = (ISteamTransporter)world.func_147438_o(x, y, z);
            float resistance = trans.getPressureResistance();
            int steam = trans.getSteamShare();
            int oneInX = Math.max(1, (int)Math.floor(500.0f - pressure / (1.1f + resistance) * 100.0f));
            if (oneInX <= 1 || world.field_73012_v.nextInt(oneInX - 1) == 0) {
                trans.explode();
                world.func_72876_a(null, (double)((float)x + 0.5f), (double)((float)y + 0.5f), (double)((float)z + 0.5f), 4.0f, true);
            }
        }
    }

    public static void generalDistributionEvent(World worldObj, int xCoord, int yCoord, int zCoord, ForgeDirection[] values) {
        if (!worldObj.field_72995_K) {
            ISteamTransporter trans = (ISteamTransporter)worldObj.func_147438_o(xCoord, yCoord, zCoord);
            for (ForgeDirection direction : values) {
                ISteamTransporter target;
                if (worldObj.func_147438_o(xCoord + direction.offsetX, yCoord + direction.offsetY, zCoord + direction.offsetZ) == null) continue;
                TileEntity tile = worldObj.func_147438_o(xCoord + direction.offsetX, yCoord + direction.offsetY, zCoord + direction.offsetZ);
                if (tile instanceof ISteamTransporter) {
                    target = (ISteamTransporter)tile;
                    if (!(trans.getPressure() > target.getPressure()) || !target.canInsert(direction.getOpposite())) continue;
                    float targetpercent = ((float)trans.getSteamShare() + (float)target.getSteamShare()) / ((float)trans.getCapacity() + (float)target.getCapacity());
                    int change = (int)(Math.floor(trans.getSteamShare() * target.getCapacity() - target.getSteamShare() * trans.getCapacity()) / (double)(trans.getCapacity() + target.getCapacity()));
                    if (change <= 0 || change > trans.getSteamShare()) continue;
                    trans.decrSteam(change);
                    target.insertSteam(change, direction.getOpposite());
                    continue;
                }
                if (!(tile instanceof IFluidHandler) || !Steamcraft.steamRegistered || !(trans instanceof TileEntitySteamPipe)) continue;
                target = (IFluidHandler)tile;
                float cap = 0.0f;
                float steam = 0.0f;
                if (target.getTankInfo(direction.getOpposite()) != null) {
                    for (FluidTankInfo info : target.getTankInfo(direction.getOpposite())) {
                        if (info.fluid == null) {
                            cap += (float)info.capacity / 10.0f;
                            continue;
                        }
                        if (info.fluid.getFluid() != FluidRegistry.getFluid((String)"steam")) continue;
                        steam += (float)info.fluid.amount / 10.0f;
                        cap += (float)info.capacity / 10.0f;
                    }
                }
                float pressure = steam / cap;
                if (!target.canFill(direction.getOpposite(), FluidRegistry.getFluid((String)"steam")) || !(trans.getPressure() > pressure)) continue;
                float targetpercent = ((float)trans.getSteamShare() + steam) / ((float)trans.getCapacity() + cap);
                int change = (int)(Math.floor((float)trans.getSteamShare() * cap - steam * (float)trans.getCapacity()) / (double)((float)trans.getCapacity() + cap));
                if (change <= 0 || change > trans.getSteamShare()) continue;
                trans.decrSteam(change - target.fill(direction.getOpposite(), new FluidStack(FluidRegistry.getFluid((String)"steam"), change * 10), true) / 10);
            }
        }
    }

    public static void preExplosion(World worldObj, int xCoord, int yCoord, int zCoord, ForgeDirection[] values) {
        ISteamTransporter trans = (ISteamTransporter)worldObj.func_147438_o(xCoord, yCoord, zCoord);
        for (ForgeDirection direction : values) {
            TileEntity tile;
            if (worldObj.func_147438_o(xCoord + direction.offsetX, yCoord + direction.offsetY, zCoord + direction.offsetZ) == null || !((tile = worldObj.func_147438_o(xCoord + direction.offsetX, yCoord + direction.offsetY, zCoord + direction.offsetZ)) instanceof ISteamTransporter)) continue;
            ISteamTransporter target = (ISteamTransporter)tile;
            int change = (int)(-10.0f * ((float)target.getCapacity() / 100.0f));
            trans.decrSteam(change);
        }
    }
}

