/*
 * Decompiled with CFR 0.152.
 */
package com.scottkillen.mod.koresample.tree.block;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.scottkillen.mod.koresample.tree.DefinesLog;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import net.minecraft.block.BlockLog;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;

public abstract class LogBlock
extends BlockLog {
    public static final int CAPACITY = 4;
    private final ImmutableList<DefinesLog> subBlocks;

    protected LogBlock(Collection<? extends DefinesLog> subBlocks) {
        Preconditions.checkArgument((!subBlocks.isEmpty() ? 1 : 0) != 0);
        Preconditions.checkArgument((subBlocks.size() <= 4 ? 1 : 0) != 0);
        this.subBlocks = ImmutableList.copyOf(subBlocks);
        this.func_149663_c("log");
    }

    protected static String getUnwrappedUnlocalizedName(String unlocalizedName) {
        return unlocalizedName.substring(unlocalizedName.indexOf(46) + 1);
    }

    protected final List<DefinesLog> subBlocks() {
        return Collections.unmodifiableList(this.subBlocks);
    }

    public final ImmutableList<String> getSubBlockNames() {
        ArrayList names = Lists.newArrayList();
        for (DefinesLog subBlock : this.subBlocks) {
            names.add(subBlock.speciesName());
        }
        return ImmutableList.copyOf((Collection)names);
    }

    public final String func_149739_a() {
        return String.format("tile.%s%s", this.resourcePrefix(), LogBlock.getUnwrappedUnlocalizedName(super.func_149739_a()));
    }

    @SideOnly(value=Side.CLIENT)
    public final void func_149666_a(Item item, CreativeTabs unused, List subblocks) {
        for (int i = 0; i < this.subBlocks.size(); ++i) {
            subblocks.add(new ItemStack(item, 1, i));
        }
    }

    @SideOnly(value=Side.CLIENT)
    public final void func_149651_a(IIconRegister iconRegister) {
        this.field_150167_a = new IIcon[this.subBlocks.size()];
        this.field_150166_b = new IIcon[this.subBlocks.size()];
        for (int i = 0; i < this.subBlocks.size(); ++i) {
            String iconName = String.format("%slog_%s", this.resourcePrefix(), ((DefinesLog)this.subBlocks.get(i)).speciesName());
            this.field_150167_a[i] = iconRegister.func_94245_a(iconName);
            this.field_150166_b[i] = iconRegister.func_94245_a(iconName + "_top");
        }
    }

    protected abstract String resourcePrefix();

    public String toString() {
        return Objects.toStringHelper((Object)((Object)this)).add("subBlocks", this.subBlocks).toString();
    }
}

