/*
 * Decompiled with CFR 0.152.
 */
package com.scottkillen.mod.koresample.config;

import com.google.common.base.Objects;
import com.google.common.base.Optional;
import com.scottkillen.mod.koresample.common.util.log.Logger;
import com.scottkillen.mod.koresample.config.ConfigSyncable;
import cpw.mods.fml.client.event.ConfigChangedEvent;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.ModContainer;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import java.io.File;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Map;
import java.util.Set;
import net.minecraftforge.common.config.Configuration;

public final class ConfigEventHandler {
    private final File configFile;
    private final ConfigSyncable sync;
    private final Configuration configuration;
    private final String configVersion;
    private final String modID;
    private final Logger logger;

    public ConfigEventHandler(String modID, File configFile, ConfigSyncable sync, String configVersion) {
        Optional oldConfig;
        this.modID = modID;
        this.logger = Logger.forMod(modID);
        this.configFile = configFile;
        this.sync = sync;
        Configuration localConfiguration = new Configuration(configFile, configVersion);
        if (ConfigEventHandler.isConfigVersionMismatch(localConfiguration)) {
            this.backup(configFile);
            oldConfig = Optional.of((Object)localConfiguration);
            this.configuration = new Configuration(configFile, configVersion);
        } else {
            oldConfig = Optional.absent();
            this.configuration = localConfiguration;
        }
        this.configVersion = configVersion;
        this.syncConfig(false, (Optional<Configuration>)oldConfig);
    }

    private static String getModName(String modID) {
        Map mods = Loader.instance().getIndexedModList();
        ModContainer mod = (ModContainer)mods.get(modID);
        return mod == null ? "Unknown" : mod.getName();
    }

    private static boolean isConfigVersionMismatch(Configuration configuration) {
        return !configuration.getLoadedConfigVersion().equals(configuration.getDefinedConfigVersion());
    }

    public void activate() {
        FMLCommonHandler.instance().bus().register((Object)this);
    }

    private void backup(File fileRef) {
        File fileBak = new File(fileRef.getAbsolutePath() + '_' + new SimpleDateFormat("yyyyMMdd_HHmmss").format(new Date()) + ".old");
        this.logger.warning("Your %s config file is out of date and could cause issues. The existing file will be renamed to %s and a new one will be generated.", ConfigEventHandler.getModName(this.modID), fileBak.getName());
        this.logger.warning("%s will attempt to copy your old settings.", ConfigEventHandler.getModName(this.modID));
        boolean success = fileRef.renameTo(fileBak);
        this.logger.warning("Rename %s successful.", success ? "was" : "was not");
    }

    public Configuration configuration() {
        return this.configuration;
    }

    private void loadConfig() {
        try {
            this.configuration.load();
        }
        catch (RuntimeException e) {
            File fileBak = new File(this.configFile.getAbsolutePath() + '_' + new SimpleDateFormat("yyyyMMdd_HHmmss").format(new Date()) + ".errored");
            this.logger.severe("An exception occurred while loading your config file. This file will be renamed to %s and a new config file will be generated.", fileBak.getName());
            this.logger.severe("Exception encountered: %s", e.getLocalizedMessage());
            boolean success = this.configFile.renameTo(fileBak);
            this.logger.warning("Rename %s successful.", success ? "was" : "was not");
            Configuration newConfig = new Configuration(this.configFile, this.configVersion);
            Set categoryNames = this.configuration.getCategoryNames();
            newConfig.copyCategoryProps(this.configuration, categoryNames.toArray(new String[categoryNames.size()]));
            this.sync.syncConfig(newConfig);
            newConfig.save();
        }
    }

    @SubscribeEvent
    public void onConfigChanged(ConfigChangedEvent.OnConfigChangedEvent event) {
        if (event.modID.equalsIgnoreCase(this.modID)) {
            this.saveConfig();
            this.syncConfig();
        }
    }

    private void saveConfig() {
        if (this.configuration.hasChanged()) {
            this.configuration.save();
        }
    }

    void syncConfig() {
        this.syncConfig(true, (Optional<Configuration>)Optional.absent());
    }

    private void syncConfig(boolean doLoad, Optional<Configuration> oldConfig) {
        if (doLoad) {
            this.loadConfig();
        }
        this.sync.syncConfig(this.configuration);
        if (oldConfig.isPresent()) {
            this.sync.convertOldConfig((Configuration)oldConfig.get());
        }
        this.saveConfig();
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).add("configFile", (Object)this.configFile).add("sync", (Object)this.sync).add("configuration", (Object)this.configuration).add("configVersion", (Object)this.configVersion).add("modID", (Object)this.modID).add("logger", (Object)this.logger).toString();
    }
}

