/*
 * Decompiled with CFR 0.152.
 */
package com.scottkillen.mod.koresample.common.block;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.scottkillen.mod.koresample.common.util.slab.TheSingleSlabRegistry;
import com.scottkillen.mod.koresample.tree.DefinesSlab;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockSlab;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;

public abstract class SlabBlock
extends BlockSlab {
    public static final int CAPACITY = 8;
    private static final int METADATA_MASK = 7;
    private static final TheSingleSlabRegistry slabRegistry = TheSingleSlabRegistry.REFERENCE;
    private final ImmutableList<DefinesSlab> subBlocks;

    protected SlabBlock(boolean isDouble, Collection<? extends DefinesSlab> subBlocks) {
        super(isDouble, Material.field_151575_d);
        Preconditions.checkArgument((!subBlocks.isEmpty() ? 1 : 0) != 0);
        Preconditions.checkArgument((subBlocks.size() <= 8 ? 1 : 0) != 0);
        this.subBlocks = ImmutableList.copyOf(subBlocks);
        this.func_149663_c("slab");
    }

    private static int mask(int metadata) {
        return metadata & 7;
    }

    public static boolean isSingleSlab(Item item) {
        return slabRegistry.isSingleSlab(item);
    }

    protected static String getUnwrappedUnlocalizedName(String unlocalizedName) {
        return unlocalizedName.substring(unlocalizedName.indexOf(46) + 1);
    }

    @SideOnly(value=Side.CLIENT)
    public final IIcon func_149691_a(int side, int metadata) {
        int index = SlabBlock.mask(metadata);
        if (index < 0 || index >= this.subBlocks.size()) {
            index = 0;
        }
        DefinesSlab subBlock = (DefinesSlab)this.subBlocks.get(index);
        Block modelBlock = subBlock.slabModelBlock();
        int modelBlockMetadata = subBlock.slabModelSubBlockIndex();
        return modelBlock.func_149691_a(side, modelBlockMetadata);
    }

    public final Item func_149650_a(int metadata, Random unused, int unused2) {
        DefinesSlab subBlock = (DefinesSlab)this.subBlocks.get(SlabBlock.mask(metadata));
        return Item.func_150898_a((Block)subBlock.singleSlabBlock());
    }

    public boolean func_149710_n() {
        return true;
    }

    protected final ItemStack func_149644_j(int metadata) {
        DefinesSlab subBlock = (DefinesSlab)this.subBlocks.get(SlabBlock.mask(metadata));
        return new ItemStack(Item.func_150898_a((Block)subBlock.singleSlabBlock()), 2, subBlock.slabSubBlockIndex());
    }

    public final String func_149739_a() {
        return String.format("tile.%s%s", this.resourcePrefix(), SlabBlock.getUnwrappedUnlocalizedName(super.func_149739_a()));
    }

    @SideOnly(value=Side.CLIENT)
    public final void func_149666_a(Item item, CreativeTabs unused, List subblocks) {
        if (SlabBlock.isSingleSlab(item)) {
            for (int i = 0; i < this.subBlocks.size(); ++i) {
                subblocks.add(new ItemStack(item, 1, i));
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public final void func_149651_a(IIconRegister unused) {
    }

    public final String func_150002_b(int metadata) {
        int metadata1 = metadata;
        if (metadata1 < 0 || metadata1 >= this.subBlocks.size()) {
            metadata1 = 0;
        }
        return this.func_149739_a() + '.' + ((DefinesSlab)this.subBlocks.get(metadata1)).slabName();
    }

    protected abstract String resourcePrefix();

    protected final List<DefinesSlab> subBlocks() {
        return Collections.unmodifiableList(this.subBlocks);
    }

    public String toString() {
        return Objects.toStringHelper((Object)((Object)this)).add("subBlocks", this.subBlocks).toString();
    }
}

