/*
 * Decompiled with CFR 0.152.
 */
package ec3.utils.common;

import baubles.api.BaublesApi;
import ec3.api.IWindModifier;
import ec3.api.IWindResistance;
import ec3.common.item.BaublesModifier;
import ec3.common.item.ItemsCore;
import ec3.common.registry.PotionRegistry;
import ec3.utils.common.ECUtils;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IChatComponent;
import net.minecraftforge.common.util.FakePlayer;

public class WindRelations {
    public static int getPlayerWindRelations(EntityPlayer player) {
        if (player instanceof FakePlayer) {
            return 0;
        }
        return ECUtils.getData(player).getPlayerWindPoints();
    }

    public static float getPlayerWindRevModifier(EntityPlayer player) {
        ItemStack armor;
        int i;
        float retFlt = 0.1f;
        for (i = 0; i < player.field_71071_by.field_70460_b.length; ++i) {
            armor = player.field_71071_by.field_70460_b[i];
            if (armor == null) continue;
            if (armor.func_77973_b() == ItemsCore.magicArmorItems[12] || armor.func_77973_b() == ItemsCore.magicArmorItems[13] || armor.func_77973_b() == ItemsCore.magicArmorItems[14] || armor.func_77973_b() == ItemsCore.magicArmorItems[15]) {
                retFlt += 0.23f;
            }
            if (!(armor.func_77973_b() instanceof IWindModifier)) continue;
            retFlt += ((IWindModifier)armor.func_77973_b()).getModifier(armor, player);
        }
        if (BaublesApi.getBaubles((EntityPlayer)player) != null) {
            for (i = 0; i < BaublesApi.getBaubles((EntityPlayer)player).func_70302_i_(); ++i) {
                armor = BaublesApi.getBaubles((EntityPlayer)player).func_70301_a(i);
                if (armor == null || !(armor.func_77973_b() instanceof IWindModifier)) continue;
                retFlt += ((IWindModifier)armor.func_77973_b()).getModifier(armor, player);
            }
        }
        return retFlt;
    }

    public static void setPlayerWindRelations(EntityPlayer player, int amount) {
        if (!(player instanceof FakePlayer)) {
            ECUtils.getData(player).modifyWindpoints(amount);
        }
    }

    public static void increasePlayerWindRelations(EntityPlayer e, int amount) {
        int current = WindRelations.getPlayerWindRelations(e);
        amount = (int)((float)amount * WindRelations.getPlayerWindRevModifier(e));
        WindRelations.setPlayerWindRelations(e, current + amount);
        e.func_70690_d(new PotionEffect(PotionRegistry.windTouch.field_76415_H, 1000, 0, true));
    }

    public static void playerTick(EntityPlayer player) {
        if (player instanceof FakePlayer) {
            return;
        }
        if (!ECUtils.getData(player).isWindbound()) {
            return;
        }
        int mod = 1;
        if (player.func_70660_b((Potion)PotionRegistry.paranormalLightness) != null) {
            mod = player.func_70660_b((Potion)PotionRegistry.paranormalLightness).func_76458_c() + 1;
        }
        if (!player.field_70170_p.field_72995_K && player.field_70170_p.field_73012_v.nextDouble() < (double)(2.0E-4f * (float)mod)) {
            WindRelations.increasePlayerWindRelations(player, 1000);
            boolean elemental = false;
            IInventory b = BaublesApi.getBaubles((EntityPlayer)player);
            if (b != null) {
                for (int i = 0; i < b.func_70302_i_(); ++i) {
                    ItemStack is = b.func_70301_a(i);
                    if (is == null || is.func_77973_b() == null || !(is.func_77973_b() instanceof BaublesModifier) || is.func_77960_j() != 9) continue;
                    elemental = true;
                }
            }
            if (!elemental) {
                player.func_145747_a((IChatComponent)new ChatComponentText(EnumChatFormatting.DARK_AQUA + "" + EnumChatFormatting.ITALIC + "The wind timidly touches your hair..."));
            } else {
                int rndID = player.field_70170_p.field_73012_v.nextInt(4);
                if (rndID == 0) {
                    player.func_145747_a((IChatComponent)new ChatComponentText(EnumChatFormatting.DARK_AQUA + "" + EnumChatFormatting.ITALIC + "You feel a warm touch of the wind..."));
                    player.func_70690_d(new PotionEffect(Potion.field_76420_g.func_76396_c(), 7200, 1, true));
                }
                if (rndID == 1) {
                    player.func_145747_a((IChatComponent)new ChatComponentText(EnumChatFormatting.DARK_AQUA + "" + EnumChatFormatting.ITALIC + "You feel a chilling touch of the wind..."));
                    player.func_70690_d(new PotionEffect(Potion.field_76428_l.func_76396_c(), 2400, 0, true));
                }
                if (rndID == 2) {
                    player.func_145747_a((IChatComponent)new ChatComponentText(EnumChatFormatting.DARK_AQUA + "" + EnumChatFormatting.ITALIC + "You feel a strong push of the wind..."));
                    player.func_70690_d(new PotionEffect(Potion.field_76443_y.func_76396_c(), 2400, 0, true));
                }
                if (rndID == 2) {
                    player.func_145747_a((IChatComponent)new ChatComponentText(EnumChatFormatting.DARK_AQUA + "" + EnumChatFormatting.ITALIC + "You feel a strong blow of the wind..."));
                    player.func_70690_d(new PotionEffect(Potion.field_76422_e.func_76396_c(), 7200, 1, true));
                }
            }
        }
        if (!player.field_70170_p.field_72995_K && player.field_70170_p.field_73012_v.nextDouble() < (double)(0.001f * (float)mod) && player.func_70051_ag()) {
            player.func_145747_a((IChatComponent)new ChatComponentText(EnumChatFormatting.DARK_AQUA + "" + EnumChatFormatting.ITALIC + "The wind pushes you in the back..."));
            WindRelations.increasePlayerWindRelations(player, 1000);
            boolean addBuff = true;
            if (BaublesApi.getBaubles((EntityPlayer)player) != null) {
                for (int i = 0; i < BaublesApi.getBaubles((EntityPlayer)player).func_70302_i_(); ++i) {
                    if (BaublesApi.getBaubles((EntityPlayer)player).func_70301_a(i) == null || BaublesApi.getBaubles((EntityPlayer)player).func_70301_a(i).func_77973_b() == null || !(BaublesApi.getBaubles((EntityPlayer)player).func_70301_a(i).func_77973_b() instanceof IWindResistance) || !addBuff) continue;
                    addBuff = !((IWindResistance)BaublesApi.getBaubles((EntityPlayer)player).func_70301_a(i).func_77973_b()).resistWind(player, BaublesApi.getBaubles((EntityPlayer)player).func_70301_a(i));
                }
            }
            if (player.field_71071_by != null) {
                for (int i = 0; i < player.field_71071_by.field_70460_b.length; ++i) {
                    if (player.field_71071_by.field_70460_b[i] == null || player.field_71071_by.field_70460_b[i].func_77973_b() == null || !(player.field_71071_by.field_70460_b[i].func_77973_b() instanceof IWindResistance) || !addBuff) continue;
                    addBuff = !((IWindResistance)player.field_71071_by.field_70460_b[i].func_77973_b()).resistWind(player, BaublesApi.getBaubles((EntityPlayer)player).func_70301_a(i));
                }
            }
            if (addBuff) {
                player.func_70690_d(new PotionEffect(Potion.field_76424_c.field_76415_H, 20, 31));
            }
        }
    }
}

