/*
 * Decompiled with CFR 0.152.
 */
package ec3.utils.cfg;

import DummyCore.Utils.IDummyConfig;
import cpw.mods.fml.common.registry.GameRegistry;
import ec3.common.block.BlocksCore;
import ec3.common.entity.EntitiesCore;
import ec3.common.registry.TileRegistry;
import ec3.utils.common.EnumOreColoring;
import net.minecraft.block.Block;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.common.util.EnumHelper;

public class Config
implements IDummyConfig {
    public static Config instance;
    public static int genericBlockIDS;
    public static int blocksCount;
    public static int genericItemIDS;
    public static int itemsCount;
    public static int dimensionID;
    public static int[] guiID;
    public static int[] mobID;
    public static int[] enchantID;
    public static int[] biomeID;
    public static boolean isCorruptionAllowed;
    public static boolean renderMRUPresenceWithoutMonocle;
    public static boolean enableHardcoreCrafts;
    public static boolean renderAdvancedBlockFX;
    public static int magicianID;
    public static boolean enablePersonalityShatter;
    public static boolean autoFindEID;
    public static Configuration config;
    public static String[] data_addedOresNames;
    public static int[] data_addedOreColors;
    public static int[] data_addedOreAmount;
    public static int oreGenAttempts;
    public static int eMRUCUGenAttempts;
    public static boolean allowPaleItemsInOtherRecipes;
    public static boolean renderStructuresFromAbove;
    public static boolean allowHologramInOtherDimensions;

    public Config() {
        instance = this;
    }

    public void loatEnchants() {
    }

    public void loadBlocks() {
    }

    public void loadItems() {
    }

    public void loadGUIs() {
        Config.guiID[0] = config.get("GUI", "Generic GUI ID", 7321).getInt();
        Config.guiID[1] = config.get("GUI", "Demon GUI ID", 7322).getInt();
    }

    public void loadMobs() {
        autoFindEID = config.getBoolean("autoFindEntityIDs", "Entities", false, "Enable if you can't set the entity ID's on your own.");
        Config.mobID[0] = EntitiesCore.nextEntityID(config.get("Entities", "MRUPresenceID", 71).getInt());
        Config.mobID[1] = EntitiesCore.nextEntityID(config.get("Entities", "MRUArrowID", 72).getInt());
        Config.mobID[2] = EntitiesCore.nextEntityID(config.get("Entities", "SolarBeamID", 73).getInt());
        Config.mobID[3] = EntitiesCore.nextEntityID(config.get("Entities", "WindMageID", 74).getInt());
        Config.mobID[4] = EntitiesCore.nextEntityID(config.get("Entities", "PosionFumeID", 75).getInt());
    }

    public void loadMisc() {
        String[] cfgCustomOreParsing;
        Config.biomeID[0] = config.get("Biomes", "ChaosCorruptionID", 91).getInt();
        Config.biomeID[1] = config.get("Biomes", "FrozenCorruptionID", 92).getInt();
        Config.biomeID[2] = config.get("Biomes", "ShadowCorruptionID", 93).getInt();
        Config.biomeID[3] = config.get("Biomes", "MagicCorruptionID", 94).getInt();
        Config.biomeID[4] = config.get("Biomes", "DesertID", 95).getInt();
        Config.biomeID[5] = config.get("Biomes", "DreadLandsID", 96).getInt();
        enablePersonalityShatter = config.getBoolean("EnablePersonalityShatter", "Misc", true, "");
        renderStructuresFromAbove = config.getBoolean("renderStructuresFromAbove", "Misc", true, "");
        dimensionID = config.getInt("Hoanna ID", "Misc", 53, Integer.MIN_VALUE, Integer.MAX_VALUE, "");
        for (String s : cfgCustomOreParsing = config.getStringList("CustomMagmaticAlloys", "Misc", new String[]{"oreSaltpeter:10065301|5?dustSaltpeter", "oreSulfur:16777113|5?dustSulfur"}, "Allows to add custom ores to Magmatic Alloys, where this is an array list, where first part is the ore name in OreDictionary, int after : is the color, int after | is the amount of drops you get from the ore and String after ? is the OreDictionary name of the result.")) {
            int index_0 = s.indexOf(":");
            int index_1 = s.indexOf("|");
            int index_2 = s.indexOf("?");
            if (index_0 == -1 || index_1 == -1 || index_2 == -1) continue;
            String oredOreName = s.substring(0, index_0);
            int oreColor = Integer.parseInt(s.substring(index_0 + 1, index_1));
            int oreOutput = Integer.parseInt(s.substring(index_1 + 1, index_2));
            String oredResultName = s.substring(index_2 + 1, s.length());
            EnumHelper.addEnum(EnumOreColoring.class, (String)oredOreName.toUpperCase(), (Class[])new Class[]{String.class, String.class, Integer.TYPE, Integer.TYPE}, (Object[])new Object[]{oredOreName, oredResultName, oreColor, oreOutput});
        }
        oreGenAttempts = config.getInt("oreGenAttempts", "Misc", 4, 0, Integer.MAX_VALUE, "The amount of tries to generate the elemental ore cluster in a chunk. Set to 0 to disable worldgen.");
        eMRUCUGenAttempts = config.getInt("eMRUCUGenAttempts", "Misc", 1, 0, Integer.MAX_VALUE, "The amount of tries to generate the Elder MRUCU Structure in a chunk. Set to 0 to disable worldgen.");
        allowPaleItemsInOtherRecipes = config.getBoolean("AllowPaleItemsInOtherRecipes", "Misc", true, "");
        allowHologramInOtherDimensions = config.getBoolean("allowHologramInOtherDimensions", "Mobs", false, "Is the hologram boss allowed to spawn in the overworld/nether/anything but Hoanna");
    }

    public static int getIdForBlock(String name) {
        return ++blocksCount;
    }

    public static int getIdForItem(String name) {
        return ++itemsCount;
    }

    public void load(Configuration config) {
        Config.config = config;
        config.load();
        this.loadBlocks();
        this.loadItems();
        this.loadGUIs();
        this.loadMobs();
        this.loadMisc();
        this.loatEnchants();
        config.save();
        this.loadTiles();
    }

    public void loadTiles() {
        for (Class<? extends TileEntity> tile : TileRegistry.cfgDependant) {
            try {
                if (tile.getMethod("setupConfig", Configuration.class) == null) continue;
                tile.getMethod("setupConfig", Configuration.class).invoke(null, config);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public void postInitParseDecorativeBlocks() {
        String[] cfgCustomFancy;
        config.load();
        for (String s : cfgCustomFancy = config.getStringList("Custom Fancy Blocks", "Misc", new String[]{"Thaumcraft:blockCosmeticOpaque?0", "Thaumcraft:blockCosmeticSolid?1"}, "Allows to add custom Fancy Blocks to the game, where string before : is the modname, String after :, but before ? is the block name, and int after ? is metadata.")) {
            int index_0 = s.indexOf(":");
            int index_1 = s.indexOf("?");
            if (index_0 == -1 || index_1 == -1) continue;
            String modname = s.substring(0, index_0);
            String blockname = s.substring(index_0 + 1, index_1);
            int metadata = Integer.parseInt(s.substring(index_1 + 1));
            Block added = GameRegistry.findBlock((String)modname, (String)blockname);
            if (added == null) continue;
            BlocksCore.createFancyBlock(added, blockname, metadata);
        }
        config.save();
    }

    static {
        genericBlockIDS = 1200;
        blocksCount = 0;
        genericItemIDS = 13200;
        itemsCount = 0;
        dimensionID = 53;
        guiID = new int[48];
        mobID = new int[16];
        enchantID = new int[4];
        biomeID = new int[8];
        enablePersonalityShatter = true;
        autoFindEID = false;
    }
}

