/*
 * Decompiled with CFR 0.152.
 */
package ec3.integration.nei;

import DummyCore.Utils.MathUtils;
import DummyCore.Utils.MiscUtils;
import DummyCore.Utils.UnformedItemStack;
import codechicken.nei.PositionedStack;
import codechicken.nei.recipe.TemplateRecipeHandler;
import ec3.api.MagicianTableRecipe;
import ec3.api.MagicianTableRecipes;
import ec3.common.mod.EssentialCraftCore;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import org.lwjgl.opengl.GL11;

public class MagicianTableRecipeHandler
extends TemplateRecipeHandler {
    public String getRecipeName() {
        return "Magician Table";
    }

    public String getGuiTexture() {
        return "essentialcraft:textures/gui/gui_generic.png";
    }

    public void loadCraftingRecipes(String outputId, Object ... results) {
        if (results.length > 0) {
            ItemStack stk;
            MagicianTableRecipe rec;
            Object obj = results[0];
            if (obj instanceof ItemStack && (rec = MagicianTableRecipes.getRecipeByResult(stk = (ItemStack)obj)) != null) {
                MagicianTableCraftingPair pair = new MagicianTableCraftingPair(rec);
                this.arecipes.add(pair);
            }
        } else if (outputId.equalsIgnoreCase(this.getOverlayIdentifier())) {
            Enumeration<MagicianTableRecipe> e = MagicianTableRecipes.recipes.elements();
            while (e.hasMoreElements()) {
                MagicianTableRecipe rec = e.nextElement();
                if (rec == null) continue;
                MagicianTableCraftingPair pair = new MagicianTableCraftingPair(rec);
                this.arecipes.add(pair);
            }
        }
    }

    public void loadTransferRects() {
        this.transferRects.add(new TemplateRecipeHandler.RecipeTransferRect(new Rectangle(70, 20, 32, 18), this.getOverlayIdentifier(), new Object[0]));
    }

    public String getOverlayIdentifier() {
        return "magicianTable";
    }

    public void loadUsageRecipes(String inputId, Object ... ingredients) {
        if (ingredients.length > 0) {
            Object obj = ingredients[0];
            if (obj instanceof ItemStack) {
                ItemStack stk = (ItemStack)obj;
                List<MagicianTableRecipe> recs = MagicianTableRecipes.getRecipiesByComponent(stk);
                for (int i = 0; i < recs.size(); ++i) {
                    MagicianTableCraftingPair pair = new MagicianTableCraftingPair(recs.get(i));
                    this.arecipes.add(pair);
                }
            }
        } else if (inputId.equalsIgnoreCase(this.getOverlayIdentifier())) {
            this.loadCraftingRecipes(inputId, ingredients);
        }
    }

    public void drawExtras(int recipe) {
        if (this.cycleticks % 30 == 0) {
            Random rng = new Random();
            MagicianTableCraftingPair cp = (MagicianTableCraftingPair)((Object)this.arecipes.get(recipe));
            for (int i = 0; i < cp.getIngredients().size(); ++i) {
                PositionedStack stack = cp.getIngredients().get(i);
                stack.setPermutationToRender(rng.nextInt(stack.items.length));
            }
        }
        GL11.glPushMatrix();
        int posX = 0;
        int posY = 0;
        MagicianTableCraftingPair rec = (MagicianTableCraftingPair)((Object)this.arecipes.get(recipe));
        MiscUtils.bindTexture((String)"essentialcraft", (String)"textures/gui/mruStorage.png");
        MiscUtils.drawTexturedModalRect((int)0, (int)0, (int)0, (int)0, (int)18, (int)72, (int)1);
        int percentageScaled = MathUtils.pixelatedTextureSize((int)rec.mruRequired, (int)5000, (int)72);
        IIcon icon = (IIcon)EssentialCraftCore.proxy.getClientIcon("mru");
        MiscUtils.drawTexture((int)1, (int)(-1 + (74 - percentageScaled)), (IIcon)icon, (int)16, (int)(percentageScaled - 2), (float)0.0f);
        MiscUtils.bindTexture((String)"essentialcraft", (String)"textures/gui/slot_common.png");
        posX = 18;
        posY = 54;
        MiscUtils.drawTexturedModalRect((int)posX, (int)posY, (int)0, (int)0, (int)17, (int)18, (int)1);
        MiscUtils.drawTexturedModalRect((int)(posX + 17), (int)posY, (int)1, (int)0, (int)16, (int)18, (int)1);
        MiscUtils.drawTexturedModalRect((int)(posX + 17 + 16), (int)posY, (int)1, (int)0, (int)16, (int)18, (int)1);
        MiscUtils.drawTexturedModalRect((int)(posX + 17 + 32), (int)posY, (int)1, (int)0, (int)16, (int)18, (int)1);
        MiscUtils.drawTexturedModalRect((int)(posX + 17 + 48), (int)posY, (int)1, (int)0, (int)16, (int)18, (int)1);
        MiscUtils.drawTexturedModalRect((int)(posX + 17 + 64), (int)posY, (int)1, (int)0, (int)16, (int)18, (int)1);
        MiscUtils.drawTexturedModalRect((int)(posX + 17 + 80), (int)posY, (int)1, (int)0, (int)16, (int)18, (int)1);
        MiscUtils.drawTexturedModalRect((int)(posX + 17 + 96), (int)posY, (int)1, (int)0, (int)16, (int)18, (int)1);
        MiscUtils.drawTexturedModalRect((int)(posX + 17 + 111), (int)posY, (int)1, (int)0, (int)17, (int)18, (int)1);
        Minecraft.func_71410_x().field_71466_p.func_78261_a(rec.mruRequired + " MRU", posX + 2, posY + 5, 0xFFFFFF);
        Minecraft.func_71410_x().field_71466_p.func_78261_a("" + rec.mruRequired / 20 / 60 + "Min " + (rec.mruRequired / 20 - rec.mruRequired / 20 / 60 * 60) + "Sec", posX + 2 + 60, posY + 5, 0xFFFFFF);
        GL11.glScalef((float)2.0f, (float)2.0f, (float)2.0f);
        Minecraft.func_71410_x().field_71466_p.func_78276_b("R", 40, 10, 0);
        GL11.glScalef((float)0.0f, (float)0.0f, (float)0.0f);
        GL11.glPopMatrix();
    }

    public void drawBackground(int recipe) {
        super.drawBackground(recipe);
        MiscUtils.bindTexture((String)"essentialcraft", (String)"textures/gui/slot_common.png");
        MiscUtils.drawTexturedModalRect((int)18, (int)0, (int)0, (int)0, (int)18, (int)18, (int)0);
        MiscUtils.drawTexturedModalRect((int)54, (int)0, (int)0, (int)0, (int)18, (int)18, (int)0);
        MiscUtils.drawTexturedModalRect((int)36, (int)18, (int)0, (int)0, (int)18, (int)18, (int)0);
        MiscUtils.drawTexturedModalRect((int)18, (int)36, (int)0, (int)0, (int)18, (int)18, (int)0);
        MiscUtils.drawTexturedModalRect((int)54, (int)36, (int)0, (int)0, (int)18, (int)18, (int)0);
        MiscUtils.drawTexturedModalRect((int)108, (int)18, (int)0, (int)0, (int)18, (int)18, (int)0);
    }

    public int recipiesPerPage() {
        return 1;
    }

    public class MagicianTableCraftingPair
    extends TemplateRecipeHandler.CachedRecipe {
        public ArrayList<PositionedStack> ingredients;
        PositionedStack[] ingred;
        PositionedStack result;
        public int mruRequired;

        public MagicianTableCraftingPair(MagicianTableRecipe recipe) {
            super((TemplateRecipeHandler)MagicianTableRecipeHandler.this);
            this.ingred = new PositionedStack[5];
            UnformedItemStack[] craftMatrix = recipe.requiredItems;
            for (int t = 0; t < craftMatrix.length; ++t) {
                if (craftMatrix[t] == null || craftMatrix[t].possibleStacks.isEmpty()) continue;
                this.ingred[t] = new PositionedStack((Object)craftMatrix[t].possibleStacks, 51 + t * 18, 6);
            }
            this.result = new PositionedStack((Object)recipe.result, 109, 19);
            this.ingredients = new ArrayList();
            this.setIngredients(craftMatrix);
            this.mruRequired = recipe.mruRequired;
        }

        public void setIngredients(UnformedItemStack[] items) {
            for (int i = 0; i < items.length; ++i) {
                if (items[i] == null) continue;
                int x = 0;
                int y = 0;
                switch (i) {
                    case 0: {
                        x = 1;
                        y = 1;
                        break;
                    }
                    case 1: {
                        x = 0;
                        y = 0;
                        break;
                    }
                    case 2: {
                        x = 2;
                        y = 0;
                        break;
                    }
                    case 3: {
                        x = 0;
                        y = 2;
                        break;
                    }
                    case 4: {
                        x = 2;
                        y = 2;
                    }
                }
                if (items[i].possibleStacks == null || items[i].possibleStacks.isEmpty()) continue;
                PositionedStack stack = new PositionedStack((Object)items[i].possibleStacks, 19 + x * 18, 1 + y * 18, false);
                stack.setMaxSize(1);
                this.ingredients.add(stack);
            }
        }

        public List<PositionedStack> getIngredients() {
            return this.ingredients;
        }

        public PositionedStack getResult() {
            return this.result;
        }
    }
}

