/*
 * Decompiled with CFR 0.152.
 */
package ec3.common.world;

import ec3.common.block.BlocksCore;
import ec3.common.item.ItemsCore;
import ec3.common.world.ECExplosion;
import java.util.Random;
import net.minecraft.init.Blocks;
import net.minecraft.util.WeightedRandomChestContent;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.WorldGenerator;

public class WorldGenDestroyedHouse
extends WorldGenerator {
    public int floorsAmount;
    public int rad;
    public static final WeightedRandomChestContent[] generatedItems = new WeightedRandomChestContent[]{new WeightedRandomChestContent(ItemsCore.titanite, 0, 8, 64, 20), new WeightedRandomChestContent(ItemsCore.twinkling_titanite, 0, 2, 16, 10), new WeightedRandomChestContent(ItemsCore.genericItem, 5, 1, 64, 15), new WeightedRandomChestContent(ItemsCore.genericItem, 6, 1, 64, 15), new WeightedRandomChestContent(ItemsCore.genericItem, 7, 1, 64, 15), new WeightedRandomChestContent(ItemsCore.genericItem, 8, 1, 64, 15), new WeightedRandomChestContent(ItemsCore.genericItem, 9, 1, 64, 15), new WeightedRandomChestContent(ItemsCore.genericItem, 10, 1, 64, 15), new WeightedRandomChestContent(ItemsCore.genericItem, 11, 1, 64, 15), new WeightedRandomChestContent(ItemsCore.genericItem, 20, 1, 12, 10), new WeightedRandomChestContent(ItemsCore.genericItem, 3, 1, 64, 15), new WeightedRandomChestContent(ItemsCore.genericItem, 35, 1, 1, 6), new WeightedRandomChestContent(ItemsCore.genericItem, 36, 1, 1, 6), new WeightedRandomChestContent(ItemsCore.genericItem, 37, 1, 1, 6)};

    public WorldGenDestroyedHouse(int i) {
        this.floorsAmount = i;
    }

    public WorldGenDestroyedHouse(int i, int j) {
        this.floorsAmount = i;
        this.rad = j;
    }

    public int getGroundToGenerate(World w, int x, int y, int z) {
        while (y > 5) {
            if (!w.func_147437_c(x, y, z) && w.func_147439_a(x, y, z) != Blocks.field_150355_j) {
                if (w.func_147439_a(x, y, z) != BlocksCore.concrete && w.func_147439_a(x, y, z) != BlocksCore.fortifiedStone) break;
                return -1;
            }
            --y;
        }
        if (y == 5) {
            return -1;
        }
        return y;
    }

    public boolean func_76484_a(World w, Random r, int x, int y, int z) {
        int genY = this.getGroundToGenerate(w, x, y, z);
        if (genY != -1) {
            y = genY;
            if (this.rad == 0) {
                this.rad = r.nextInt(6) + 3;
            }
            for (int i = 0; i < this.floorsAmount + 1; ++i) {
                this.generateFloor(w, r, x, y + 5 * i, z, i, this.rad);
            }
            return true;
        }
        return false;
    }

    public void generateFloor(World w, Random r, int x, int y, int z, int floorNum, int size) {
        for (int dx = -size; dx <= size; ++dx) {
            for (int dz = -size; dz <= size; ++dz) {
                if (floorNum == 0 && ((dx == -size || dx == size) && (dz == -size || dz == size) || dx == 0 && dz == 0)) {
                    w.func_147465_d(x + dx, y - 1, z + dz, BlocksCore.levitator, 0, 3);
                }
                for (int dy = 0; dy < 5; ++dy) {
                    int tryInt;
                    if (w.func_147439_a(x + dx, y + dy, z + dz) != Blocks.field_150355_j) {
                        w.func_147465_d(x + dx, y + dy, z + dz, Blocks.field_150350_a, 0, 3);
                    }
                    if (w.field_73012_v.nextInt(tryInt = dy + 1) == 0) {
                        w.func_147449_b(x + dx, y + dy, z + dz, BlocksCore.concrete);
                    }
                    if (dy == 0 || dy == 4) {
                        w.func_147465_d(x + dx, y + dy, z + dz, BlocksCore.fortifiedStone, 0, 3);
                    }
                    if (dx == -size || dx == size) {
                        w.func_147465_d(x + dx, y + dy, z + dz, BlocksCore.fortifiedStone, 0, 3);
                        if (dy > 0 && dy < 4 && dz > -size + 1 && dz < size - 1) {
                            w.func_147465_d(x + dx, y + dy, z + dz, BlocksCore.fortifiedGlass, 0, 3);
                        }
                    }
                    if (dz == -size || dz == size) {
                        w.func_147465_d(x + dx, y + dy, z + dz, BlocksCore.fortifiedStone, 0, 3);
                        if (dy > 0 && dy < 4 && dx > -size + 1 && dx < size - 1) {
                            w.func_147465_d(x + dx, y + dy, z + dz, BlocksCore.fortifiedGlass, 0, 3);
                        }
                    }
                    if (this.floorsAmount == 0) {
                        this.floorsAmount = 1;
                    }
                    if (r.nextInt(this.floorsAmount * 10) >= floorNum) continue;
                    ECExplosion explosion = new ECExplosion(w, null, x + dx, y + dy, z + dz, 3 + floorNum / 3);
                    explosion.func_77278_a();
                    explosion.func_77279_a(true);
                }
            }
        }
    }
}

