/*
 * Decompiled with CFR 0.152.
 */
package ec3.common.tile;

import DummyCore.Utils.DataStorage;
import DummyCore.Utils.DummyData;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import ec3.api.RadiatingChamberRecipe;
import ec3.api.RadiatingChamberRecipes;
import ec3.common.tile.TileMRUGeneric;
import ec3.utils.common.ECUtils;
import net.minecraft.item.ItemStack;
import net.minecraft.util.AxisAlignedBB;
import net.minecraftforge.common.config.Configuration;

public class TileRadiatingChamber
extends TileMRUGeneric {
    public int progressLevel;
    public RadiatingChamberRecipe currentRecipe;
    public static float cfgMaxMRU = 5000.0f;
    public static boolean generatesCorruption = true;
    public static int genCorruption = 1;
    public static float mruUsage = 1.0f;

    public TileRadiatingChamber() {
        this.maxMRU = 5000;
        this.setSlotsNum(4);
    }

    @Override
    public void func_145845_h() {
        super.func_145845_h();
        ECUtils.manage(this, 0);
        if (!this.field_145850_b.func_72864_z(this.field_145851_c, this.field_145848_d, this.field_145849_e)) {
            ItemStack[] craftMatrix = new ItemStack[]{this.func_70301_a(1), this.func_70301_a(2)};
            RadiatingChamberRecipe rec = RadiatingChamberRecipes.getRecipeByCPAndBalance(craftMatrix, this.getBalance());
            if (this.currentRecipe == null && rec != null && this.progressLevel != 0 && this.canFunction(rec)) {
                this.currentRecipe = rec;
            }
            if (this.currentRecipe == null && rec != null && this.progressLevel == 0 && this.canFunction(rec)) {
                this.currentRecipe = rec;
            }
            if (this.currentRecipe != null && rec == null) {
                this.progressLevel = 0;
                this.currentRecipe = null;
                return;
            }
            if (this.currentRecipe != null && rec != null) {
                if (!this.canFunction(rec)) {
                    this.progressLevel = 0;
                    this.currentRecipe = null;
                    return;
                }
                int mruReq = (int)(mruUsage * this.currentRecipe.costModifier);
                if (this.getMRU() >= mruReq && this.progressLevel < this.currentRecipe.mruRequired) {
                    ++this.progressLevel;
                    if (generatesCorruption) {
                        ECUtils.increaseCorruptionAt(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e, this.field_145850_b.field_73012_v.nextInt(genCorruption));
                    }
                    this.setMRU(this.getMRU() - mruReq);
                    if (this.progressLevel >= this.currentRecipe.mruRequired) {
                        this.progressLevel = 0;
                        this.craft();
                        this.currentRecipe = null;
                    }
                }
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB getRenderBoundingBox() {
        AxisAlignedBB bb = INFINITE_EXTENT_AABB;
        return bb;
    }

    public boolean canFunction(RadiatingChamberRecipe rec) {
        ItemStack result = rec.result;
        if (result != null) {
            if (this.func_70301_a(3) == null) {
                return true;
            }
            if (this.func_70301_a(3).func_77969_a(result) && this.func_70301_a((int)3).field_77994_a + result.field_77994_a <= this.func_70297_j_() && this.func_70301_a((int)3).field_77994_a + result.field_77994_a <= this.func_70301_a(3).func_77976_d()) {
                return true;
            }
        }
        return false;
    }

    public void craft() {
        if (this.canFunction(this.currentRecipe)) {
            ItemStack stk = this.currentRecipe.result.func_77946_l();
            stk.field_77994_a = this.currentRecipe.recipeSize;
            if (this.func_70301_a(3) == null) {
                this.func_70299_a(3, stk.func_77946_l());
            } else if (this.func_70301_a(3).func_77973_b() == stk.func_77973_b()) {
                this.func_70299_a(3, new ItemStack(stk.func_77973_b(), stk.field_77994_a + this.func_70301_a((int)3).field_77994_a, stk.func_77960_j()));
            }
            for (int i = 1; i < 3; ++i) {
                this.func_70298_a(i, 1);
            }
        }
    }

    public static void setupConfig(Configuration cfg) {
        try {
            cfg.load();
            String[] cfgArrayString = cfg.getStringList("RadiatingChamberSettings", "tileentities", new String[]{"Max MRU:5000.0", "MRU Usage Modifier:1.0", "Can this device actually generate corruption:true", "The amount of corruption generated each tick(do not set to 0!):1"}, "");
            String dataString = "";
            for (int i = 0; i < cfgArrayString.length; ++i) {
                dataString = dataString + "||" + cfgArrayString[i];
            }
            DummyData[] data = DataStorage.parseData((String)dataString);
            mruUsage = Float.parseFloat(data[1].fieldValue);
            cfgMaxMRU = Float.parseFloat(data[0].fieldValue);
            generatesCorruption = Boolean.parseBoolean(data[2].fieldValue);
            genCorruption = Integer.parseInt(data[3].fieldValue);
            cfg.save();
        }
        catch (Exception e) {
            return;
        }
    }

    @Override
    public int[] getOutputSlots() {
        return new int[]{3};
    }
}

