/*
 * Decompiled with CFR 0.152.
 */
package ec3.common.tile;

import DummyCore.Utils.DataStorage;
import DummyCore.Utils.DummyData;
import DummyCore.Utils.MathUtils;
import DummyCore.Utils.MiscUtils;
import ec3.common.tile.TileMRUGeneric;
import ec3.utils.common.ECUtils;
import java.util.List;
import java.util.Random;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemPotion;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.AxisAlignedBB;
import net.minecraftforge.common.config.Configuration;

public class TilePotionSpreader
extends TileMRUGeneric {
    public int potionID = -1;
    public int potionDuration = -1;
    public int potionAmplifier = -1;
    public int potionUseTime = -1;
    public static float cfgMaxMRU = 5000.0f;
    public static boolean generatesCorruption = false;
    public static int genCorruption = 5;
    public static int mruUsage = 250;
    public static int potionGenUseTime = 16;

    public TilePotionSpreader() {
        this.maxMRU = (int)cfgMaxMRU;
        this.setSlotsNum(9);
    }

    @Override
    public void func_145845_h() {
        super.func_145845_h();
        ECUtils.manage(this, 0);
        if (!this.field_145850_b.func_72864_z(this.field_145851_c, this.field_145848_d, this.field_145849_e)) {
            if (this.potionID == -1) {
                for (int i = 1; i < 9; ++i) {
                    ItemPotion potion;
                    List lst;
                    ItemStack stk = this.func_70301_a(i);
                    if (stk == null || !(stk.func_77973_b() instanceof ItemPotion) || (lst = (potion = (ItemPotion)stk.func_77973_b()).func_77832_l(stk)).isEmpty()) continue;
                    PotionEffect effect = (PotionEffect)lst.get(0);
                    this.potionID = effect.func_76456_a();
                    this.potionAmplifier = effect.func_76458_c();
                    this.potionDuration = effect.func_76459_b();
                    this.potionUseTime = potionGenUseTime;
                    this.func_70299_a(i, null);
                    break;
                }
            } else {
                List lst = this.field_145850_b.func_72872_a(EntityLivingBase.class, AxisAlignedBB.func_72330_a((double)(this.field_145851_c - 8), (double)(this.field_145848_d - 8), (double)(this.field_145849_e - 8), (double)(this.field_145851_c + 9), (double)(this.field_145848_d + 9), (double)(this.field_145849_e + 9)));
                if (!lst.isEmpty() && !this.field_145850_b.field_72995_K) {
                    boolean haveUsedPotion = false;
                    for (int i = 0; i < lst.size(); ++i) {
                        EntityLivingBase base = (EntityLivingBase)lst.get(i);
                        boolean shouldUsePotion = false;
                        PotionEffect effect = new PotionEffect(this.potionID, this.potionDuration, this.potionAmplifier);
                        if (this.potionID == Potion.field_76432_h.field_76415_H) {
                            float healAmount = Math.max(4 << effect.func_76458_c(), 0);
                            shouldUsePotion = !base.func_70662_br() && base.func_110143_aJ() + healAmount <= base.func_110138_aP() || base.func_70662_br() && base.field_70172_ad == 0 && base.field_70737_aN == 0;
                        } else if (this.potionID == Potion.field_76433_i.field_76415_H) {
                            float damageAmount = 6 << effect.func_76458_c();
                            shouldUsePotion = base.func_70662_br() && base.func_110143_aJ() + damageAmount <= base.func_110138_aP() || !base.func_70662_br() && base.field_70172_ad == 0 && base.field_70737_aN == 0;
                        } else {
                            boolean bl = shouldUsePotion = !base.func_82165_m(this.potionID);
                        }
                        if (shouldUsePotion && this.getMRU() >= mruUsage) {
                            this.setMRU(this.getMRU() - mruUsage);
                            haveUsedPotion = true;
                            base.func_70690_d(effect);
                            int j = Potion.field_76425_a[this.potionID].func_76401_j();
                            float f = 0.0f;
                            float f1 = 0.0f;
                            float f2 = 0.0f;
                            f += (float)(j >> 16 & 0xFF) / 255.0f;
                            f1 += (float)(j >> 8 & 0xFF) / 255.0f;
                            f2 += (float)(j >> 0 & 0xFF) / 255.0f;
                            for (int i1 = 0; i1 < 100; ++i1) {
                                MiscUtils.spawnParticlesOnServer((String)"mobSpell", (float)((float)(base.field_70165_t + (double)MathUtils.randomFloat((Random)this.field_145850_b.field_73012_v))), (float)((float)(base.field_70163_u + 1.0 + (double)MathUtils.randomFloat((Random)this.field_145850_b.field_73012_v))), (float)((float)(base.field_70161_v + (double)MathUtils.randomFloat((Random)this.field_145850_b.field_73012_v))), (double)f, (double)f1, (double)f2);
                            }
                        }
                        if (!generatesCorruption) continue;
                        ECUtils.increaseCorruptionAt(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e, this.field_145850_b.field_73012_v.nextInt(genCorruption));
                    }
                    if (haveUsedPotion) {
                        --this.potionUseTime;
                    }
                }
                if (this.potionUseTime <= 0) {
                    this.potionID = -1;
                    this.potionAmplifier = -1;
                    this.potionDuration = -1;
                }
                if (this.potionID != -1) {
                    int j = Potion.field_76425_a[this.potionID].func_76401_j();
                    float f = 0.0f;
                    float f1 = 0.0f;
                    float f2 = 0.0f;
                    this.field_145850_b.func_72869_a("mobSpell", (double)((float)this.field_145851_c + 0.5f), (double)((float)this.field_145848_d + 0.5f), (double)((float)this.field_145849_e + 0.5f), (double)(f += (float)(j >> 16 & 0xFF) / 255.0f), (double)(f1 += (float)(j >> 8 & 0xFF) / 255.0f), (double)(f2 += (float)(j >> 0 & 0xFF) / 255.0f));
                }
            }
        }
    }

    @Override
    public void func_145839_a(NBTTagCompound i) {
        this.potionID = i.func_74762_e("potionID");
        this.potionDuration = i.func_74762_e("potionDuration");
        this.potionAmplifier = i.func_74762_e("potionAmplifier");
        this.potionUseTime = i.func_74762_e("potionUseTime");
        super.func_145839_a(i);
    }

    @Override
    public void func_145841_b(NBTTagCompound i) {
        i.func_74768_a("potionID", this.potionID);
        i.func_74768_a("potionDuration", this.potionDuration);
        i.func_74768_a("potionAmplifier", this.potionAmplifier);
        i.func_74768_a("potionUseTime", this.potionUseTime);
        super.func_145841_b(i);
    }

    public static void setupConfig(Configuration cfg) {
        try {
            cfg.load();
            String[] cfgArrayString = cfg.getStringList("PotionSpreaderSettings", "tileentities", new String[]{"Max MRU:5000.0", "MRU Usage Per Mob:250", "Can this device actually generate corruption:false", "The amount of corruption generated each tick(do not set to 0!):5", "Amount of times one potion can be spreaded:16"}, "");
            String dataString = "";
            for (int i = 0; i < cfgArrayString.length; ++i) {
                dataString = dataString + "||" + cfgArrayString[i];
            }
            DummyData[] data = DataStorage.parseData((String)dataString);
            mruUsage = Integer.parseInt(data[1].fieldValue);
            cfgMaxMRU = Float.parseFloat(data[0].fieldValue);
            generatesCorruption = Boolean.parseBoolean(data[2].fieldValue);
            genCorruption = Integer.parseInt(data[3].fieldValue);
            potionGenUseTime = Integer.parseInt(data[4].fieldValue);
            cfg.save();
        }
        catch (Exception e) {
            return;
        }
    }

    @Override
    public int[] getOutputSlots() {
        return new int[0];
    }
}

