/*
 * Decompiled with CFR 0.152.
 */
package ec3.common.tile;

import DummyCore.Utils.DataStorage;
import DummyCore.Utils.DummyData;
import ec3.common.tile.TileMRUGeneric;
import net.minecraftforge.common.config.Configuration;

public class TileMoonWell
extends TileMRUGeneric {
    public static float cfgMaxMRU = 10000.0f;
    public static float cfgBalance = 1.0f;
    public static float mruGenerated = 60.0f;

    public TileMoonWell() {
        this.maxMRU = (int)cfgMaxMRU;
    }

    public boolean canGenerateMRU() {
        int moonPhase = this.field_145850_b.field_73011_w.func_76559_b(this.field_145850_b.func_72820_D());
        boolean night = !this.field_145850_b.func_72935_r();
        return moonPhase != 4 && night && this.field_145850_b.func_72937_j(this.field_145851_c, this.field_145848_d + 1, this.field_145849_e);
    }

    @Override
    public void func_145845_h() {
        super.func_145845_h();
        this.balance = cfgBalance;
        if (!this.field_145850_b.func_72864_z(this.field_145851_c, this.field_145848_d, this.field_145849_e)) {
            int moonPhase = this.field_145850_b.field_73011_w.func_76559_b(this.field_145850_b.func_72820_D());
            float moonFactor = 1.0f;
            switch (moonPhase) {
                case 0: {
                    moonFactor = 1.0f;
                    break;
                }
                case 1: {
                    moonFactor = 0.75f;
                    break;
                }
                case 7: {
                    moonFactor = 0.75f;
                    break;
                }
                case 2: {
                    moonFactor = 0.5f;
                    break;
                }
                case 6: {
                    moonFactor = 0.5f;
                    break;
                }
                case 3: {
                    moonFactor = 0.25f;
                    break;
                }
                case 5: {
                    moonFactor = 0.25f;
                    break;
                }
                case 4: {
                    moonFactor = 0.0f;
                }
            }
            float mruGenerated = TileMoonWell.mruGenerated;
            mruGenerated *= moonFactor;
            float heightFactor = 1.0f;
            if (this.field_145848_d > 80) {
                heightFactor = 0.0f;
            } else {
                heightFactor = 1.0f - (float)this.field_145848_d / 80.0f;
                mruGenerated *= heightFactor;
            }
            if (mruGenerated > 0.0f && this.canGenerateMRU() && !this.field_145850_b.field_72995_K) {
                this.setMRU((int)((float)this.getMRU() + mruGenerated));
                if (this.getMRU() > this.getMaxMRU()) {
                    this.setMRU(this.getMaxMRU());
                }
            }
        }
    }

    public static void setupConfig(Configuration cfg) {
        try {
            cfg.load();
            String[] cfgArrayString = cfg.getStringList("MoonWellSettings", "tileentities", new String[]{"Max MRU:10000.0", "Default balance:1.0", "Max MRU generated per tick:60"}, "");
            String dataString = "";
            for (int i = 0; i < cfgArrayString.length; ++i) {
                dataString = dataString + "||" + cfgArrayString[i];
            }
            DummyData[] data = DataStorage.parseData((String)dataString);
            cfgMaxMRU = Float.parseFloat(data[0].fieldValue);
            cfgBalance = Float.parseFloat(data[1].fieldValue);
            mruGenerated = Float.parseFloat(data[2].fieldValue);
            cfg.save();
        }
        catch (Exception e) {
            return;
        }
    }

    @Override
    public int[] getOutputSlots() {
        return new int[0];
    }
}

