/*
 * Decompiled with CFR 0.152.
 */
package ec3.common.tile;

import DummyCore.Utils.Coord3D;
import DummyCore.Utils.DataStorage;
import DummyCore.Utils.DummyData;
import DummyCore.Utils.MathUtils;
import DummyCore.Utils.MiscUtils;
import DummyCore.Utils.Notifier;
import DummyCore.Utils.TileStatTracker;
import ec3.api.MithrilineFurnaceRecipe;
import ec3.api.MithrilineFurnaceRecipes;
import ec3.common.block.BlockMithrilineCrystal;
import ec3.common.block.BlocksCore;
import ec3.common.mod.EssentialCraftCore;
import ec3.common.tile.TileMithrilineCrystal;
import ec3.utils.common.ECUtils;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.Packet;
import net.minecraft.network.play.INetHandlerPlayClient;
import net.minecraft.network.play.server.S35PacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.common.config.Configuration;

public class TileMithrilineFurnace
extends TileEntity
implements IInventory {
    public static float maxEnergy = 10000.0f;
    public float energy;
    public float progress;
    public float reqProgress;
    private TileStatTracker tracker;
    public int syncTick;
    public ItemStack[] items = new ItemStack[2];
    public boolean requestSync = true;

    public TileMithrilineFurnace() {
        this.tracker = new TileStatTracker((TileEntity)this);
    }

    public void func_145839_a(NBTTagCompound i) {
        super.func_145839_a(i);
        MiscUtils.loadInventory((TileEntity)this, (NBTTagCompound)i);
        this.energy = i.func_74760_g("energy");
        this.progress = i.func_74760_g("progress");
    }

    public void func_145841_b(NBTTagCompound i) {
        super.func_145841_b(i);
        MiscUtils.saveInventory((TileEntity)this, (NBTTagCompound)i);
        i.func_74776_a("energy", this.energy);
        i.func_74776_a("progress", this.progress);
    }

    public void func_145845_h() {
        boolean correct = this.isStructureCorrect();
        super.func_145845_h();
        if (this.syncTick == 0) {
            if (this.tracker == null) {
                Notifier.notifyCustomMod((String)"EssentialCraft", (String)("[WARNING][SEVERE]TileEntity " + (Object)((Object)this) + " at pos " + this.field_145851_c + "," + this.field_145848_d + "," + this.field_145849_e + " tries to sync itself, but has no TileTracker attached to it! SEND THIS MESSAGE TO THE DEVELOPER OF THE MOD!"));
            } else if (!this.field_145850_b.field_72995_K && this.tracker.tileNeedsSyncing()) {
                MiscUtils.sendPacketToAllAround((World)this.field_145850_b, (Packet)this.func_145844_m(), (int)this.field_145851_c, (int)this.field_145848_d, (int)this.field_145849_e, (int)this.field_145850_b.field_73011_w.field_76574_g, (double)32.0);
            }
            this.syncTick = 60;
        } else {
            --this.syncTick;
        }
        if (this.requestSync && this.field_145850_b.field_72995_K) {
            this.requestSync = false;
            ECUtils.requestScheduledTileSync(this, EssentialCraftCore.proxy.getClientPlayer());
        }
        if (correct) {
            Coord3D[] possiblePowerSources = new Coord3D[]{new Coord3D(0.0f, 1.0f, 0.0f), new Coord3D(1.0f, 0.0f, 1.0f), new Coord3D(-1.0f, 0.0f, 1.0f), new Coord3D(1.0f, 0.0f, -1.0f), new Coord3D(-1.0f, 0.0f, -1.0f), new Coord3D(2.0f, 1.0f, 0.0f), new Coord3D(-2.0f, 1.0f, 0.0f), new Coord3D(0.0f, 1.0f, 2.0f), new Coord3D(0.0f, 1.0f, -2.0f), new Coord3D(2.0f, 2.0f, 2.0f), new Coord3D(-2.0f, 2.0f, 2.0f), new Coord3D(2.0f, 2.0f, -2.0f), new Coord3D(-2.0f, 2.0f, -2.0f)};
            if (this.energy < maxEnergy) {
                for (int i = 0; i < possiblePowerSources.length; ++i) {
                    TileEntity c_tile;
                    int dZ;
                    int dY;
                    Coord3D c = possiblePowerSources[i];
                    int dX = MathHelper.func_76141_d((float)c.x);
                    Block b = this.field_145850_b.func_147439_a(this.field_145851_c + dX, this.field_145848_d + (dY = MathHelper.func_76141_d((float)c.y)), this.field_145849_e + (dZ = MathHelper.func_76141_d((float)c.z)));
                    if (!(b instanceof BlockMithrilineCrystal) || (c_tile = this.field_145850_b.func_147438_o(this.field_145851_c + dX, this.field_145848_d + dY, this.field_145849_e + dZ)) == null || !(c_tile instanceof TileMithrilineCrystal)) continue;
                    TileMithrilineCrystal crystal = (TileMithrilineCrystal)c_tile;
                    float c_energy = crystal.energy;
                    float movement = this.field_145850_b.func_72820_D() % 60L;
                    if (movement > 30.0f) {
                        movement = 30.0f - movement + 30.0f;
                    }
                    if (this.energy + c_energy <= maxEnergy) {
                        this.energy += c_energy;
                        crystal.energy = 0.0f;
                        this.field_145850_b.func_72869_a("reddust", (double)((float)(this.field_145851_c + dX) + 0.5f), (double)((float)(this.field_145848_d + dY) + movement / 30.0f), (double)((float)(this.field_145849_e + dZ) + 0.5f), -1.0, 1.0, 0.0);
                        this.field_145850_b.func_72869_a("reddust", (double)((float)(this.field_145851_c + dX) + 0.5f), (double)((float)(this.field_145848_d + dY + 2) + movement / 30.0f), (double)((float)(this.field_145849_e + dZ) + 0.5f), -1.0, 1.0, 0.0);
                        continue;
                    }
                    float energyReq = maxEnergy - this.energy;
                    if (!(c_energy >= energyReq)) continue;
                    this.energy = maxEnergy;
                    crystal.energy -= energyReq;
                    this.field_145850_b.func_72869_a("reddust", (double)((float)(this.field_145851_c + dX) + 0.5f), (double)((float)(this.field_145848_d + dY) + movement / 30.0f), (double)((float)(this.field_145849_e + dZ) + 0.5f), -1.0, 1.0, 0.0);
                    this.field_145850_b.func_72869_a("reddust", (double)((float)(this.field_145851_c + dX) + 0.5f), (double)((float)(this.field_145848_d + dY + 2) + movement / 30.0f), (double)((float)(this.field_145849_e + dZ) + 0.5f), -1.0, 1.0, 0.0);
                }
            }
            if (this.func_70301_a(0) != null) {
                MithrilineFurnaceRecipe rec = MithrilineFurnaceRecipes.findRecipeByComponent(this.func_70301_a(0));
                if (rec != null && this.func_70301_a((int)0).field_77994_a >= rec.requiredRecipeSize) {
                    this.reqProgress = rec.enderStarPulsesRequired;
                    if (this.func_70301_a(1) == null || this.func_70301_a(1).func_77969_a(rec.result) && this.func_70301_a((int)1).field_77994_a + rec.result.field_77994_a <= this.func_70301_a(1).func_77976_d()) {
                        if (this.energy >= this.reqProgress) {
                            this.progress = this.reqProgress;
                            this.energy -= this.reqProgress;
                        } else {
                            this.progress += this.energy;
                            this.energy = 0.0f;
                        }
                        if (this.progress >= this.reqProgress) {
                            this.func_70298_a(0, rec.requiredRecipeSize);
                            if (this.func_70301_a(1) == null) {
                                this.func_70299_a(1, rec.result.func_77946_l());
                            } else {
                                this.func_70301_a((int)1).field_77994_a += rec.result.field_77994_a;
                            }
                            this.progress = 0.0f;
                        }
                    }
                } else {
                    this.progress = 0.0f;
                    this.reqProgress = 0.0f;
                }
            } else {
                this.progress = 0.0f;
                this.reqProgress = 0.0f;
            }
            for (int i = 0; i < 10; ++i) {
                EssentialCraftCore.proxy.FlameFX((float)this.field_145851_c + 0.5f + MathUtils.randomFloat((Random)this.field_145850_b.field_73012_v) * 0.4f, (float)this.field_145848_d + 0.2f + MathUtils.randomFloat((Random)this.field_145850_b.field_73012_v) * 0.6f, (float)this.field_145849_e + 0.5f + MathUtils.randomFloat((Random)this.field_145850_b.field_73012_v) * 0.4f, 0.0, 0.01f, 0.0, 0.0, 1.0, 0.0, 1.0);
            }
        }
    }

    public boolean isStructureCorrect() {
        int x = this.field_145851_c;
        int y = this.field_145848_d;
        int z = this.field_145849_e;
        boolean hasPlatformBelow = this.field_145850_b.func_147439_a(x, y - 1, z) == BlocksCore.invertedBlock && this.field_145850_b.func_147439_a(x - 1, y - 1, z) == BlocksCore.invertedBlock && this.field_145850_b.func_147439_a(x + 1, y - 1, z) == BlocksCore.invertedBlock && this.field_145850_b.func_147439_a(x, y - 1, z - 1) == BlocksCore.invertedBlock && this.field_145850_b.func_147439_a(x, y - 1, z + 1) == BlocksCore.invertedBlock && this.field_145850_b.func_147439_a(x + 1, y - 1, z + 1) == BlocksCore.invertedBlock && this.field_145850_b.func_147439_a(x + 1, y - 1, z - 1) == BlocksCore.invertedBlock && this.field_145850_b.func_147439_a(x - 1, y - 1, z + 1) == BlocksCore.invertedBlock && this.field_145850_b.func_147439_a(x - 1, y - 1, z - 1) == BlocksCore.invertedBlock && this.field_145850_b.func_147439_a(x - 2, y - 1, z) == BlocksCore.invertedBlock && this.field_145850_b.func_147439_a(x + 2, y - 1, z) == BlocksCore.invertedBlock && this.field_145850_b.func_147439_a(x, y - 1, z - 2) == BlocksCore.invertedBlock && this.field_145850_b.func_147439_a(x, y - 1, z + 2) == BlocksCore.invertedBlock;
        boolean hasGenericOutline = this.field_145850_b.func_147439_a(x - 2, y, z) == BlocksCore.invertedBlock && this.field_145850_b.func_147439_a(x + 2, y, z) == BlocksCore.invertedBlock && this.field_145850_b.func_147439_a(x, y, z - 2) == BlocksCore.invertedBlock && this.field_145850_b.func_147439_a(x, y, z + 2) == BlocksCore.invertedBlock && this.field_145850_b.func_147439_a(x - 2, y, z + 2) == BlocksCore.invertedBlock && this.field_145850_b.func_147439_a(x + 2, y, z - 2) == BlocksCore.invertedBlock && this.field_145850_b.func_147439_a(x - 2, y, z - 2) == BlocksCore.invertedBlock && this.field_145850_b.func_147439_a(x + 2, y, z + 2) == BlocksCore.invertedBlock && this.field_145850_b.func_147439_a(x - 2, y + 1, z + 2) == BlocksCore.invertedBlock && this.field_145850_b.func_147439_a(x + 2, y + 1, z - 2) == BlocksCore.invertedBlock && this.field_145850_b.func_147439_a(x - 2, y + 1, z - 2) == BlocksCore.invertedBlock && this.field_145850_b.func_147439_a(x + 2, y + 1, z + 2) == BlocksCore.invertedBlock;
        return hasPlatformBelow && hasGenericOutline;
    }

    public Packet func_145844_m() {
        NBTTagCompound nbttagcompound = new NBTTagCompound();
        this.func_145841_b(nbttagcompound);
        return new S35PacketUpdateTileEntity(this.field_145851_c, this.field_145848_d, this.field_145849_e, -10, nbttagcompound);
    }

    public void onDataPacket(NetworkManager net, S35PacketUpdateTileEntity pkt) {
        if (net.func_150729_e() instanceof INetHandlerPlayClient && pkt.func_148853_f() == -10) {
            this.func_145839_a(pkt.func_148857_g());
        }
    }

    public static void setupConfig(Configuration cfg) {
        try {
            cfg.load();
            String[] cfgArrayString = cfg.getStringList("MithrilineFurnaceSettings", "tileentities", new String[]{"Maximum enderstar pulse stored:10000"}, "");
            String dataString = "";
            for (int i = 0; i < cfgArrayString.length; ++i) {
                dataString = dataString + "||" + cfgArrayString[i];
            }
            DummyData[] data = DataStorage.parseData((String)dataString);
            maxEnergy = Float.parseFloat(data[0].fieldValue);
            cfg.save();
        }
        catch (Exception e) {
            return;
        }
    }

    public int func_70302_i_() {
        return this.items.length;
    }

    public ItemStack func_70301_a(int par1) {
        return this.items[par1];
    }

    public ItemStack func_70298_a(int par1, int par2) {
        if (this.items[par1] != null) {
            if (this.items[par1].field_77994_a <= par2) {
                ItemStack itemstack = this.items[par1];
                this.items[par1] = null;
                return itemstack;
            }
            ItemStack itemstack = this.items[par1].func_77979_a(par2);
            if (this.items[par1].field_77994_a == 0) {
                this.items[par1] = null;
            }
            return itemstack;
        }
        return null;
    }

    public ItemStack func_70304_b(int par1) {
        if (this.items[par1] != null) {
            ItemStack itemstack = this.items[par1];
            this.items[par1] = null;
            return itemstack;
        }
        return null;
    }

    public void func_70299_a(int par1, ItemStack par2ItemStack) {
        this.items[par1] = par2ItemStack;
        if (par2ItemStack != null && par2ItemStack.field_77994_a > this.func_70297_j_()) {
            par2ItemStack.field_77994_a = this.func_70297_j_();
        }
    }

    public String func_145825_b() {
        return "ec3.container.mithrilineFurnace";
    }

    public boolean func_145818_k_() {
        return false;
    }

    public int func_70297_j_() {
        return 64;
    }

    public boolean func_70300_a(EntityPlayer player) {
        return this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d, this.field_145849_e) == this && player.field_71093_bK == this.field_145850_b.field_73011_w.field_76574_g;
    }

    public void func_70295_k_() {
    }

    public void func_70305_f() {
    }

    public boolean func_94041_b(int p_94041_1_, ItemStack p_94041_2_) {
        return p_94041_1_ != 1;
    }
}

