/*
 * Decompiled with CFR 0.152.
 */
package ec3.common.tile;

import DummyCore.Utils.DataStorage;
import DummyCore.Utils.DummyData;
import ec3.api.MagicianTableRecipe;
import ec3.api.MagicianTableRecipes;
import ec3.api.MagicianTableUpgrades;
import ec3.common.tile.TileMRUGeneric;
import ec3.utils.common.ECUtils;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.config.Configuration;

public class TileMagicianTable
extends TileMRUGeneric {
    public float progressLevel;
    public float progressRequired;
    public float speedFactor = 1.0f;
    public float mruConsume = 1.0f;
    public int upgrade = -1;
    public MagicianTableRecipe currentRecipe;
    public static float cfgMaxMRU = 5000.0f;
    public static boolean generatesCorruption = true;
    public static int genCorruption = 1;
    public static float mruUsage = 1.0f;

    public TileMagicianTable() {
        this.maxMRU = (int)cfgMaxMRU;
        this.setSlotsNum(7);
    }

    public boolean canGenerateMRU() {
        return false;
    }

    @Override
    public void func_145845_h() {
        this.speedFactor = this.upgrade == -1 ? 1.0f : MagicianTableUpgrades.upgradeEfficency.get(this.upgrade).floatValue();
        this.mruConsume = this.speedFactor != 1.0f ? this.speedFactor * 2.0f * mruUsage : 1.0f * mruUsage;
        super.func_145845_h();
        ECUtils.manage(this, 0);
        if (!this.field_145850_b.func_72864_z(this.field_145851_c, this.field_145848_d, this.field_145849_e)) {
            ItemStack[] craftMatrix = new ItemStack[]{this.func_70301_a(1), this.func_70301_a(2), this.func_70301_a(3), this.func_70301_a(4), this.func_70301_a(5)};
            MagicianTableRecipe rec = MagicianTableRecipes.getRecipeByCP(craftMatrix);
            if (this.currentRecipe == null && rec != null && this.progressRequired == (float)rec.mruRequired && this.progressLevel != 0.0f && this.canFunction(rec)) {
                this.progressRequired = rec.mruRequired;
                this.currentRecipe = rec;
            }
            if (this.currentRecipe == null && rec != null && this.progressRequired == 0.0f && this.progressLevel == 0.0f && this.canFunction(rec)) {
                this.progressRequired = rec.mruRequired;
                this.currentRecipe = rec;
            }
            if (this.currentRecipe != null && rec == null) {
                this.progressRequired = 0.0f;
                this.progressLevel = 0.0f;
                this.currentRecipe = null;
                return;
            }
            if (this.currentRecipe != null && rec != null && this.progressRequired != 0.0f) {
                if (!this.canFunction(rec)) {
                    this.progressRequired = 0.0f;
                    this.progressLevel = 0.0f;
                    this.currentRecipe = null;
                    return;
                }
                float mruReq = this.mruConsume;
                if ((float)this.getMRU() >= mruReq && this.progressLevel < this.progressRequired) {
                    this.progressLevel += this.speedFactor;
                    if (generatesCorruption) {
                        ECUtils.increaseCorruptionAt(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e, this.field_145850_b.field_73012_v.nextInt(genCorruption));
                    }
                    this.setMRU((int)((float)this.getMRU() - mruReq));
                    if (this.progressLevel >= this.progressRequired) {
                        this.progressRequired = 0.0f;
                        this.progressLevel = 0.0f;
                        this.craft();
                        this.currentRecipe = null;
                    }
                }
            }
        }
    }

    @Override
    public void func_145839_a(NBTTagCompound i) {
        super.func_145839_a(i);
        this.progressLevel = i.func_74760_g("progressLevel");
        this.progressRequired = i.func_74760_g("progressRequired");
        this.speedFactor = i.func_74760_g("speedFactor");
        this.mruConsume = i.func_74760_g("mruConsume");
        this.upgrade = i.func_74762_e("upgrade");
    }

    @Override
    public void func_145841_b(NBTTagCompound i) {
        super.func_145841_b(i);
        i.func_74776_a("progressLevel", this.progressLevel);
        i.func_74776_a("progressRequired", this.progressRequired);
        i.func_74776_a("speedFactor", this.speedFactor);
        i.func_74776_a("mruConsume", this.mruConsume);
        i.func_74768_a("upgrade", this.upgrade);
    }

    public boolean canFunction(MagicianTableRecipe rec) {
        ItemStack result = rec.result;
        if (result != null) {
            if (this.func_70301_a(6) == null) {
                return true;
            }
            if (this.func_70301_a(6).func_77969_a(result) && this.func_70301_a((int)6).field_77994_a + result.field_77994_a <= this.func_70297_j_() && this.func_70301_a((int)6).field_77994_a + result.field_77994_a <= this.func_70301_a(6).func_77976_d()) {
                return true;
            }
        }
        return false;
    }

    public void craft() {
        if (this.canFunction(this.currentRecipe)) {
            ItemStack stk = this.currentRecipe.result;
            if (this.func_70301_a(6) == null) {
                ItemStack copied = stk.func_77946_l();
                if (copied.field_77994_a == 0) {
                    copied.field_77994_a = 1;
                }
                this.func_70299_a(6, copied);
            } else if (this.func_70301_a(6).func_77973_b() == stk.func_77973_b()) {
                this.func_70299_a(6, new ItemStack(stk.func_77973_b(), stk.field_77994_a + this.func_70301_a((int)6).field_77994_a, stk.func_77960_j()));
            }
            for (int i = 1; i < 6; ++i) {
                this.func_70298_a(i, 1);
            }
        }
    }

    public static void setupConfig(Configuration cfg) {
        try {
            cfg.load();
            String[] cfgArrayString = cfg.getStringList("MagicianTableSettings", "tileentities", new String[]{"Max MRU:5000.0", "MRU Usage Modifier:1.0", "Can this device actually generate corruption:true", "The amount of corruption generated each tick(do not set to 0!):1"}, "");
            String dataString = "";
            for (int i = 0; i < cfgArrayString.length; ++i) {
                dataString = dataString + "||" + cfgArrayString[i];
            }
            DummyData[] data = DataStorage.parseData((String)dataString);
            mruUsage = Float.parseFloat(data[1].fieldValue);
            cfgMaxMRU = Float.parseFloat(data[0].fieldValue);
            generatesCorruption = Boolean.parseBoolean(data[2].fieldValue);
            genCorruption = Integer.parseInt(data[3].fieldValue);
            cfg.save();
        }
        catch (Exception e) {
            return;
        }
    }

    @Override
    public int[] getOutputSlots() {
        return new int[]{6};
    }
}

