/*
 * Decompiled with CFR 0.152.
 */
package ec3.common.tile;

import DummyCore.Utils.DataStorage;
import DummyCore.Utils.DummyData;
import DummyCore.Utils.MathUtils;
import ec3.common.block.BlocksCore;
import ec3.common.item.ItemsCore;
import ec3.common.mod.EssentialCraftCore;
import ec3.common.tile.TileMRUGeneric;
import ec3.utils.common.ECUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.FurnaceRecipes;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.AxisAlignedBB;
import net.minecraftforge.common.config.Configuration;

public class TileMagicalFurnace
extends TileMRUGeneric {
    public int progressLevel;
    public static float cfgMaxMRU = 50000.0f;
    public static int mruUsage = 25;
    public static int smeltingTime = 20;
    public static float chanceToDoubleOutput = 0.3f;
    public static float chanceToDoubleSlags = 0.1f;

    public TileMagicalFurnace() {
        this.setSlotsNum(1);
    }

    @Override
    public void func_145839_a(NBTTagCompound par1NBTTagCompound) {
        super.func_145839_a(par1NBTTagCompound);
        this.progressLevel = par1NBTTagCompound.func_74762_e("progress");
    }

    @Override
    public void func_145841_b(NBTTagCompound par1NBTTagCompound) {
        super.func_145841_b(par1NBTTagCompound);
        par1NBTTagCompound.func_74768_a("progress", this.progressLevel);
    }

    @Override
    public void func_145845_h() {
        this.maxMRU = (int)cfgMaxMRU;
        super.func_145845_h();
        this.spawnParticles();
        ECUtils.manage(this, 0);
        if (!this.field_145850_b.func_72864_z(this.field_145851_c, this.field_145848_d, this.field_145849_e)) {
            this.smelt();
        }
    }

    public boolean isStructureCorrect() {
        boolean flag = true;
        for (int x = -2; x <= 2; ++x) {
            for (int z = -2; z <= 2; ++z) {
                boolean bl = flag = this.field_145850_b.func_147439_a(this.field_145851_c + x, this.field_145848_d - 1, this.field_145849_e + z) == BlocksCore.voidStone;
                if (flag) continue;
                return false;
            }
        }
        flag = this.field_145850_b.func_147439_a(this.field_145851_c + 2, this.field_145848_d, this.field_145849_e + 2) == BlocksCore.voidStone && this.field_145850_b.func_147439_a(this.field_145851_c - 2, this.field_145848_d, this.field_145849_e + 2) == BlocksCore.voidStone && this.field_145850_b.func_147439_a(this.field_145851_c + 2, this.field_145848_d, this.field_145849_e - 2) == BlocksCore.voidStone && this.field_145850_b.func_147439_a(this.field_145851_c - 2, this.field_145848_d, this.field_145849_e - 2) == BlocksCore.voidStone && this.field_145850_b.func_147439_a(this.field_145851_c + 2, this.field_145848_d + 1, this.field_145849_e + 2) == BlocksCore.heatGenerator && this.field_145850_b.func_147439_a(this.field_145851_c - 2, this.field_145848_d + 1, this.field_145849_e + 2) == BlocksCore.heatGenerator && this.field_145850_b.func_147439_a(this.field_145851_c + 2, this.field_145848_d + 1, this.field_145849_e - 2) == BlocksCore.heatGenerator && this.field_145850_b.func_147439_a(this.field_145851_c - 2, this.field_145848_d + 1, this.field_145849_e - 2) == BlocksCore.heatGenerator;
        return flag;
    }

    public void smelt() {
        ItemStack smeltingStack = this.getSmeltingStack();
        EntityItem smeltingItem = this.getSmeltingItem();
        if (this.isStructureCorrect() && this.getMRU() > 0 && smeltingStack != null && smeltingItem != null) {
            if (this.progressLevel == 0) {
                this.field_145850_b.func_72908_a((double)this.field_145851_c + 0.5, (double)this.field_145848_d + 0.5, (double)this.field_145849_e + 0.5, "fire.fire", 1.0f, 1.0f);
            }
            ItemStack mainSmelting = smeltingStack.func_77946_l();
            ++this.progressLevel;
            this.setMRU(this.getMRU() - mruUsage);
            if (this.progressLevel >= smeltingTime) {
                EntityItem slag;
                EntityItem smelted;
                this.progressLevel = 0;
                this.field_145850_b.func_72908_a((double)this.field_145851_c + 0.5, (double)this.field_145848_d + 0.5, (double)this.field_145849_e + 0.5, "liquid.lavapop", 1.0f, 1.0f);
                ItemStack s = FurnaceRecipes.func_77602_a().func_151395_a(mainSmelting);
                ++s.field_77994_a;
                if (!this.field_145850_b.field_72995_K) {
                    --smeltingItem.func_92059_d().field_77994_a;
                    if (smeltingItem.func_92059_d().field_77994_a <= 0) {
                        smeltingItem.func_70107_b(0.0, 0.0, 0.0);
                        smeltingItem.func_70106_y();
                    }
                }
                if (!this.field_145850_b.field_72995_K && this.field_145850_b.field_73012_v.nextFloat() <= chanceToDoubleOutput) {
                    smelted = new EntityItem(this.field_145850_b, (double)this.field_145851_c - 1.5, (double)this.field_145848_d + 2.15, (double)this.field_145849_e - 1.5, s.func_77946_l());
                    this.field_145850_b.func_72838_d((Entity)smelted);
                    smelted.field_70159_w = 0.0;
                    smelted.field_70181_x = 0.0;
                    smelted.field_70179_y = 0.0;
                }
                smelted = new EntityItem(this.field_145850_b, (double)this.field_145851_c + 2.5, (double)this.field_145848_d + 2.15, (double)this.field_145849_e + 2.5, s.func_77946_l());
                if (!this.field_145850_b.field_72995_K) {
                    this.field_145850_b.func_72838_d((Entity)smelted);
                }
                smelted.field_70159_w = 0.0;
                smelted.field_70181_x = 0.0;
                smelted.field_70179_y = 0.0;
                if (!this.field_145850_b.field_72995_K && this.field_145850_b.field_73012_v.nextFloat() <= chanceToDoubleSlags) {
                    slag = new EntityItem(this.field_145850_b, (double)this.field_145851_c - 1.5, (double)this.field_145848_d + 2.15, (double)this.field_145849_e + 2.5, new ItemStack(ItemsCore.magicalSlag));
                    this.field_145850_b.func_72838_d((Entity)slag);
                    smelted.field_70159_w = 0.0;
                    smelted.field_70181_x = 0.0;
                    smelted.field_70179_y = 0.0;
                }
                slag = new EntityItem(this.field_145850_b, (double)this.field_145851_c + 2.5, (double)this.field_145848_d + 2.15, (double)this.field_145849_e - 1.5, new ItemStack(ItemsCore.magicalSlag));
                if (!this.field_145850_b.field_72995_K) {
                    this.field_145850_b.func_72838_d((Entity)slag);
                }
                smelted.field_70159_w = 0.0;
                smelted.field_70181_x = 0.0;
                smelted.field_70179_y = 0.0;
                s.field_77994_a = 0;
                s = null;
            }
        } else {
            this.progressLevel = 0;
        }
    }

    public EntityItem getSmeltingItem() {
        EntityItem ret = null;
        List l = this.field_145850_b.func_72872_a(EntityItem.class, AxisAlignedBB.func_72330_a((double)this.field_145851_c, (double)this.field_145848_d, (double)this.field_145849_e, (double)(this.field_145851_c + 1), (double)(this.field_145848_d + 2), (double)(this.field_145849_e + 1)));
        if (!l.isEmpty()) {
            for (int i = 0; i < l.size(); ++i) {
                EntityItem item = (EntityItem)l.get(i);
                if (FurnaceRecipes.func_77602_a().func_151395_a(item.func_92059_d()) == null) continue;
                return item;
            }
        }
        return ret;
    }

    public ItemStack getSmeltingStack() {
        ItemStack ret = null;
        List l = this.field_145850_b.func_72872_a(EntityItem.class, AxisAlignedBB.func_72330_a((double)this.field_145851_c, (double)this.field_145848_d, (double)this.field_145849_e, (double)(this.field_145851_c + 1), (double)(this.field_145848_d + 2), (double)(this.field_145849_e + 1)));
        if (!l.isEmpty()) {
            ArrayList<ItemStack> canBeSmelted = new ArrayList<ItemStack>();
            for (int i = 0; i < l.size(); ++i) {
                EntityItem item = (EntityItem)l.get(i);
                if (FurnaceRecipes.func_77602_a().func_151395_a(item.func_92059_d()) == null) continue;
                canBeSmelted.add(item.func_92059_d());
            }
            if (!canBeSmelted.isEmpty()) {
                ret = (ItemStack)canBeSmelted.get(0);
            }
        }
        return ret;
    }

    public void spawnParticles() {
        if (this.isStructureCorrect()) {
            EssentialCraftCore.proxy.spawnParticle("cSpellFX", (float)this.field_145851_c + 0.5f + MathUtils.randomFloat((Random)this.field_145850_b.field_73012_v) * 3.0f, this.field_145848_d, (float)this.field_145849_e + 0.5f + MathUtils.randomFloat((Random)this.field_145850_b.field_73012_v) * 3.0f, 0.0, 2.0, 0.0);
        }
    }

    public static void setupConfig(Configuration cfg) {
        try {
            cfg.load();
            String[] cfgArrayString = cfg.getStringList("MagicalFurnaceSettings", "tileentities", new String[]{"Max MRU:50000.0", "MRU Usage:25", "Ticks required to smelt 1 item:20", "Chance to double the outcome:0.3", "Chance to double slags outcome:0.1"}, "");
            String dataString = "";
            for (int i = 0; i < cfgArrayString.length; ++i) {
                dataString = dataString + "||" + cfgArrayString[i];
            }
            DummyData[] data = DataStorage.parseData((String)dataString);
            mruUsage = Integer.parseInt(data[1].fieldValue);
            smeltingTime = Integer.parseInt(data[2].fieldValue);
            cfgMaxMRU = Float.parseFloat(data[0].fieldValue);
            chanceToDoubleOutput = Float.parseFloat(data[3].fieldValue);
            chanceToDoubleSlags = Float.parseFloat(data[4].fieldValue);
            cfg.save();
        }
        catch (Exception e) {
            return;
        }
    }

    @Override
    public int[] getOutputSlots() {
        return new int[]{0};
    }
}

