/*
 * Decompiled with CFR 0.152.
 */
package ec3.common.tile;

import DummyCore.Utils.MiscUtils;
import DummyCore.Utils.Notifier;
import DummyCore.Utils.TileStatTracker;
import ec3.common.mod.EssentialCraftCore;
import ec3.utils.common.ECUtils;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.Packet;
import net.minecraft.network.play.INetHandlerPlayClient;
import net.minecraft.network.play.server.S35PacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;

public class TileMagicalChest
extends TileEntity
implements IInventory,
ISidedInventory {
    public float lidAngle;
    public float prevLidAngle;
    public int numUsingPlayers;
    private int ticksSinceSync;
    private ItemStack[] inventory;
    public String ownerName = "no name";
    public int syncTick;
    public int rotation;
    private TileStatTracker tracker = new TileStatTracker((TileEntity)this);
    public boolean requestSync = true;

    public TileMagicalChest(int metaData) {
        this();
        if (metaData == 0) {
            this.inventory = new ItemStack[54];
        } else if (metaData == 1) {
            this.inventory = new ItemStack[117];
        }
    }

    public TileMagicalChest() {
    }

    public int func_70302_i_() {
        return this.inventory.length;
    }

    public ItemStack func_70301_a(int slotIndex) {
        return this.inventory[slotIndex];
    }

    public ItemStack func_70298_a(int slotIndex, int decrementAmount) {
        ItemStack itemStack = this.func_70301_a(slotIndex);
        if (itemStack != null) {
            if (itemStack.field_77994_a <= decrementAmount) {
                this.func_70299_a(slotIndex, null);
            } else {
                itemStack = itemStack.func_77979_a(decrementAmount);
                if (itemStack.field_77994_a == 0) {
                    this.func_70299_a(slotIndex, null);
                }
            }
        }
        return itemStack;
    }

    public ItemStack func_70304_b(int slotIndex) {
        if (this.inventory[slotIndex] != null) {
            ItemStack itemStack = this.inventory[slotIndex];
            this.inventory[slotIndex] = null;
            return itemStack;
        }
        return null;
    }

    public void func_70299_a(int slotIndex, ItemStack itemStack) {
        this.inventory[slotIndex] = itemStack;
        if (itemStack != null && itemStack.field_77994_a > this.func_70297_j_()) {
            itemStack.field_77994_a = this.func_70297_j_();
        }
        this.func_70296_d();
    }

    public String func_145825_b() {
        return "magicalChest";
    }

    public boolean func_145818_k_() {
        return false;
    }

    public int func_70297_j_() {
        return 64;
    }

    public boolean func_70300_a(EntityPlayer entityplayer) {
        return this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d, this.field_145849_e) == this && entityplayer.func_70092_e((double)this.field_145851_c + 0.5, (double)this.field_145848_d + 0.5, (double)this.field_145849_e + 0.5) <= 64.0;
    }

    public void func_70295_k_() {
        ++this.numUsingPlayers;
        this.field_145850_b.func_147452_c(this.field_145851_c, this.field_145848_d, this.field_145849_e, this.field_145850_b.func_147439_a(this.field_145851_c, this.field_145848_d, this.field_145849_e), 1, this.numUsingPlayers);
    }

    public void func_70305_f() {
        --this.numUsingPlayers;
        this.field_145850_b.func_147452_c(this.field_145851_c, this.field_145848_d, this.field_145849_e, this.field_145850_b.func_147439_a(this.field_145851_c, this.field_145848_d, this.field_145849_e), 1, this.numUsingPlayers);
    }

    public boolean func_94041_b(int slotIndex, ItemStack itemStack) {
        return true;
    }

    public void func_145845_h() {
        super.func_145845_h();
        if (this.syncTick == 0) {
            if (this.tracker == null) {
                Notifier.notifyCustomMod((String)"EssentialCraft", (String)("[WARNING][SEVERE]TileEntity " + (Object)((Object)this) + " at pos " + this.field_145851_c + "," + this.field_145848_d + "," + this.field_145849_e + " tries to sync itself, but has no TileTracker attached to it! SEND THIS MESSAGE TO THE DEVELOPER OF THE MOD!"));
            } else if (!this.field_145850_b.field_72995_K && this.tracker.tileNeedsSyncing()) {
                MiscUtils.sendPacketToAllAround((World)this.field_145850_b, (Packet)this.func_145844_m(), (int)this.field_145851_c, (int)this.field_145848_d, (int)this.field_145849_e, (int)this.field_145850_b.field_73011_w.field_76574_g, (double)32.0);
            }
            this.syncTick = 60;
        } else {
            --this.syncTick;
        }
        if (this.requestSync && this.field_145850_b.field_72995_K) {
            this.requestSync = false;
            ECUtils.requestScheduledTileSync(this, EssentialCraftCore.proxy.getClientPlayer());
        }
        if (++this.ticksSinceSync % 20 * 4 == 0) {
            this.field_145850_b.func_147452_c(this.field_145851_c, this.field_145848_d, this.field_145849_e, this.field_145850_b.func_147439_a(this.field_145851_c, this.field_145848_d, this.field_145849_e), 1, this.numUsingPlayers);
        }
        this.prevLidAngle = this.lidAngle;
        float angleIncrement = 0.1f;
        if (this.numUsingPlayers > 0 && this.lidAngle == 0.0f) {
            this.field_145850_b.func_72908_a((double)this.field_145851_c + 0.5, (double)this.field_145848_d + 0.5, (double)this.field_145849_e + 0.5, "random.chestopen", 0.5f, this.field_145850_b.field_73012_v.nextFloat() * 0.1f + 0.9f);
        }
        if (this.numUsingPlayers == 0 && this.lidAngle > 0.0f || this.numUsingPlayers > 0 && this.lidAngle < 1.0f) {
            float var8 = this.lidAngle;
            this.lidAngle = this.numUsingPlayers > 0 ? (this.lidAngle += angleIncrement) : (this.lidAngle -= angleIncrement);
            if (this.lidAngle > 1.0f) {
                this.lidAngle = 1.0f;
            }
            if (this.lidAngle < 0.5f && var8 >= 0.5f) {
                this.field_145850_b.func_72908_a((double)this.field_145851_c + 0.5, (double)this.field_145848_d + 0.5, (double)this.field_145849_e + 0.5, "random.chestclosed", 0.5f, this.field_145850_b.field_73012_v.nextFloat() * 0.1f + 0.9f);
            }
            if (this.lidAngle < 0.0f) {
                this.lidAngle = 0.0f;
            }
        }
    }

    public boolean func_145842_c(int eventID, int numUsingPlayers) {
        if (eventID == 1) {
            this.numUsingPlayers = numUsingPlayers;
            return true;
        }
        return super.func_145842_c(eventID, numUsingPlayers);
    }

    public void func_145839_a(NBTTagCompound nbtTagCompound) {
        super.func_145839_a(nbtTagCompound);
        this.rotation = nbtTagCompound.func_74762_e("0");
        this.ownerName = nbtTagCompound.func_74779_i("1");
        NBTTagList tagList = nbtTagCompound.func_150295_c("Items", 10);
        this.inventory = new ItemStack[nbtTagCompound.func_74762_e("invSize")];
        for (int i = 0; i < tagList.func_74745_c(); ++i) {
            NBTTagCompound tagCompound = tagList.func_150305_b(i);
            byte slotIndex = tagCompound.func_74771_c("Slot");
            if (slotIndex < 0 || slotIndex >= this.inventory.length) continue;
            this.inventory[slotIndex] = ItemStack.func_77949_a((NBTTagCompound)tagCompound);
        }
    }

    public void func_145841_b(NBTTagCompound nbtTagCompound) {
        super.func_145841_b(nbtTagCompound);
        nbtTagCompound.func_74768_a("0", this.rotation);
        nbtTagCompound.func_74778_a("1", this.ownerName);
        nbtTagCompound.func_74768_a("invSize", this.func_70302_i_());
        NBTTagList tagList = new NBTTagList();
        for (int currentIndex = 0; currentIndex < this.inventory.length; ++currentIndex) {
            if (this.inventory[currentIndex] == null) continue;
            NBTTagCompound tagCompound = new NBTTagCompound();
            tagCompound.func_74774_a("Slot", (byte)currentIndex);
            this.inventory[currentIndex].func_77955_b(tagCompound);
            tagList.func_74742_a((NBTBase)tagCompound);
        }
        nbtTagCompound.func_74782_a("Items", (NBTBase)tagList);
    }

    public Packet func_145844_m() {
        NBTTagCompound nbttagcompound = new NBTTagCompound();
        nbttagcompound.func_74768_a("x", this.field_145851_c);
        nbttagcompound.func_74768_a("y", this.field_145848_d);
        nbttagcompound.func_74768_a("z", this.field_145849_e);
        nbttagcompound.func_74768_a("0", this.rotation);
        nbttagcompound.func_74778_a("1", this.ownerName);
        return new S35PacketUpdateTileEntity(this.field_145851_c, this.field_145848_d, this.field_145849_e, -10, nbttagcompound);
    }

    public void onDataPacket(NetworkManager net, S35PacketUpdateTileEntity pkt) {
        if (net.func_150729_e() instanceof INetHandlerPlayClient && pkt.func_148853_f() == -10 && pkt.func_148857_g().func_74764_b("0")) {
            this.rotation = pkt.func_148857_g().func_74762_e("0");
            this.ownerName = pkt.func_148857_g().func_74779_i("1");
        }
    }

    public int[] func_94128_d(int side) {
        int[] ret = new int[this.inventory.length];
        for (int i = 0; i < ret.length; ++i) {
            ret[i] = i;
        }
        return ret;
    }

    public boolean func_102007_a(int p_102007_1_, ItemStack p_102007_2_, int p_102007_3_) {
        return true;
    }

    public boolean func_102008_b(int p_102008_1_, ItemStack p_102008_2_, int p_102008_3_) {
        return true;
    }
}

