/*
 * Decompiled with CFR 0.152.
 */
package ec3.common.tile;

import DummyCore.Utils.DataStorage;
import DummyCore.Utils.DummyData;
import DummyCore.Utils.MathUtils;
import ec3.common.item.ItemsCore;
import ec3.common.tile.TileMRUGeneric;
import ec3.utils.common.ECUtils;
import ec3.utils.common.EnumOreColoring;
import java.util.ArrayList;
import java.util.Random;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.oredict.OreDictionary;

public class TileFurnaceMagic
extends TileMRUGeneric {
    public int progressLevel;
    public int smeltingLevel;
    public static float cfgMaxMRU = 5000.0f;
    public static boolean generatesCorruption = false;
    public static int genCorruption = 2;
    public static int mruUsage = 25;
    public static int smeltingTime = 400;

    public TileFurnaceMagic() {
        this.maxMRU = (int)cfgMaxMRU;
        this.setSlotsNum(3);
    }

    @Override
    public void func_145839_a(NBTTagCompound i) {
        super.func_145839_a(i);
        this.progressLevel = i.func_74762_e("progress");
        this.smeltingLevel = i.func_74762_e("smelting");
    }

    @Override
    public void func_145841_b(NBTTagCompound i) {
        super.func_145841_b(i);
        i.func_74768_a("progress", this.progressLevel);
        i.func_74768_a("smelting", this.smeltingLevel);
    }

    @Override
    public void func_145845_h() {
        int usage = mruUsage;
        int time = smeltingTime / (this.func_145832_p() / 4 + 1);
        super.func_145845_h();
        ECUtils.manage(this, 0);
        if (!this.field_145850_b.func_72864_z(this.field_145851_c, this.field_145848_d, this.field_145849_e)) {
            ItemStack ore = this.func_70301_a(1);
            if (ore != null) {
                int[] oreIds = OreDictionary.getOreIDs((ItemStack)ore);
                String oreName = "Unknown";
                if (oreIds.length > 0) {
                    oreName = OreDictionary.getOreName((int)oreIds[0]);
                }
                int metadata = -1;
                for (int i = 0; i < EnumOreColoring.values().length; ++i) {
                    EnumOreColoring oreColor = EnumOreColoring.values()[i];
                    if (!oreName.equalsIgnoreCase(oreColor.oreName)) continue;
                    metadata = i;
                    break;
                }
                if (metadata != -1) {
                    int suggestedStackSize;
                    if (this.func_70301_a(2) == null) {
                        if (this.getMRU() - usage >= 0) {
                            this.setMRU(this.getMRU() - usage);
                            this.field_145850_b.func_72869_a("flame", (double)this.field_145851_c + 0.5 + MathUtils.randomDouble((Random)this.field_145850_b.field_73012_v) / 2.2, (double)this.field_145848_d, (double)this.field_145849_e + 0.5 + MathUtils.randomDouble((Random)this.field_145850_b.field_73012_v) / 2.2, 0.0, -0.1, 0.0);
                            ++this.progressLevel;
                            if (generatesCorruption) {
                                ECUtils.increaseCorruptionAt(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e, this.field_145850_b.field_73012_v.nextInt(genCorruption));
                            }
                            if (this.progressLevel >= time && !this.field_145850_b.field_72995_K) {
                                this.func_70298_a(1, 1);
                                suggestedStackSize = EnumOreColoring.values()[metadata].dropAmount;
                                this.func_70299_a(2, new ItemStack(ItemsCore.magicalAlloy, suggestedStackSize, metadata));
                                this.progressLevel = 0;
                                this.syncTick = 0;
                            }
                        }
                    } else if (this.func_70301_a(2).func_77973_b() == ItemsCore.magicalAlloy && this.func_70301_a(2).func_77960_j() == metadata && this.func_70301_a((int)2).field_77994_a + 1 <= this.func_70301_a(2).func_77976_d() && this.func_70301_a((int)2).field_77994_a + 1 <= this.func_70297_j_() && this.getMRU() - usage >= 0) {
                        this.setMRU(this.getMRU() - usage);
                        this.field_145850_b.func_72869_a("flame", (double)this.field_145851_c + 0.5 + MathUtils.randomDouble((Random)this.field_145850_b.field_73012_v) / 2.2, (double)this.field_145848_d, (double)this.field_145849_e + 0.5 + MathUtils.randomDouble((Random)this.field_145850_b.field_73012_v) / 2.2, 0.0, -0.1, 0.0);
                        ++this.progressLevel;
                        if (generatesCorruption) {
                            ECUtils.increaseCorruptionAt(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e, this.field_145850_b.field_73012_v.nextInt(genCorruption));
                        }
                        if (this.progressLevel >= time && !this.field_145850_b.field_72995_K) {
                            this.func_70298_a(1, 1);
                            suggestedStackSize = EnumOreColoring.values()[metadata].dropAmount;
                            ItemStack is = this.func_70301_a(2);
                            is.field_77994_a += suggestedStackSize;
                            if (is.field_77994_a > is.func_77976_d()) {
                                is.field_77994_a = is.func_77976_d();
                            }
                            this.func_70299_a(2, is);
                            this.progressLevel = 0;
                            this.syncTick = 0;
                        }
                    }
                } else {
                    this.progressLevel = 0;
                }
            } else {
                this.progressLevel = 0;
            }
            ItemStack alloy = this.func_70301_a(1);
            if (alloy != null && this.func_70301_a(1).func_77973_b() == ItemsCore.magicalAlloy) {
                EnumOreColoring oreColor = EnumOreColoring.values()[alloy.func_77960_j()];
                String oreName = oreColor.oreName;
                String outputName = oreColor.outputName;
                String suggestedIngotName = outputName.isEmpty() ? "ingot" + oreName.substring(3) : outputName;
                ArrayList oreLst = OreDictionary.getOres((String)suggestedIngotName);
                if (oreLst != null && !oreLst.isEmpty()) {
                    ItemStack ingotStk = ((ItemStack)oreLst.get(0)).func_77946_l();
                    if (this.func_70301_a(2) == null) {
                        if (this.getMRU() - usage >= 0) {
                            this.setMRU(this.getMRU() - usage);
                            this.field_145850_b.func_72869_a("flame", (double)this.field_145851_c + 0.5 + MathUtils.randomDouble((Random)this.field_145850_b.field_73012_v) / 2.2, (double)this.field_145848_d, (double)this.field_145849_e + 0.5 + MathUtils.randomDouble((Random)this.field_145850_b.field_73012_v) / 2.2, 0.0, -0.1, 0.0);
                            ++this.smeltingLevel;
                            if (generatesCorruption) {
                                ECUtils.increaseCorruptionAt(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e, this.field_145850_b.field_73012_v.nextInt(genCorruption));
                            }
                            if (this.smeltingLevel >= time && !this.field_145850_b.field_72995_K) {
                                int suggestedStackSize;
                                this.func_70298_a(1, 1);
                                ingotStk.field_77994_a = suggestedStackSize = 2;
                                this.func_70299_a(2, ingotStk);
                                this.smeltingLevel = 0;
                                this.syncTick = 0;
                            }
                        }
                    } else if (this.func_70301_a(2).func_77969_a(ingotStk) && this.func_70301_a((int)2).field_77994_a + 2 <= this.func_70301_a(2).func_77976_d() && this.func_70301_a((int)2).field_77994_a + 2 <= this.func_70297_j_() && this.getMRU() - usage >= 0) {
                        this.setMRU(this.getMRU() - usage);
                        this.field_145850_b.func_72869_a("flame", (double)this.field_145851_c + 0.5 + MathUtils.randomDouble((Random)this.field_145850_b.field_73012_v) / 2.2, (double)this.field_145848_d, (double)this.field_145849_e + 0.5 + MathUtils.randomDouble((Random)this.field_145850_b.field_73012_v) / 2.2, 0.0, -0.1, 0.0);
                        ++this.smeltingLevel;
                        if (generatesCorruption) {
                            ECUtils.increaseCorruptionAt(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e, this.field_145850_b.field_73012_v.nextInt(genCorruption));
                        }
                        if (this.smeltingLevel >= time && !this.field_145850_b.field_72995_K) {
                            this.func_70298_a(1, 1);
                            int suggestedStackSize = 2;
                            ItemStack is = this.func_70301_a(2);
                            is.field_77994_a += suggestedStackSize;
                            if (is.field_77994_a > is.func_77976_d()) {
                                is.field_77994_a = is.func_77976_d();
                            }
                            this.func_70299_a(2, is);
                            this.smeltingLevel = 0;
                            this.syncTick = 0;
                        }
                    }
                } else {
                    this.smeltingLevel = 0;
                }
            } else {
                this.smeltingLevel = 0;
            }
        }
    }

    public static void setupConfig(Configuration cfg) {
        try {
            cfg.load();
            String[] cfgArrayString = cfg.getStringList("FurnaceMagicSettings", "tileentities", new String[]{"Max MRU:5000.0", "MRU Usage:25", "Can this device actually generate corruption:false", "The amount of corruption generated each tick(do not set to 0!):3", "Ticks required to smelt:400"}, "");
            String dataString = "";
            for (int i = 0; i < cfgArrayString.length; ++i) {
                dataString = dataString + "||" + cfgArrayString[i];
            }
            DummyData[] data = DataStorage.parseData((String)dataString);
            mruUsage = Integer.parseInt(data[1].fieldValue);
            cfgMaxMRU = Float.parseFloat(data[0].fieldValue);
            generatesCorruption = Boolean.parseBoolean(data[2].fieldValue);
            genCorruption = Integer.parseInt(data[3].fieldValue);
            smeltingTime = Integer.parseInt(data[4].fieldValue);
            cfg.save();
        }
        catch (Exception e) {
            return;
        }
    }

    @Override
    public int[] getOutputSlots() {
        return new int[]{2};
    }

    @Override
    public int[] func_94128_d(int side) {
        if (side == 1) {
            return new int[]{0};
        }
        if (side == 0) {
            return this.getOutputSlots();
        }
        return new int[]{1};
    }
}

