/*
 * Decompiled with CFR 0.152.
 */
package ec3.common.tile;

import ec3.common.inventory.InventoryCraftingFrame;
import ec3.common.item.ItemCraftingFrame;
import ec3.common.tile.TileMRUGeneric;
import ec3.utils.common.ECUtils;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;

public class TileCrafter
extends TileMRUGeneric {
    public TileCrafter() {
        this.setMaxMRU(0.0f);
        this.setSlotsNum(11);
        this.slot0IsBoundGem = false;
    }

    @Override
    public int[] func_94128_d(int side) {
        return super.func_94128_d(side);
    }

    @Override
    public int func_70297_j_() {
        return 64;
    }

    @Override
    public int[] getOutputSlots() {
        return new int[]{9};
    }

    @Override
    public void func_145845_h() {
        if (this.field_145850_b.func_72864_z(this.field_145851_c, this.field_145848_d, this.field_145849_e) || this.field_145850_b.func_94577_B(this.field_145851_c, this.field_145848_d, this.field_145848_d) > 0) {
            if (!this.hasFrame()) {
                this.makeRecipe();
            } else if (this.hasSufficientForCraftWithFrame()) {
                this.makeRecipe();
            }
        }
    }

    @Override
    public boolean func_94041_b(int slot, ItemStack stack) {
        if (stack == null) {
            return false;
        }
        return slot == 10 ? this.isFrame(stack) : (slot == 9 ? false : this.isItemFineForSlot(stack, slot));
    }

    public boolean isFrame(ItemStack is) {
        return is != null && is.func_77973_b() instanceof ItemCraftingFrame && new InventoryCraftingFrame((ItemStack)is).inventory[9] != null;
    }

    public boolean isItemFineForSlot(ItemStack compared, int slotNum) {
        if (this.hasFrame()) {
            return this.areStacksTheSame(this.getRecipeFromFrame()[slotNum], compared, this.hasOreDict());
        }
        return true;
    }

    public boolean hasOreDict() {
        return this.func_70301_a(10) != null && this.func_70301_a(10).func_77973_b() instanceof ItemCraftingFrame && this.func_70301_a((int)10).field_77990_d != null && !this.func_70301_a((int)10).field_77990_d.func_74767_n("ignoreOreDict");
    }

    public boolean hasFrame() {
        return this.func_70301_a(10) != null && this.func_70301_a(10).func_77973_b() instanceof ItemCraftingFrame && new InventoryCraftingFrame((ItemStack)this.func_70301_a((int)10)).inventory[9] != null;
    }

    public boolean areStacksTheSame(ItemStack stk1, ItemStack stk2, boolean oreDict) {
        if (stk1 == null && stk2 == null) {
            return true;
        }
        if (stk1 == null || stk2 == null) {
            return false;
        }
        if (!oreDict) {
            if (!stk1.func_77969_a(stk2)) {
                return false;
            }
            if (!ItemStack.func_77989_b((ItemStack)stk1, (ItemStack)stk2)) {
                return false;
            }
        } else if (!ECUtils.oreDictionaryCompare(stk1, stk2)) {
            return false;
        }
        return true;
    }

    public boolean hasSufficientForCraftWithFrame() {
        ItemStack[] frame = this.getRecipeFromFrame();
        for (int i = 0; i < 9; ++i) {
            ItemStack stk = this.func_70301_a(i);
            if (this.areStacksTheSame(frame[i], stk, this.hasOreDict())) continue;
            return false;
        }
        return true;
    }

    public ItemStack[] getRecipeFromFrame() {
        if (this.func_70301_a(10) != null && this.func_70301_a(10).func_77973_b() instanceof ItemCraftingFrame) {
            InventoryCraftingFrame cInv = new InventoryCraftingFrame(this.func_70301_a(10));
            if (cInv.inventory[9] != null) {
                ItemStack[] arrayStk = new ItemStack[]{cInv.inventory[0], cInv.inventory[3], cInv.inventory[6], cInv.inventory[1], cInv.inventory[4], cInv.inventory[7], cInv.inventory[2], cInv.inventory[5], cInv.inventory[8]};
                return arrayStk;
            }
        }
        return null;
    }

    public void makeRecipe() {
        InventoryCraftingNoContainer craftingInv = new InventoryCraftingNoContainer(3, 3);
        for (int i = 0; i < 9; ++i) {
            craftingInv.func_70299_a(i, this.func_70301_a(i));
        }
        ItemStack result = CraftingManager.func_77594_a().func_82787_a((InventoryCrafting)craftingInv, this.field_145850_b);
        if (result != null) {
            if (this.func_70301_a(9) == null) {
                this.func_70299_a(9, result.func_77946_l());
                this.decreaseStacks();
            } else if (this.func_70301_a(9).func_77969_a(result) && ItemStack.func_77970_a((ItemStack)result, (ItemStack)this.func_70301_a(9)) && this.func_70301_a((int)9).field_77994_a + result.field_77994_a <= this.func_70297_j_() && this.func_70301_a((int)9).field_77994_a + result.field_77994_a <= result.func_77976_d()) {
                this.func_70301_a((int)9).field_77994_a += result.field_77994_a;
                this.decreaseStacks();
            }
        }
    }

    public void decreaseStacks() {
        for (int i = 0; i < 9; ++i) {
            ItemStack is = this.func_70301_a(i);
            if (is == null) continue;
            ItemStack container = is.func_77973_b().getContainerItem(is);
            this.func_70298_a(i, 1);
            if (this.func_70301_a(i) != null && this.func_70301_a((int)i).field_77994_a > 0 || container == null) continue;
            this.func_70299_a(i, container.func_77946_l());
        }
    }

    public static class InventoryCraftingNoContainer
    extends InventoryCrafting {
        private ItemStack[] stackList;
        private int inventoryWidth;

        public InventoryCraftingNoContainer(int p_i1807_2_, int p_i1807_3_) {
            super(null, p_i1807_2_, p_i1807_3_);
            int k = p_i1807_2_ * p_i1807_3_;
            this.stackList = new ItemStack[k];
            this.inventoryWidth = p_i1807_2_;
        }

        public int func_70302_i_() {
            return this.stackList.length;
        }

        public ItemStack func_70301_a(int p_70301_1_) {
            return p_70301_1_ >= this.func_70302_i_() ? null : this.stackList[p_70301_1_];
        }

        public ItemStack func_70463_b(int p_70463_1_, int p_70463_2_) {
            if (p_70463_1_ >= 0 && p_70463_1_ < this.inventoryWidth) {
                int k = p_70463_1_ + p_70463_2_ * this.inventoryWidth;
                return this.func_70301_a(k);
            }
            return null;
        }

        public ItemStack func_70304_b(int p_70304_1_) {
            if (this.stackList[p_70304_1_] != null) {
                ItemStack itemstack = this.stackList[p_70304_1_];
                this.stackList[p_70304_1_] = null;
                return itemstack;
            }
            return null;
        }

        public ItemStack func_70298_a(int p_70298_1_, int p_70298_2_) {
            if (this.stackList[p_70298_1_] != null) {
                if (this.stackList[p_70298_1_].field_77994_a <= p_70298_2_) {
                    ItemStack itemstack = this.stackList[p_70298_1_];
                    this.stackList[p_70298_1_] = null;
                    return itemstack;
                }
                ItemStack itemstack = this.stackList[p_70298_1_].func_77979_a(p_70298_2_);
                if (this.stackList[p_70298_1_].field_77994_a == 0) {
                    this.stackList[p_70298_1_] = null;
                }
                return itemstack;
            }
            return null;
        }

        public void func_70299_a(int p_70299_1_, ItemStack p_70299_2_) {
            this.stackList[p_70299_1_] = p_70299_2_;
        }
    }
}

