/*
 * Decompiled with CFR 0.152.
 */
package ec3.common.mod;

import DummyCore.Core.Core;
import DummyCore.Utils.IDummyConfig;
import cpw.mods.fml.common.IWorldGenerator;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.ModMetadata;
import cpw.mods.fml.common.SidedProxy;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLPostInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.event.FMLServerStartingEvent;
import cpw.mods.fml.common.network.simpleimpl.SimpleNetworkWrapper;
import cpw.mods.fml.common.registry.GameRegistry;
import ec3.common.block.BlocksCore;
import ec3.common.entity.EntitiesCore;
import ec3.common.item.ItemsCore;
import ec3.common.registry.AchievementRegistry;
import ec3.common.registry.BiomeRegistry;
import ec3.common.registry.BloodMagicRegistry;
import ec3.common.registry.CERegistry;
import ec3.common.registry.CoreRegistry;
import ec3.common.registry.DimensionRegistry;
import ec3.common.registry.EnchantRegistry;
import ec3.common.registry.GunInitialization;
import ec3.common.registry.PotionRegistry;
import ec3.common.registry.RecipeRegistry;
import ec3.common.registry.ResearchRegistry;
import ec3.common.registry.StructureRegistry;
import ec3.common.registry.VillagersRegistry;
import ec3.common.world.WorldGenManager;
import ec3.integration.rotarycraft.RCLoadingHandler;
import ec3.integration.versionChecker.Check;
import ec3.integration.waila.WailaInitialiser;
import ec3.network.proxy.CommonProxy;
import ec3.utils.cfg.Config;
import ec3.utils.common.CommandCreateMRUCU;
import ec3.utils.common.CommandSetBalance;
import ec3.utils.common.CommandSetMRU;
import java.util.Arrays;
import net.minecraft.command.CommandHandler;
import net.minecraft.command.ICommand;
import net.minecraft.server.MinecraftServer;

@Mod(modid="essentialcraft", name="EssentialCraftIII", version="4.6.1710.63", dependencies="required-after:DummyCore@[1.12,);", guiFactory="ec3.client.regular.ModConfigGuiHandler")
public class EssentialCraftCore {
    @Mod.Instance(value="essentialcraft")
    public static EssentialCraftCore core;
    @SidedProxy(clientSide="ec3.network.proxy.ClientProxy", serverSide="ec3.network.proxy.CommonProxy", modId="essentialcraft")
    public static CommonProxy proxy;
    public static Config cfg;
    public static final String version = "4.6.1710.63";
    public static final String modid = "essentialcraft";
    public static ModMetadata metadata;
    public static SimpleNetworkWrapper network;

    @Mod.EventHandler
    public void serverStart(FMLServerStartingEvent event) {
        MinecraftServer mcserver = event.getServer();
        ((CommandHandler)mcserver.func_71187_D()).func_71560_a((ICommand)new CommandSetMRU());
        ((CommandHandler)mcserver.func_71187_D()).func_71560_a((ICommand)new CommandSetBalance());
        ((CommandHandler)mcserver.func_71187_D()).func_71560_a((ICommand)new CommandCreateMRUCU());
    }

    @Mod.EventHandler
    public void beforeMinecraftLoaded(FMLPreInitializationEvent event) {
        metadata = event.getModMetadata();
        core = this;
        try {
            Core.registerModAbsolute(this.getClass(), (String)"Essential Craft 3", (String)event.getModConfigurationDirectory().getAbsolutePath(), (IDummyConfig)cfg);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        Check.checkerCommit();
        WailaInitialiser.sendIMC();
        RCLoadingHandler.runPreInitChecks();
    }

    @Mod.EventHandler
    public void onMinecraftLoading(FMLInitializationEvent event) {
        if (core == null) {
            core = this;
        }
        CoreRegistry.register();
        if (DimensionRegistry.core != null) {
            DimensionRegistry.core.registerDimensionMagic();
        } else {
            DimensionRegistry.core = new DimensionRegistry();
            DimensionRegistry.core.registerDimensionMagic();
        }
        if (BlocksCore.instance != null) {
            BlocksCore.instance.loadBlocks();
        } else {
            BlocksCore.instance = new BlocksCore();
            BlocksCore.instance.loadBlocks();
        }
        if (ItemsCore.instance != null) {
            ItemsCore.instance.loadItems();
        } else {
            ItemsCore.instance = new ItemsCore();
            ItemsCore.instance.loadItems();
        }
        if (RecipeRegistry.instance != null) {
            RecipeRegistry.instance.main();
        } else {
            RecipeRegistry.instance = new RecipeRegistry();
            RecipeRegistry.instance.main();
        }
        EnchantRegistry.register();
        if (VillagersRegistry.instance != null) {
            VillagersRegistry.instance.register();
        }
        if (BiomeRegistry.core != null) {
            BiomeRegistry.core.register();
        } else {
            BiomeRegistry.core = new BiomeRegistry();
            BiomeRegistry.core.register();
        }
        BlocksCore.postInitLoad();
        StructureRegistry.register();
        if (proxy != null) {
            proxy.registerRenderInformation();
            proxy.registerTileEntitySpecialRenderer();
        }
        GunInitialization.register();
        CERegistry.register();
    }

    public static boolean clazzExists(String clazzName) {
        try {
            Class<?> clazz = Class.forName(clazzName);
            return clazz != null;
        }
        catch (Exception e) {
            return false;
        }
    }

    @Mod.EventHandler
    public void onMinecraftLoadingFinished(FMLPostInitializationEvent event) {
        EntitiesCore.registerEntities();
        BloodMagicRegistry.register();
        AchievementRegistry.register();
        PotionRegistry.registerPotions();
        GameRegistry.registerWorldGenerator((IWorldGenerator)new WorldGenManager(), (int)16);
        cfg.postInitParseDecorativeBlocks();
        ResearchRegistry.init();
        EssentialCraftCore.metadata.autogenerated = false;
        EssentialCraftCore.metadata.modId = modid;
        EssentialCraftCore.metadata.version = version;
        EssentialCraftCore.metadata.name = "Essential Craft 3";
        EssentialCraftCore.metadata.credits = "Author: Modbder";
        EssentialCraftCore.metadata.authorList = Arrays.asList("Modbder");
        EssentialCraftCore.metadata.description = "Essential Craft 3 is a huge magic-themed mod, that adds lots of end-game content.";
        EssentialCraftCore.metadata.url = "http://www.minecraftforum.net/forums/mapping-and-modding/minecraft-mods/2286105-1-7-10-forge-open-source-dummythinking-mods";
        EssentialCraftCore.metadata.updateUrl = "http://www.minecraftforum.net/forums/mapping-and-modding/minecraft-mods/2286105-1-7-10-forge-open-source-dummythinking-mods";
        EssentialCraftCore.metadata.logoFile = "assets/essentialcraft/textures/special/logo.png";
    }

    static {
        cfg = new Config();
    }
}

