/*
 * Decompiled with CFR 0.152.
 */
package ec3.common.inventory;

import DummyCore.Utils.MiscUtils;
import java.util.UUID;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;

public class InventoryMagicFilter
implements IInventory {
    public ItemStack[] inventory = new ItemStack[9];
    public UUID randomUUID;
    public ItemStack filterStack;

    public InventoryMagicFilter(ItemStack filter) {
        if (!filter.func_77942_o()) {
            NBTTagCompound theTag = MiscUtils.getStackTag((ItemStack)filter);
            this.randomUUID = UUID.randomUUID();
            theTag.func_74778_a("uniqueID", this.randomUUID.toString());
        }
        this.readFromNBTTagCompound(MiscUtils.getStackTag((ItemStack)filter));
        this.filterStack = filter;
    }

    public int func_70302_i_() {
        return this.inventory.length;
    }

    public ItemStack func_70301_a(int slot) {
        return this.inventory[slot];
    }

    public ItemStack func_70298_a(int slot, int amount) {
        ItemStack returnStack;
        if (this.inventory[slot] == null) {
            return null;
        }
        if (this.inventory[slot].field_77994_a > amount) {
            returnStack = this.inventory[slot].func_77979_a(amount);
        } else {
            returnStack = this.inventory[slot];
            this.inventory[slot] = null;
        }
        this.func_70296_d();
        return returnStack;
    }

    public ItemStack func_70304_b(int slot) {
        ItemStack returnStack = this.func_70301_a(slot);
        this.func_70299_a(slot, null);
        return returnStack;
    }

    public void func_70299_a(int slot, ItemStack stack) {
        this.inventory[slot] = stack;
    }

    public String func_145825_b() {
        return "ec3.inventory.filter";
    }

    public boolean func_145818_k_() {
        return false;
    }

    public int func_70297_j_() {
        return 64;
    }

    public void func_70296_d() {
        for (int i = 0; i < this.inventory.length; ++i) {
            ItemStack tempStack = this.func_70301_a(i);
            if (tempStack == null || tempStack.field_77994_a != 0) continue;
            this.func_70299_a(i, null);
        }
    }

    public boolean func_70300_a(EntityPlayer p_70300_1_) {
        return true;
    }

    public void func_70295_k_() {
    }

    public void func_70305_f() {
    }

    public boolean func_94041_b(int slot, ItemStack stack) {
        return true;
    }

    public void readFromNBTTagCompound(NBTTagCompound tag) {
        NBTTagCompound inventoryTag = (NBTTagCompound)tag.func_74781_a("inventory");
        if (inventoryTag == null) {
            return;
        }
        if (this.randomUUID == null) {
            this.randomUUID = UUID.fromString(tag.func_74779_i("uniqueID"));
            if (this.randomUUID == null) {
                this.randomUUID = UUID.randomUUID();
            }
        }
        NBTTagList actualInventory = inventoryTag.func_150295_c("items", 10);
        for (int i = 0; i < actualInventory.func_74745_c() && i < this.inventory.length; ++i) {
            NBTTagCompound indexTag = actualInventory.func_150305_b(i);
            int index = indexTag.func_74762_e("index");
            try {
                this.inventory[index] = ItemStack.func_77949_a((NBTTagCompound)indexTag);
                continue;
            }
            catch (NullPointerException e) {
                this.inventory[index] = null;
            }
        }
    }

    public void writeToNBT(NBTTagCompound tag) {
        NBTTagList items = new NBTTagList();
        for (int i = 0; i < this.inventory.length; ++i) {
            if (this.inventory[i] == null || this.inventory[i].field_77994_a <= 0) continue;
            NBTTagCompound indexTag = new NBTTagCompound();
            items.func_74742_a((NBTBase)indexTag);
            indexTag.func_74768_a("index", i);
            this.inventory[i].func_77955_b(indexTag);
        }
        NBTTagCompound inventoryTag = new NBTTagCompound();
        inventoryTag.func_74782_a("items", (NBTBase)items);
        tag.func_74782_a("inventory", (NBTBase)inventoryTag);
        if (this.randomUUID == null) {
            this.randomUUID = UUID.randomUUID();
        }
        tag.func_74778_a("uniqueID", this.randomUUID.toString());
    }
}

