/*
 * Decompiled with CFR 0.152.
 */
package ec3.api;

import DummyCore.Utils.Coord3D;
import DummyCore.Utils.DummyDistance;
import ec3.api.CategoryEntry;
import ec3.api.DiscoveryEntry;
import ec3.api.EnumStructureType;
import ec3.api.IMRUPressence;
import ec3.api.IPlayerData;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.world.World;

public class ApiCore {
    public static final float GENERATOR_MAX_MRU_GENERIC = 10000.0f;
    public static final float DEVICE_MAX_MRU_GENERIC = 5000.0f;
    public static List<Item> allowsSeeingMRU = new ArrayList<Item>();
    public static Hashtable<Item, ArrayList<Float>> reductionsTable = new Hashtable();
    public static List<CategoryEntry> categories = new ArrayList<CategoryEntry>();
    public static Hashtable<String, DiscoveryEntry> discoveriesByIS = new Hashtable();

    public static IPlayerData getPlayerData(EntityPlayer p) {
        try {
            Class<?> ecUtilsClass = Class.forName("ec3.utils.common.ECUtils");
            Method getData = ecUtilsClass.getMethod("getData", EntityPlayer.class);
            return (IPlayerData)IPlayerData.class.cast(getData.invoke(null, p));
        }
        catch (Exception e) {
            return null;
        }
    }

    public static void registerBlockInAStructure(EnumStructureType structure, Block registered) {
        try {
            Class<?> ecUtilsClass = Class.forName("ec3.utils.common.ECUtils");
            Field hashTableFld = ecUtilsClass.getDeclaredField("allowedBlocks");
            hashTableFld.setAccessible(true);
            Hashtable hashMap = (Hashtable)hashTableFld.get(null);
            List allowedBlocksLst = (List)hashMap.get((Object)structure);
            allowedBlocksLst.add(registered);
            hashMap.put(structure, allowedBlocksLst);
            hashTableFld.set(null, hashMap);
        }
        catch (Exception e) {
            return;
        }
    }

    public static void registerBlockMRUResistance(Block registered, int metadata, float resistance) {
        try {
            Class<?> ecUtilsClass = Class.forName("ec3.utils.common.ECUtils");
            Method regBlk = ecUtilsClass.getMethod("registerBlockResistance", Block.class, Integer.TYPE, Float.TYPE);
            regBlk.setAccessible(true);
            regBlk.invoke(null, registered, metadata, Float.valueOf(resistance));
        }
        catch (Exception e) {
            return;
        }
    }

    public static DiscoveryEntry findDiscoveryByIS(ItemStack referal) {
        if (referal == null) {
            return null;
        }
        int size = referal.field_77994_a;
        referal.field_77994_a = 0;
        DiscoveryEntry de = discoveriesByIS.get(referal.toString());
        referal.field_77994_a = size;
        return de;
    }

    public static void allowItemToSeeMRU(Item i) {
        allowsSeeingMRU.add(i);
    }

    public static void setArmorProperties(Item item_0, float i, float j, float k) {
        ArrayList<Float> red = new ArrayList<Float>();
        red.add(Float.valueOf(i));
        red.add(Float.valueOf(j));
        red.add(Float.valueOf(k));
        reductionsTable.put(item_0, red);
    }

    public static boolean tryToDecreaseMRUInStorage(EntityPlayer player, int amount) {
        try {
            Class<?> ecUtilsClass = Class.forName("ec3.utils.common.ECUtils");
            Method tryToDecreaseMRUInStorage = ecUtilsClass.getMethod("tryToDecreaseMRUInStorage", EntityPlayer.class, Integer.TYPE);
            return Boolean.parseBoolean(tryToDecreaseMRUInStorage.invoke(null, player, -amount).toString());
        }
        catch (Exception e) {
            return false;
        }
    }

    public static void increaseCorruptionAt(World w, float x, float y, float z, int amount) {
        try {
            Class<?> ecUtilsClass = Class.forName("ec3.utils.common.ECUtils");
            Method increaseCorruptionAt = ecUtilsClass.getMethod("increaseCorruptionAt", World.class, Float.TYPE, Float.TYPE, Float.TYPE, Integer.TYPE);
            increaseCorruptionAt.setAccessible(true);
            increaseCorruptionAt.invoke(null, w, Float.valueOf(x), Float.valueOf(y), Float.valueOf(z), amount);
        }
        catch (Exception e) {
            return;
        }
    }

    public static IMRUPressence getClosestMRUCU(World w, Coord3D c, int radius) {
        List l = w.func_72872_a(IMRUPressence.class, AxisAlignedBB.func_72330_a((double)((double)c.x - 0.5), (double)((double)c.y - 0.5), (double)((double)c.z - 0.5), (double)((double)c.x + 0.5), (double)((double)c.y + 0.5), (double)((double)c.z + 0.5)).func_72314_b((double)radius, (double)(radius / 2), (double)radius));
        IMRUPressence ret = null;
        if (!l.isEmpty()) {
            if (!(l.get(0) instanceof IMRUPressence)) {
                ret = (IMRUPressence)l.get(0);
            } else {
                List actualList = l;
                double currentDistance = 0.0;
                double dominatingDistance = 0.0;
                int dominatingIndex = 0;
                Coord3D main = new Coord3D(c.x, c.y, c.z);
                for (int i = 0; i < actualList.size(); ++i) {
                    Entity pressence = (Entity)actualList.get(i);
                    Coord3D current = new Coord3D(pressence.field_70165_t, pressence.field_70163_u, pressence.field_70161_v);
                    DummyDistance dist = new DummyDistance(main, current);
                    if (i == 0) {
                        dominatingIndex = i;
                        dominatingDistance = dist.getDistance();
                        continue;
                    }
                    currentDistance = dist.getDistance();
                    if (!(currentDistance < dominatingDistance)) continue;
                    dominatingIndex = i;
                    dominatingDistance = dist.getDistance();
                }
                ret = (IMRUPressence)actualList.get(dominatingIndex);
            }
        }
        return ret;
    }
}

