/*
 * Decompiled with CFR 0.152.
 */
package com.jaquadro.minecraft.gardentrees.block;

import com.jaquadro.minecraft.gardencore.api.WoodRegistry;
import com.jaquadro.minecraft.gardencore.util.UniqueMetaIdentifier;
import com.jaquadro.minecraft.gardentrees.block.tile.TileEntityWoodProxy;
import com.jaquadro.minecraft.gardentrees.core.ClientProxy;
import com.jaquadro.minecraft.gardentrees.core.ModCreativeTabs;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.material.Material;
import net.minecraft.client.particle.EffectRenderer;
import net.minecraft.client.particle.EntityDiggingFX;
import net.minecraft.client.particle.EntityFX;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemLead;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.IIcon;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BlockThinLogFence
extends BlockContainer {
    public static final String[] subNames = new String[]{"oak", "spruce", "birch", "jungle", "acacia", "big_oak"};
    @SideOnly(value=Side.CLIENT)
    IIcon sideIcon;

    public BlockThinLogFence(String blockName) {
        super(Material.field_151575_d);
        this.func_149647_a(ModCreativeTabs.tabGardenTrees);
        this.func_149711_c(1.5f);
        this.func_149752_b(5.0f);
        this.func_149713_g(0);
        this.func_149672_a(Block.field_149766_f);
        this.func_149663_c(blockName);
        this.func_149683_g();
    }

    public float getMargin() {
        return 0.25f;
    }

    public void func_149683_g() {
        float margin = this.getMargin();
        this.func_149676_a(margin, 0.0f, margin, 1.0f - margin, 1.0f, 1.0f - margin);
    }

    public void func_149743_a(World world, int x, int y, int z, AxisAlignedBB mask, List list, Entity colliding) {
        float margin;
        boolean connectedZNeg = this.canConnectFenceTo((IBlockAccess)world, x, y, z - 1);
        boolean connectedZPos = this.canConnectFenceTo((IBlockAccess)world, x, y, z + 1);
        boolean connectedXNeg = this.canConnectFenceTo((IBlockAccess)world, x - 1, y, z);
        boolean connectedXPos = this.canConnectFenceTo((IBlockAccess)world, x + 1, y, z);
        float xs = margin = this.getMargin();
        float xe = 1.0f - margin;
        float zs = margin;
        float ze = 1.0f - margin;
        if (connectedZNeg) {
            zs = 0.0f;
        }
        if (connectedZPos) {
            ze = 1.0f;
        }
        if (connectedZNeg || connectedZPos) {
            this.func_149676_a(xs, 0.0f, zs, xe, 1.5f, ze);
            super.func_149743_a(world, x, y, z, mask, list, colliding);
        }
        zs = margin;
        ze = 1.0f - margin;
        if (connectedXNeg) {
            xs = 0.0f;
        }
        if (connectedXPos) {
            xe = 1.0f;
        }
        if (connectedXNeg || connectedXPos || !connectedZNeg && !connectedZPos) {
            this.func_149676_a(xs, 0.0f, zs, xe, 1.5f, ze);
            super.func_149743_a(world, x, y, z, mask, list, colliding);
        }
        if (connectedZNeg) {
            zs = 0.0f;
        }
        if (connectedZPos) {
            ze = 1.0f;
        }
        this.func_149676_a(xs, 0.0f, zs, xe, 1.0f, ze);
    }

    public void func_149719_a(IBlockAccess world, int x, int y, int z) {
        float margin;
        boolean connectedZNeg = this.canConnectFenceTo(world, x, y, z - 1);
        boolean connectedZPos = this.canConnectFenceTo(world, x, y, z + 1);
        boolean connectedXNeg = this.canConnectFenceTo(world, x - 1, y, z);
        boolean connectedXPos = this.canConnectFenceTo(world, x + 1, y, z);
        float xs = margin = this.getMargin();
        float xe = 1.0f - margin;
        float zs = margin;
        float ze = 1.0f - margin;
        if (connectedZNeg) {
            zs = 0.0f;
        }
        if (connectedZPos) {
            ze = 1.0f;
        }
        if (connectedXNeg) {
            xs = 0.0f;
        }
        if (connectedXPos) {
            xe = 1.0f;
        }
        this.func_149676_a(xs, 0.0f, zs, xe, 1.0f, ze);
    }

    public boolean func_149662_c() {
        return false;
    }

    public boolean func_149686_d() {
        return false;
    }

    public boolean func_149655_b(IBlockAccess world, int x, int y, int z) {
        return false;
    }

    public int func_149645_b() {
        return ClientProxy.thinLogFenceRenderID;
    }

    public boolean canPlaceTorchOnTop(World world, int x, int y, int z) {
        return true;
    }

    public boolean canConnectFenceTo(IBlockAccess world, int x, int y, int z) {
        Block block = world.func_147439_a(x, y, z);
        if (block != this) {
            return block.func_149688_o().func_76218_k() && block.func_149686_d() ? block.func_149688_o() != Material.field_151572_C : false;
        }
        return true;
    }

    public boolean func_149646_a(IBlockAccess world, int x, int y, int z, int side) {
        return true;
    }

    public boolean removedByPlayer(World world, EntityPlayer player, int x, int y, int z, boolean willHarvest) {
        if (willHarvest) {
            return true;
        }
        return super.removedByPlayer(world, player, x, y, z, willHarvest);
    }

    public void func_149636_a(World world, EntityPlayer player, int x, int y, int z, int meta) {
        super.func_149636_a(world, player, x, y, z, meta);
        world.func_147468_f(x, y, z);
    }

    public int func_149692_a(int meta) {
        return meta;
    }

    public ArrayList<ItemStack> getDrops(World world, int x, int y, int z, int metadata, int fortune) {
        TileEntityWoodProxy tile = this.getTileEntity((IBlockAccess)world, x, y, z);
        ArrayList<ItemStack> ret = new ArrayList<ItemStack>();
        int count = this.quantityDropped(metadata, fortune, world.field_73012_v);
        for (int i = 0; i < count; ++i) {
            Item item = this.func_149650_a(metadata, world.field_73012_v, fortune);
            if (item == null) continue;
            int damage = this.func_149692_a(metadata);
            if (tile != null && tile.getProtoBlock() != null) {
                damage = TileEntityWoodProxy.composeMetadata(tile.getProtoBlock(), tile.getProtoMeta());
            }
            ItemStack stack = new ItemStack(item, 1, damage);
            ret.add(stack);
        }
        return ret;
    }

    public IIcon func_149691_a(int side, int meta) {
        int protoMeta = TileEntityWoodProxy.getMetaFromComposedMetadata(meta);
        Block protoBlock = TileEntityWoodProxy.getBlockFromComposedMetadata(meta);
        if (protoBlock == null) {
            protoBlock = this.getIconSource(meta);
        }
        return protoBlock.func_149691_a(side, protoMeta);
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_149673_e(IBlockAccess blockAccess, int x, int y, int z, int side) {
        TileEntityWoodProxy te = this.getTileEntity(blockAccess, x, y, z);
        if (te == null || te.getProtoBlock() == null) {
            return super.func_149673_e(blockAccess, x, y, z, side);
        }
        int protoMeta = te.getProtoMeta();
        Block protoBlock = te.getProtoBlock();
        if (protoBlock == null) {
            protoBlock = Blocks.field_150364_r;
        }
        return protoBlock.func_149691_a(side, protoMeta);
    }

    private TileEntityWoodProxy getTileEntity(IBlockAccess blockAccess, int x, int y, int z) {
        TileEntity te = blockAccess.func_147438_o(x, y, z);
        if (te != null && te instanceof TileEntityWoodProxy) {
            return (TileEntityWoodProxy)te;
        }
        return null;
    }

    private BlockThinLogFence getBlock(IBlockAccess blockAccess, int x, int y, int z) {
        Block block = blockAccess.func_147439_a(x, y, z);
        if (block != null && block instanceof BlockThinLogFence) {
            return (BlockThinLogFence)block;
        }
        return null;
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon getSideIcon() {
        return this.sideIcon;
    }

    private Block getIconSource(int meta) {
        switch (meta / 4) {
            case 0: {
                return Blocks.field_150364_r;
            }
            case 1: {
                return Blocks.field_150363_s;
            }
        }
        return Blocks.field_150364_r;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean addHitEffects(World worldObj, MovingObjectPosition target, EffectRenderer effectRenderer) {
        TileEntityWoodProxy te = this.getTileEntity((IBlockAccess)worldObj, target.field_72311_b, target.field_72312_c, target.field_72309_d);
        BlockThinLogFence block = this.getBlock((IBlockAccess)worldObj, target.field_72311_b, target.field_72312_c, target.field_72309_d);
        if (te == null || block == null) {
            return false;
        }
        int protoMeta = te.getProtoMeta();
        Block protoBlock = te.getProtoBlock();
        if (protoBlock == null) {
            protoBlock = Blocks.field_150364_r;
            protoMeta = worldObj.func_72805_g(target.field_72311_b, target.field_72312_c, target.field_72309_d);
        }
        float f = 0.1f;
        double xPos = (double)target.field_72311_b + worldObj.field_73012_v.nextDouble() * (block.func_149753_y() - block.func_149704_x() - (double)(f * 2.0f)) + (double)f + block.func_149704_x();
        double yPos = (double)target.field_72312_c + worldObj.field_73012_v.nextDouble() * (block.func_149669_A() - block.func_149665_z() - (double)(f * 2.0f)) + (double)f + block.func_149665_z();
        double zPos = (double)target.field_72309_d + worldObj.field_73012_v.nextDouble() * (block.func_149693_C() - block.func_149706_B() - (double)(f * 2.0f)) + (double)f + block.func_149706_B();
        if (target.field_72310_e == 0) {
            yPos = (double)target.field_72312_c + block.func_149665_z() - (double)f;
        }
        if (target.field_72310_e == 1) {
            yPos = (double)target.field_72312_c + block.func_149669_A() + (double)f;
        }
        if (target.field_72310_e == 2) {
            zPos = (double)target.field_72309_d + block.func_149706_B() - (double)f;
        }
        if (target.field_72310_e == 3) {
            zPos = (double)target.field_72309_d + block.func_149693_C() + (double)f;
        }
        if (target.field_72310_e == 4) {
            xPos = (double)target.field_72311_b + block.func_149704_x() - (double)f;
        }
        if (target.field_72310_e == 5) {
            xPos = (double)target.field_72311_b + block.func_149753_y() + (double)f;
        }
        EntityDiggingFX fx = new EntityDiggingFX(worldObj, xPos, yPos, zPos, 0.0, 0.0, 0.0, (Block)block, worldObj.func_72805_g(target.field_72311_b, target.field_72312_c, target.field_72309_d));
        fx.func_70596_a(target.field_72311_b, target.field_72312_c, target.field_72309_d);
        fx.func_70543_e(0.2f).func_70541_f(0.6f);
        fx.func_110125_a(block.func_149691_a(worldObj.field_73012_v.nextInt(6), TileEntityWoodProxy.composeMetadata(protoBlock, protoMeta)));
        effectRenderer.func_78873_a((EntityFX)fx);
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean addDestroyEffects(World world, int x, int y, int z, int meta, EffectRenderer effectRenderer) {
        TileEntityWoodProxy te = this.getTileEntity((IBlockAccess)world, x, y, z);
        BlockThinLogFence block = this.getBlock((IBlockAccess)world, x, y, z);
        if (te == null || block == null) {
            return false;
        }
        int protoMeta = te.getProtoMeta();
        Block protoBlock = te.getProtoBlock();
        if (protoBlock == null) {
            protoBlock = Blocks.field_150364_r;
            protoMeta = world.func_72805_g(x, y, z);
        }
        try {
            int count = 4;
            for (int ix = 0; ix < count; ++ix) {
                for (int iy = 0; iy < count; ++iy) {
                    for (int iz = 0; iz < count; ++iz) {
                        double xOff = (double)x + ((double)ix + 0.5) / (double)count;
                        double yOff = (double)y + ((double)iy + 0.5) / (double)count;
                        double zOff = (double)z + ((double)iz + 0.5) / (double)count;
                        EntityDiggingFX fx = new EntityDiggingFX(world, xOff, yOff, zOff, xOff - (double)x - 0.5, yOff - (double)y - 0.5, zOff - (double)z - 0.5, (Block)this, meta);
                        fx.func_110125_a(block.func_149691_a(world.field_73012_v.nextInt(6), TileEntityWoodProxy.composeMetadata(protoBlock, protoMeta)));
                        effectRenderer.func_78873_a((EntityFX)fx.func_70596_a(x, y, z));
                    }
                }
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        return true;
    }

    public void func_149666_a(Item item, CreativeTabs creativeTabs, List blockList) {
        for (int i = 0; i < 6; ++i) {
            blockList.add(new ItemStack(item, 1, i));
        }
        for (Map.Entry<UniqueMetaIdentifier, Block> entry : WoodRegistry.instance().registeredTypes()) {
            if (entry.getValue() == Blocks.field_150364_r || entry.getValue() == Blocks.field_150363_s) continue;
            int id = TileEntityWoodProxy.composeMetadata(entry.getValue(), entry.getKey().meta);
            blockList.add(new ItemStack(item, 1, id));
        }
    }

    public void func_149651_a(IIconRegister iconRegister) {
        this.sideIcon = iconRegister.func_94245_a("GardenTrees:thinlog_fence_side");
    }

    public boolean func_149727_a(World world, int x, int y, int z, EntityPlayer player, int side, float vx, float vy, float vz) {
        return world.field_72995_K ? true : ItemLead.func_150909_a((EntityPlayer)player, (World)world, (int)x, (int)y, (int)z);
    }

    public TileEntity func_149915_a(World world, int meta) {
        return new TileEntityWoodProxy();
    }
}

