/*
 * Decompiled with CFR 0.152.
 */
package com.jaquadro.minecraft.gardenstuff.renderer;

import com.jaquadro.minecraft.gardenapi.api.GardenAPI;
import com.jaquadro.minecraft.gardenapi.api.connect.IAttachable;
import com.jaquadro.minecraft.gardencore.client.renderer.support.ModularBoxRenderer;
import com.jaquadro.minecraft.gardenstuff.block.BlockLattice;
import com.jaquadro.minecraft.gardenstuff.core.ClientProxy;
import cpw.mods.fml.client.registry.ISimpleBlockRenderingHandler;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.init.Blocks;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import org.lwjgl.opengl.GL11;

public class LatticeRenderer
implements ISimpleBlockRenderingHandler {
    private static final float UN4 = -0.25f;
    private static final float U7 = 0.4375f;
    private static final float U8 = 0.5f;
    private static final float U9 = 0.5625f;
    private static final float U20 = 1.25f;
    private ModularBoxRenderer boxRenderer = new ModularBoxRenderer();

    public void renderInventoryBlock(Block block, int metadata, int modelId, RenderBlocks renderer) {
        GL11.glRotatef((float)90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glScalef((float)1.5f, (float)1.5f, (float)1.5f);
        GL11.glTranslatef((float)-0.5f, (float)-0.5f, (float)-0.5f);
        this.boxRenderer.setUnit(0.0625);
        this.boxRenderer.setColor(ModularBoxRenderer.COLOR_WHITE);
        this.boxRenderer.setIcon(block.func_149691_a(0, metadata));
        this.boxRenderer.renderSolidBox(null, block, 0.0, 0.0, 0.0, 0.0, 0.4475, 0.4475, 1.0, 0.5525, 0.5525);
        this.boxRenderer.renderSolidBox(null, block, 0.0, 0.0, 0.0, 0.4475, 0.0, 0.4475, 0.5525, 1.0, 0.5525);
        GL11.glTranslatef((float)0.5f, (float)0.5f, (float)0.5f);
    }

    public boolean renderWorldBlock(IBlockAccess world, int x, int y, int z, Block block, int modelId, RenderBlocks renderer) {
        if (!(block instanceof BlockLattice)) {
            return false;
        }
        return this.renderWorldBlock(world, x, y, z, (BlockLattice)block, modelId, renderer);
    }

    public boolean renderWorldBlock(IBlockAccess world, int x, int y, int z, BlockLattice block, int modelId, RenderBlocks renderer) {
        float xMax;
        float xMin;
        float zMax;
        float zMin;
        IAttachable attachableYP;
        float yMin;
        Tessellator tessellator = Tessellator.field_78398_a;
        tessellator.func_78380_c(block.func_149677_c(world, x, y, z));
        this.boxRenderer.setUnit(0.0625);
        this.boxRenderer.setColor(ModularBoxRenderer.COLOR_WHITE);
        this.boxRenderer.setIcon(block.func_149673_e(world, x, y, z, 0));
        int connectFlags = block.calcConnectionFlags(world, x, y, z);
        boolean connectYNeg = (connectFlags & 1) != 0;
        boolean connectYPos = (connectFlags & 2) != 0;
        boolean connectZNeg = (connectFlags & 4) != 0;
        boolean connectZPos = (connectFlags & 8) != 0;
        boolean connectXNeg = (connectFlags & 0x10) != 0;
        boolean connectXPos = (connectFlags & 0x20) != 0;
        boolean extYNeg = (connectFlags & 0x40) != 0;
        boolean extYPos = (connectFlags & 0x80) != 0;
        boolean extZNeg = (connectFlags & 0x100) != 0;
        boolean extZPos = (connectFlags & 0x200) != 0;
        boolean extXNeg = (connectFlags & 0x400) != 0;
        boolean extXPos = (connectFlags & 0x800) != 0;
        this.boxRenderer.renderSolidBox(world, (Block)block, x, y, z, 0.4375, 0.4375, 0.4375, 0.5625, 0.5625, 0.5625);
        float f = extYNeg ? -0.25f : (yMin = connectYNeg ? 0.0f : 0.4375f);
        float yMax = extYPos ? 1.25f : (connectYPos ? 1.0f : 0.5625f);
        IAttachable attachableYN = GardenAPI.instance().registries().attachable().getAttachable(world.func_147439_a(x, y - 1, z), world.func_72805_g(x, y - 1, z));
        if (attachableYN != null) {
            yMin = (float)attachableYN.getAttachDepth(world, x, y - 1, z, 1) - 1.0f;
        }
        if ((attachableYP = GardenAPI.instance().registries().attachable().getAttachable(world.func_147439_a(x, y + 1, z), world.func_72805_g(x, y + 1, z))) != null) {
            yMax = (float)attachableYP.getAttachDepth(world, x, y + 1, z, 0) + 1.0f;
        }
        if (yMin < 0.4375f) {
            this.boxRenderer.renderSolidBox(world, (Block)block, x, y, z, 0.4375, yMin, 0.4375, 0.5625, 0.4375, 0.5625);
        }
        if (yMax > 0.5625f) {
            this.boxRenderer.renderSolidBox(world, (Block)block, x, y, z, 0.4375, 0.5625, 0.4375, 0.5625, yMax, 0.5625);
        }
        float f2 = extZNeg ? -0.25f : (zMin = connectZNeg ? 0.0f : 0.4375f);
        float f3 = extZPos ? 1.25f : (zMax = connectZPos ? 1.0f : 0.5625f);
        if (zMin < 0.4375f) {
            this.boxRenderer.renderSolidBox(world, (Block)block, x, y, z, 0.4375, 0.4375, zMin, 0.5625, 0.5625, 0.4375);
        }
        if (zMax > 0.5625f) {
            this.boxRenderer.renderSolidBox(world, (Block)block, x, y, z, 0.4375, 0.4375, 0.5625, 0.5625, 0.5625, zMax);
        }
        float f4 = extXNeg ? -0.25f : (xMin = connectXNeg ? 0.0f : 0.4375f);
        float f5 = extXPos ? 1.25f : (xMax = connectXPos ? 1.0f : 0.5625f);
        if (xMin < 0.4375f) {
            this.boxRenderer.renderSolidBox(world, (Block)block, x, y, z, xMin, 0.4375, 0.4375, 0.4375, 0.5625, 0.5625);
        }
        if (xMax > 0.5625f) {
            this.boxRenderer.renderSolidBox(world, (Block)block, x, y, z, 0.5625, 0.4375, 0.4375, xMax, 0.5625, 0.5625);
        }
        IIcon vineIcon = Blocks.field_150395_bd.func_149691_a(0, 0);
        return true;
    }

    public boolean shouldRender3DInInventory(int modelId) {
        return true;
    }

    public int getRenderId() {
        return ClientProxy.latticeRenderID;
    }
}

