/*
 * Decompiled with CFR 0.152.
 */
package com.jaquadro.minecraft.gardenstuff.block;

import com.jaquadro.minecraft.gardenapi.api.GardenAPI;
import com.jaquadro.minecraft.gardenapi.api.connect.IAttachable;
import com.jaquadro.minecraft.gardenapi.api.connect.IChainSingleAttachable;
import com.jaquadro.minecraft.gardencore.core.ModCreativeTabs;
import com.jaquadro.minecraft.gardenstuff.block.BlockFence;
import com.jaquadro.minecraft.gardenstuff.block.tile.TileEntityLattice;
import com.jaquadro.minecraft.gardenstuff.core.ClientProxy;
import com.jaquadro.minecraft.gardentrees.block.BlockThinLog;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.Vec3;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public abstract class BlockLattice
extends BlockContainer
implements IChainSingleAttachable {
    private static final float UN4 = -0.25f;
    private static final float U7 = 0.4375f;
    private static final float U8 = 0.5f;
    private static final float U9 = 0.5625f;
    private static final float U20 = 1.25f;
    private final Vec3[] attachPoints = new Vec3[]{Vec3.func_72443_a((double)0.5, (double)0.5, (double)0.5), Vec3.func_72443_a((double)0.5, (double)0.5, (double)0.5), Vec3.func_72443_a((double)0.5, (double)0.5, (double)0.5), Vec3.func_72443_a((double)0.5, (double)0.5, (double)0.5), Vec3.func_72443_a((double)0.5, (double)0.5, (double)0.5), Vec3.func_72443_a((double)0.5, (double)0.5, (double)0.5)};

    public BlockLattice(String blockName, Material material) {
        super(material);
        this.func_149663_c(blockName);
        this.func_149711_c(2.5f);
        this.func_149752_b(5.0f);
        this.func_149658_d("GardenStuff:lattice_iron");
        this.func_149647_a(ModCreativeTabs.tabGardenCore);
        this.func_149683_g();
    }

    public boolean func_149662_c() {
        return false;
    }

    public boolean func_149686_d() {
        return false;
    }

    public int func_149645_b() {
        return ClientProxy.latticeRenderID;
    }

    public int func_149692_a(int meta) {
        return meta;
    }

    public void func_149719_a(IBlockAccess world, int x, int y, int z) {
        int connectFlags = this.calcConnectionFlags(world, x, y, z);
        float margin = 0.375f;
        float ys = (connectFlags & 1) != 0 ? 0.0f : margin;
        float ye = (connectFlags & 2) != 0 ? 1.0f : 1.0f - margin;
        float zs = (connectFlags & 4) != 0 ? 0.0f : margin;
        float ze = (connectFlags & 8) != 0 ? 1.0f : 1.0f - margin;
        float xs = (connectFlags & 0x10) != 0 ? 0.0f : margin;
        float xe = (connectFlags & 0x20) != 0 ? 1.0f : 1.0f - margin;
        this.func_149676_a(xs, ys, zs, xe, ye, ze);
    }

    public void func_149743_a(World world, int x, int y, int z, AxisAlignedBB mask, List list, Entity colliding) {
        float xMin;
        float zMax;
        float zMin;
        IAttachable attachableYP;
        float yMin;
        boolean extXPos;
        int connectFlags = this.calcConnectionFlags((IBlockAccess)world, x, y, z);
        boolean connectYNeg = (connectFlags & 1) != 0;
        boolean connectYPos = (connectFlags & 2) != 0;
        boolean connectZNeg = (connectFlags & 4) != 0;
        boolean connectZPos = (connectFlags & 8) != 0;
        boolean connectXNeg = (connectFlags & 0x10) != 0;
        boolean connectXPos = (connectFlags & 0x20) != 0;
        boolean extYNeg = (connectFlags & 0x40) != 0;
        boolean extYPos = (connectFlags & 0x80) != 0;
        boolean extZNeg = (connectFlags & 0x100) != 0;
        boolean extZPos = (connectFlags & 0x200) != 0;
        boolean extXNeg = (connectFlags & 0x400) != 0;
        boolean bl = extXPos = (connectFlags & 0x800) != 0;
        float f = extYNeg ? -0.25f : (yMin = connectYNeg ? 0.0f : 0.4375f);
        float yMax = extYPos ? 1.25f : (connectYPos ? 1.0f : 0.5625f);
        IAttachable attachableYN = GardenAPI.instance().registries().attachable().getAttachable(world.func_147439_a(x, y - 1, z), world.func_72805_g(x, y - 1, z));
        if (attachableYN != null) {
            yMin = (float)attachableYN.getAttachDepth((IBlockAccess)world, x, y - 1, z, 1) - 1.0f;
        }
        if ((attachableYP = GardenAPI.instance().registries().attachable().getAttachable(world.func_147439_a(x, y + 1, z), world.func_72805_g(x, y + 1, z))) != null) {
            yMax = (float)attachableYP.getAttachDepth((IBlockAccess)world, x, y + 1, z, 0) + 1.0f;
        }
        float f2 = extZNeg ? -0.25f : (zMin = connectZNeg ? 0.0f : 0.4375f);
        float f3 = extZPos ? 1.25f : (zMax = connectZPos ? 1.0f : 0.5625f);
        float f4 = extXNeg ? -0.25f : (xMin = connectXNeg ? 0.0f : 0.4375f);
        float xMax = extXPos ? 1.25f : (connectXPos ? 1.0f : 0.5625f);
        this.func_149676_a(0.4375f, yMin, 0.4375f, 0.5625f, yMax, 0.5625f);
        super.func_149743_a(world, x, y, z, mask, list, colliding);
        this.func_149676_a(xMin, 0.4375f, 0.4375f, xMax, 0.5625f, 0.5625f);
        super.func_149743_a(world, x, y, z, mask, list, colliding);
        this.func_149676_a(0.4375f, 0.4375f, zMin, 0.5625f, 0.5625f, zMax);
        super.func_149743_a(world, x, y, z, mask, list, colliding);
        this.func_149719_a((IBlockAccess)world, x, y, z);
    }

    public ArrayList<ItemStack> getDrops(World world, int x, int y, int z, int metadata, int fortune) {
        ArrayList<ItemStack> ret = new ArrayList<ItemStack>();
        int count = this.quantityDropped(metadata, fortune, world.field_73012_v);
        for (int i = 0; i < count; ++i) {
            Item item = this.func_149650_a(metadata, world.field_73012_v, fortune);
            if (item == null) continue;
            ret.add(new ItemStack(item, 1, this.func_149692_a(metadata)));
        }
        return ret;
    }

    public int calcConnectionFlags(IBlockAccess world, int x, int y, int z) {
        Block blockYNeg = world.func_147439_a(x, y - 1, z);
        Block blockYPos = world.func_147439_a(x, y + 1, z);
        Block blockZNeg = world.func_147439_a(x, y, z - 1);
        Block blockZPos = world.func_147439_a(x, y, z + 1);
        Block blockXNeg = world.func_147439_a(x - 1, y, z);
        Block blockXPos = world.func_147439_a(x + 1, y, z);
        boolean hardYNeg = this.isNeighborHardConnection(world, x, y - 1, z, blockYNeg, ForgeDirection.DOWN);
        boolean hardYPos = this.isNeighborHardConnection(world, x, y + 1, z, blockYPos, ForgeDirection.UP);
        boolean hardZNeg = this.isNeighborHardConnection(world, x, y, z - 1, blockZNeg, ForgeDirection.NORTH);
        boolean hardZPos = this.isNeighborHardConnection(world, x, y, z + 1, blockZPos, ForgeDirection.SOUTH);
        boolean hardXNeg = this.isNeighborHardConnection(world, x - 1, y, z, blockXNeg, ForgeDirection.WEST);
        boolean hardXPos = this.isNeighborHardConnection(world, x + 1, y, z, blockXPos, ForgeDirection.EAST);
        boolean extYNeg = this.isNeighborExtConnection(world, x, y - 1, z, blockYNeg, ForgeDirection.DOWN);
        boolean extYPos = this.isNeighborExtConnection(world, x, y + 1, z, blockYPos, ForgeDirection.UP);
        boolean extZNeg = this.isNeighborExtConnection(world, x, y, z - 1, blockZNeg, ForgeDirection.NORTH);
        boolean extZPos = this.isNeighborExtConnection(world, x, y, z + 1, blockZPos, ForgeDirection.SOUTH);
        boolean extXNeg = this.isNeighborExtConnection(world, x - 1, y, z, blockXNeg, ForgeDirection.WEST);
        boolean extXPos = this.isNeighborExtConnection(world, x + 1, y, z, blockXPos, ForgeDirection.EAST);
        return (hardYNeg ? 1 : 0) | (hardYPos ? 2 : 0) | (hardZNeg ? 4 : 0) | (hardZPos ? 8 : 0) | (hardXNeg ? 16 : 0) | (hardXPos ? 32 : 0) | (extYNeg ? 64 : 0) | (extYPos ? 128 : 0) | (extZNeg ? 256 : 0) | (extZPos ? 512 : 0) | (extXNeg ? 1024 : 0) | (extXPos ? 2048 : 0);
    }

    private boolean isNeighborHardConnection(IBlockAccess world, int x, int y, int z, Block block, ForgeDirection side) {
        if (block.func_149688_o().func_76218_k() && block.func_149686_d()) {
            return true;
        }
        if (block.isSideSolid(world, x, y, z, side.getOpposite())) {
            return true;
        }
        if (block == this) {
            return true;
        }
        return !(side != ForgeDirection.DOWN && side != ForgeDirection.UP || !(block instanceof BlockFence) && !(block instanceof net.minecraft.block.BlockFence));
    }

    private boolean isNeighborExtConnection(IBlockAccess world, int x, int y, int z, Block block, ForgeDirection side) {
        return block instanceof BlockThinLog;
    }

    protected TileEntityLattice getTileEntity(IBlockAccess blockAccess, int x, int y, int z) {
        TileEntity te = blockAccess.func_147438_o(x, y, z);
        if (te != null && te instanceof TileEntityLattice) {
            return (TileEntityLattice)te;
        }
        return null;
    }

    @Override
    public Vec3 getChainAttachPoint(IBlockAccess blockAccess, int x, int y, int z, int side) {
        int connectFlags = this.calcConnectionFlags(blockAccess, x, y, z);
        switch (side) {
            case 0: {
                return (connectFlags & 1) == 0 ? this.attachPoints[0] : null;
            }
            case 1: {
                return (connectFlags & 2) == 0 ? this.attachPoints[1] : null;
            }
            case 2: {
                return (connectFlags & 4) == 0 ? this.attachPoints[2] : null;
            }
            case 3: {
                return (connectFlags & 8) == 0 ? this.attachPoints[3] : null;
            }
            case 4: {
                return (connectFlags & 0x10) == 0 ? this.attachPoints[4] : null;
            }
            case 5: {
                return (connectFlags & 0x20) == 0 ? this.attachPoints[5] : null;
            }
        }
        return null;
    }
}

