/*
 * Decompiled with CFR 0.152.
 */
package com.jaquadro.minecraft.gardenstuff.block;

import com.jaquadro.minecraft.gardenapi.api.component.ILanternSource;
import com.jaquadro.minecraft.gardenapi.api.component.IRedstoneSource;
import com.jaquadro.minecraft.gardenapi.internal.Api;
import com.jaquadro.minecraft.gardencore.core.ModCreativeTabs;
import com.jaquadro.minecraft.gardencore.util.BindingStack;
import com.jaquadro.minecraft.gardenstuff.block.tile.TileEntityLantern;
import com.jaquadro.minecraft.gardenstuff.core.ClientProxy;
import com.jaquadro.minecraft.gardenstuff.integration.ColoredLightsIntegration;
import com.jaquadro.minecraft.gardenstuff.item.ItemLantern;
import cpw.mods.fml.common.Optional;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import thaumcraft.api.crafting.IInfusionStabiliser;

@Optional.Interface(iface="thaumcraft.api.crafting.IInfusionStabiliser", modid="Thaumcraft", striprefs=true)
public class BlockLantern
extends BlockContainer
implements IInfusionStabiliser {
    @SideOnly(value=Side.CLIENT)
    private IIcon iconBottom;
    @SideOnly(value=Side.CLIENT)
    private IIcon iconSide;
    @SideOnly(value=Side.CLIENT)
    private IIcon iconTop;
    @SideOnly(value=Side.CLIENT)
    private IIcon iconTopCross;
    @SideOnly(value=Side.CLIENT)
    private IIcon iconGlass;
    @SideOnly(value=Side.CLIENT)
    private IIcon iconCandle;
    public BindingStack binding = new BindingStack();

    public BlockLantern(String blockName) {
        super(Material.field_151573_f);
        this.func_149663_c(blockName);
        this.func_149675_a(true);
        this.func_149711_c(2.5f);
        this.func_149752_b(5.0f);
        this.func_149715_a(1.0f);
        this.func_149658_d("GardenStuff:lantern");
        this.func_149647_a(ModCreativeTabs.tabGardenCore);
        this.func_149683_g();
    }

    public boolean isGlass(ItemStack item) {
        NBTTagCompound tag;
        if (item.func_77942_o() && (tag = item.func_77978_p()).func_74764_b("glass")) {
            return tag.func_74767_n("glass");
        }
        return false;
    }

    public String getLightSource(ItemStack item) {
        NBTTagCompound tag;
        if (item.func_77942_o() && (tag = item.func_77978_p()).func_150297_b("src", 8)) {
            return tag.func_74779_i("src");
        }
        return null;
    }

    public int getLightSourceMeta(ItemStack item) {
        NBTTagCompound tag;
        if (item.func_77942_o() && (tag = item.func_77978_p()).func_74764_b("srcMeta")) {
            return tag.func_74765_d("srcMeta");
        }
        return 0;
    }

    public String func_149702_O() {
        return "GardenStuff:lantern";
    }

    public boolean func_149662_c() {
        return false;
    }

    public boolean func_149686_d() {
        return false;
    }

    public int func_149645_b() {
        return ClientProxy.lanternRenderID;
    }

    public int func_149701_w() {
        return 1;
    }

    public boolean canRenderInPass(int pass) {
        ClientProxy.lanternRenderer.renderPass = pass;
        return true;
    }

    public void func_149719_a(IBlockAccess world, int x, int y, int z) {
        this.func_149683_g();
    }

    public void func_149683_g() {
        this.func_149676_a(0.125f, 0.0f, 0.125f, 0.875f, 0.875f, 0.875f);
    }

    public void func_149743_a(World world, int x, int y, int z, AxisAlignedBB mask, List list, Entity colliding) {
        this.func_149719_a((IBlockAccess)world, x, y, z);
        super.func_149743_a(world, x, y, z, mask, list, colliding);
    }

    public boolean func_149646_a(IBlockAccess world, int x, int y, int z, int side) {
        return true;
    }

    public int func_149692_a(int meta) {
        return meta;
    }

    public boolean removedByPlayer(World world, EntityPlayer player, int x, int y, int z, boolean willHarvest) {
        if (willHarvest) {
            return true;
        }
        return super.removedByPlayer(world, player, x, y, z, willHarvest);
    }

    public void func_149636_a(World world, EntityPlayer player, int x, int y, int z, int meta) {
        super.func_149636_a(world, player, x, y, z, meta);
        world.func_147468_f(x, y, z);
    }

    public ArrayList<ItemStack> getDrops(World world, int x, int y, int z, int metadata, int fortune) {
        TileEntityLantern tile = this.getTileEntity((IBlockAccess)world, x, y, z);
        ArrayList<ItemStack> ret = new ArrayList<ItemStack>();
        int count = this.quantityDropped(metadata, fortune, world.field_73012_v);
        for (int i = 0; i < count; ++i) {
            Item item = this.func_149650_a(metadata, world.field_73012_v, fortune);
            if (item == null) continue;
            boolean glass = false;
            String source = null;
            int sourceMeta = 0;
            if (tile != null) {
                glass = tile.hasGlass();
                source = tile.getLightSource();
                sourceMeta = tile.getLightSourceMeta();
            }
            ItemStack stack = ((ItemLantern)Item.func_150898_a((Block)this)).makeItemStack(1, metadata, glass, source, sourceMeta);
            ret.add(stack);
        }
        return ret;
    }

    public boolean func_149727_a(World world, int x, int y, int z, EntityPlayer player, int side, float hitX, float hitY, float hitZ) {
        TileEntityLantern tile = this.getTileEntity((IBlockAccess)world, x, y, z);
        if (tile == null) {
            return false;
        }
        ItemStack item = player.field_71071_by.func_70448_g();
        if (item == null && player.func_70093_af() && tile.getLightSource() != null) {
            ILanternSource lanternSource = Api.instance.registries().lanternSources().getLanternSource(tile.getLightSource());
            if (lanternSource != null) {
                this.func_149642_a(world, x, y, z, lanternSource.getRemovedItem(tile.getLightSourceMeta()));
            }
            tile.setLightSource(null);
            world.func_147471_g(x, y, z);
            world.func_147459_d(x, y, z, (Block)this);
            world.func_147459_d(x, y - 1, z, (Block)this);
            tile.func_70296_d();
            return true;
        }
        if (tile.getLightSource() == null && item != null) {
            for (ILanternSource lanternSource : Api.instance.registries.lanternSources.getAllLanternSources()) {
                if (!lanternSource.isValidSourceItem(item)) continue;
                tile.setLightSource(lanternSource.getSourceID());
                tile.setLightSourceMeta(lanternSource.getSourceMeta(item));
                if (player != null && !player.field_71075_bZ.field_75098_d && --item.field_77994_a <= 0) {
                    player.field_71071_by.func_70299_a(player.field_71071_by.field_70461_c, null);
                }
                world.func_147471_g(x, y, z);
                world.func_147459_d(x, y, z, (Block)this);
                world.func_147459_d(x, y - 1, z, (Block)this);
                tile.func_70296_d();
                return true;
            }
        }
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149734_b(World world, int x, int y, int z, Random rand) {
        TileEntityLantern tile = this.getTileEntity((IBlockAccess)world, x, y, z);
        if (tile == null) {
            return;
        }
        ILanternSource lanternSource = Api.instance.registries.lanternSources.getLanternSource(tile.getLightSource());
        if (lanternSource != null) {
            lanternSource.renderParticle(world, x, y, z, rand, tile.getLightSourceMeta());
        }
    }

    public boolean canHarvestBlock(EntityPlayer player, int meta) {
        return true;
    }

    public void func_149749_a(World world, int x, int y, int z, Block block, int data) {
        if (this.getRedstoneSource((IBlockAccess)world, x, y, z) != null) {
            world.func_147459_d(x, y, z, (Block)this);
            world.func_147459_d(x, y - 1, z, (Block)this);
        }
        super.func_149749_a(world, x, y, z, block, data);
    }

    public void func_149666_a(Item item, CreativeTabs tab, List list) {
        list.add(new ItemStack(item, 1, 0));
        NBTTagCompound glassTag = new NBTTagCompound();
        glassTag.func_74757_a("glass", true);
        for (int i = 0; i < 16; ++i) {
            ItemStack entry = new ItemStack(item, 1, i);
            entry.func_77982_d(glassTag);
            list.add(entry);
        }
    }

    public int getLightValue(IBlockAccess world, int x, int y, int z) {
        TileEntityLantern tile = this.getTileEntity(world, x, y, z);
        if (tile == null) {
            return 0;
        }
        if (tile.hasGlass() && ColoredLightsIntegration.isInitialized()) {
            return ColoredLightsIntegration.getPackedColor(world.func_72805_g(x, y, z));
        }
        ILanternSource lanternSource = Api.instance.registries.lanternSources.getLanternSource(tile.getLightSource());
        if (lanternSource != null) {
            return lanternSource.getLightLevel(tile.getLightSourceMeta());
        }
        return 0;
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_149691_a(int side, int meta) {
        if (side == 0) {
            return this.iconBottom;
        }
        if (side == 1) {
            return this.iconTop;
        }
        return this.iconSide;
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon getIconCandle() {
        return this.iconCandle;
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon getIconTopCross() {
        return this.iconTopCross;
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon getIconGlass(int meta) {
        return this.iconGlass;
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon getIconStainedGlass(int meta) {
        return Blocks.field_150397_co.func_149691_a(0, meta);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister register) {
        this.iconBottom = register.func_94245_a(this.func_149641_N() + "_bottom");
        this.iconSide = register.func_94245_a(this.func_149641_N());
        this.iconGlass = register.func_94245_a(this.func_149641_N() + "_glass");
        this.iconTop = register.func_94245_a(this.func_149641_N() + "_top");
        this.iconTopCross = register.func_94245_a(this.func_149641_N() + "_top_cross");
        this.iconCandle = register.func_94245_a("GardenStuff:candle");
    }

    public TileEntity func_149915_a(World world, int meta) {
        return new TileEntityLantern();
    }

    public int func_149748_c(IBlockAccess world, int x, int y, int z, int side) {
        IRedstoneSource source = this.getRedstoneSource(world, x, y, z);
        return side == 1 && source != null ? source.strongPowerValue(this.getTileEntity(world, x, y, z).getLightSourceMeta()) : 0;
    }

    public int func_149709_b(IBlockAccess world, int x, int y, int z, int side) {
        IRedstoneSource source = this.getRedstoneSource(world, x, y, z);
        return source != null ? source.weakPowerValue(this.getTileEntity(world, x, y, z).getLightSourceMeta()) : 0;
    }

    public boolean func_149744_f() {
        return true;
    }

    private IRedstoneSource getRedstoneSource(IBlockAccess world, int x, int y, int z) {
        ILanternSource source;
        TileEntityLantern tile = this.getTileEntity(world, x, y, z);
        if (tile != null && (source = Api.instance.registries.lanternSources.getLanternSource(tile.getLightSource())) instanceof IRedstoneSource) {
            return (IRedstoneSource)((Object)source);
        }
        return null;
    }

    public TileEntityLantern getTileEntity(IBlockAccess world, int x, int y, int z) {
        TileEntity te = world.func_147438_o(x, y, z);
        return te != null && te instanceof TileEntityLantern ? (TileEntityLantern)te : null;
    }

    @Optional.Method(modid="Thaumcraft")
    public boolean canStabaliseInfusion(World world, int x, int y, int z) {
        TileEntityLantern tile = this.getTileEntity((IBlockAccess)world, x, y, z);
        if (tile == null) {
            return false;
        }
        ILanternSource lanternSource = Api.instance.registries().lanternSources().getLanternSource(tile.getLightSource());
        if (lanternSource == null) {
            return false;
        }
        return lanternSource.getSourceID().equals("thaumcraftCandle");
    }
}

