/*
 * Decompiled with CFR 0.152.
 */
package com.jaquadro.minecraft.gardencontainers.core;

import com.jaquadro.minecraft.gardencontainers.block.BlockDecorativePot;
import com.jaquadro.minecraft.gardencontainers.block.BlockLargePot;
import com.jaquadro.minecraft.gardencontainers.block.BlockLargePotColored;
import com.jaquadro.minecraft.gardencontainers.block.BlockLargePotStandard;
import com.jaquadro.minecraft.gardencontainers.block.BlockMediumPot;
import com.jaquadro.minecraft.gardencontainers.block.BlockMediumPotColored;
import com.jaquadro.minecraft.gardencontainers.block.BlockMediumPotStandard;
import com.jaquadro.minecraft.gardencontainers.block.BlockPotteryTable;
import com.jaquadro.minecraft.gardencontainers.block.BlockWindowBox;
import com.jaquadro.minecraft.gardencontainers.block.BlockWindowBoxStone;
import com.jaquadro.minecraft.gardencontainers.block.tile.TileEntityDecorativePot;
import com.jaquadro.minecraft.gardencontainers.block.tile.TileEntityLargePot;
import com.jaquadro.minecraft.gardencontainers.block.tile.TileEntityMediumPot;
import com.jaquadro.minecraft.gardencontainers.block.tile.TileEntityPotteryTable;
import com.jaquadro.minecraft.gardencontainers.block.tile.TileEntityWindowBox;
import com.jaquadro.minecraft.gardencontainers.item.ItemDecorativePot;
import com.jaquadro.minecraft.gardencontainers.item.ItemLargePot;
import com.jaquadro.minecraft.gardencontainers.item.ItemMediumPot;
import com.jaquadro.minecraft.gardencontainers.item.ItemWindowBox;
import com.jaquadro.minecraft.gardencore.util.UniqueMetaIdentifier;
import cpw.mods.fml.common.FMLLog;
import cpw.mods.fml.common.registry.GameData;
import cpw.mods.fml.common.registry.GameRegistry;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import org.apache.logging.log4j.Level;

public class ModBlocks {
    public static BlockWindowBox woodWindowBox;
    public static BlockWindowBoxStone stoneWindowBox;
    public static BlockDecorativePot decorativePot;
    public static BlockLargePot largePot;
    public static BlockLargePot largePotColored;
    public static BlockMediumPot mediumPot;
    public static BlockMediumPot mediumPotColored;
    public static BlockPotteryTable potteryTable;

    public void init() {
        woodWindowBox = new BlockWindowBox(ModBlocks.makeName("woodWindowBox"), Material.field_151575_d);
        stoneWindowBox = new BlockWindowBoxStone(ModBlocks.makeName("stoneWindowBox"));
        decorativePot = new BlockDecorativePot(ModBlocks.makeName("decorativePot"));
        largePot = new BlockLargePotStandard(ModBlocks.makeName("largePot"));
        largePotColored = new BlockLargePotColored(ModBlocks.makeName("largePotColored"));
        mediumPot = new BlockMediumPotStandard(ModBlocks.makeName("mediumPot"));
        mediumPotColored = new BlockMediumPotColored(ModBlocks.makeName("mediumPotColored"));
        potteryTable = new BlockPotteryTable(ModBlocks.makeName("potteryTable"));
        GameRegistry.registerBlock((Block)woodWindowBox, ItemWindowBox.class, (String)"wood_window_box");
        GameRegistry.registerBlock((Block)stoneWindowBox, ItemWindowBox.class, (String)"stone_window_box");
        GameRegistry.registerBlock((Block)decorativePot, ItemDecorativePot.class, (String)"decorative_pot");
        GameRegistry.registerBlock((Block)largePot, ItemLargePot.class, (String)"large_pot");
        GameRegistry.registerBlock((Block)largePotColored, ItemLargePot.class, (String)"large_pot_colored");
        GameRegistry.registerBlock((Block)mediumPot, ItemMediumPot.class, (String)"medium_pot");
        GameRegistry.registerBlock((Block)mediumPotColored, ItemMediumPot.class, (String)"medium_pot_colored");
        GameRegistry.registerBlock((Block)potteryTable, (String)"pottery_table");
        GameRegistry.registerTileEntity(TileEntityWindowBox.class, (String)ModBlocks.getQualifiedName((Block)woodWindowBox));
        GameRegistry.registerTileEntity(TileEntityDecorativePot.class, (String)ModBlocks.getQualifiedName((Block)decorativePot));
        GameRegistry.registerTileEntity(TileEntityLargePot.class, (String)ModBlocks.getQualifiedName((Block)largePot));
        GameRegistry.registerTileEntity(TileEntityLargePot.class, (String)ModBlocks.getQualifiedName((Block)largePotColored));
        GameRegistry.registerTileEntity(TileEntityMediumPot.class, (String)ModBlocks.getQualifiedName((Block)mediumPot));
        GameRegistry.registerTileEntity(TileEntityMediumPot.class, (String)ModBlocks.getQualifiedName((Block)mediumPotColored));
        GameRegistry.registerTileEntity(TileEntityPotteryTable.class, (String)ModBlocks.getQualifiedName((Block)potteryTable));
    }

    public static String makeName(String name) {
        return "GardenContainers".toLowerCase() + "." + name;
    }

    public static Block get(String name) {
        return GameRegistry.findBlock((String)"GardenContainers", (String)name);
    }

    public static String getQualifiedName(Block block) {
        return GameData.getBlockRegistry().func_148750_c((Object)block);
    }

    public static UniqueMetaIdentifier getUniqueMetaID(Block block, int meta) {
        String name = GameData.getBlockRegistry().func_148750_c((Object)block);
        if (name == null) {
            FMLLog.log((String)"GardenContainers", (Level)Level.WARN, (String)"Tried to make a UniqueMetaIdentifier from an invalid block", (Object[])new Object[0]);
            return null;
        }
        return new UniqueMetaIdentifier(name, meta);
    }
}

