/*
 * Decompiled with CFR 0.152.
 */
package com.jaquadro.minecraft.gardenapi.internal.registry;

import com.jaquadro.minecraft.gardenapi.api.machine.ICompostMaterial;
import com.jaquadro.minecraft.gardenapi.api.machine.ICompostRegistry;
import com.jaquadro.minecraft.gardenapi.api.machine.StandardCompostMaterial;
import com.jaquadro.minecraft.gardencore.util.UniqueMetaIdentifier;
import com.jaquadro.minecraft.gardencore.util.UniqueMetaRegistry;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLeavesBase;
import net.minecraft.block.BlockVine;
import net.minecraft.block.IGrowable;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemFood;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.oredict.OreDictionary;

public class CompostRegistry
implements ICompostRegistry {
    private static ICompostMaterial defaultMaterial = new StandardCompostMaterial();
    private UniqueMetaRegistry<ICompostMaterial> itemRegistry = new UniqueMetaRegistry();
    private Map<String, ICompostMaterial> oreDictRegistry = new HashMap<String, ICompostMaterial>();
    private Map<Class, ICompostMaterial> classRegistry = new HashMap<Class, ICompostMaterial>();

    public CompostRegistry() {
        this.init();
    }

    private void init() {
        this.registerCompostMaterial(new ItemStack(Blocks.field_150440_ba), defaultMaterial);
        this.registerCompostMaterial(new ItemStack(Blocks.field_150423_aK), defaultMaterial);
        this.registerCompostMaterial(new ItemStack(Blocks.field_150407_cf), defaultMaterial);
        this.registerCompostMaterial(new ItemStack(Items.field_151007_F), (ICompostMaterial)new StandardCompostMaterial(100, 0.0625f));
        this.registerCompostMaterial(new ItemStack(Items.field_151015_O), (ICompostMaterial)new StandardCompostMaterial(100, 0.125f));
        this.registerCompostMaterial(new ItemStack(Items.field_151120_aE), (ICompostMaterial)new StandardCompostMaterial(150, 0.125f));
        this.registerCompostMaterial(new ItemStack(Items.field_151008_G), (ICompostMaterial)new StandardCompostMaterial(50, 0.0625f));
        this.registerCompostMaterial(new ItemStack(Items.field_151078_bh), (ICompostMaterial)new StandardCompostMaterial(150, 0.125f));
        this.registerCompostMaterial(new ItemStack(Items.field_151116_aA), (ICompostMaterial)new StandardCompostMaterial(150, 0.125f));
        this.registerCompostMaterial("treeWood", (ICompostMaterial)new StandardCompostMaterial(300, 0.25f));
        this.registerCompostMaterial("logWood", (ICompostMaterial)new StandardCompostMaterial(300, 0.25f));
        this.registerCompostMaterial("treeLeaves", defaultMaterial);
        this.registerCompostMaterial("treeSapling", defaultMaterial);
        this.registerCompostMaterial("stickWood", defaultMaterial);
        this.registerCompostMaterial(IPlantable.class, defaultMaterial);
        this.registerCompostMaterial(IGrowable.class, defaultMaterial);
        this.registerCompostMaterial(BlockLeavesBase.class, defaultMaterial);
        this.registerCompostMaterial(BlockVine.class, defaultMaterial);
        this.registerCompostMaterial(ItemFood.class, defaultMaterial);
    }

    @Override
    public void registerCompostMaterial(String modId, String itemId, int meta, ICompostMaterial materialInfo) {
        if (modId != null && itemId != null && materialInfo != null) {
            UniqueMetaIdentifier id = new UniqueMetaIdentifier(modId, itemId, meta);
            this.itemRegistry.register(id, materialInfo);
        }
    }

    @Override
    public void registerCompostMaterial(String modId, String itemId, ICompostMaterial materialInfo) {
        if (modId != null && itemId != null && materialInfo != null) {
            UniqueMetaIdentifier id = new UniqueMetaIdentifier(modId, itemId);
            this.itemRegistry.register(id, materialInfo);
        }
    }

    @Override
    public void registerCompostMaterial(ItemStack itemStack, ICompostMaterial materialInfo) {
        UniqueMetaIdentifier id = UniqueMetaIdentifier.createFor(itemStack);
        if (id != null && materialInfo != null) {
            this.itemRegistry.register(id, materialInfo);
        }
    }

    @Override
    public void registerCompostMaterial(String oreDictionaryKey, ICompostMaterial materialInfo) {
        if (oreDictionaryKey != null && materialInfo != null) {
            this.oreDictRegistry.put(oreDictionaryKey, materialInfo);
        }
    }

    @Override
    public void registerCompostMaterial(Class clazz, ICompostMaterial materialInfo) {
        if (clazz != null && materialInfo != null) {
            this.classRegistry.put(clazz, materialInfo);
        }
    }

    @Override
    public void removeCompostMaterial(ItemStack itemStack) {
        this.itemRegistry.remove(UniqueMetaIdentifier.createFor(itemStack));
    }

    @Override
    public void removeCompostMaterial(String oreDictionaryKey) {
        if (oreDictionaryKey != null) {
            this.oreDictRegistry.remove(oreDictionaryKey);
        }
    }

    @Override
    public void removeCompostMaterial(Class clazz) {
        if (clazz != null) {
            this.classRegistry.remove(clazz);
        }
    }

    @Override
    public void clear() {
        this.itemRegistry.clear();
        this.oreDictRegistry.clear();
        this.classRegistry.clear();
    }

    @Override
    public ICompostMaterial getCompostMaterialInfo(ItemStack itemStack) {
        block10: {
            block9: {
                ICompostMaterial entry;
                if (itemStack == null) {
                    return null;
                }
                UniqueMetaIdentifier id = UniqueMetaIdentifier.createFor(itemStack);
                if (id != null && (entry = this.itemRegistry.getEntry(id)) != null) {
                    return entry;
                }
                for (int oreId : OreDictionary.getOreIDs((ItemStack)itemStack)) {
                    ICompostMaterial entry2;
                    String oreEntry = OreDictionary.getOreName((int)oreId);
                    if (oreEntry == null || (entry2 = this.oreDictRegistry.get(oreEntry)) == null) continue;
                    return entry2;
                }
                if (!(itemStack.func_77973_b() instanceof ItemBlock)) break block9;
                Block block = Block.func_149634_a((Item)itemStack.func_77973_b());
                for (Class<?> clazz = block.getClass(); clazz != null; clazz = clazz.getSuperclass()) {
                    if (this.classRegistry.containsKey(clazz)) {
                        return this.classRegistry.get(clazz);
                    }
                    for (Class<?> iface : clazz.getInterfaces()) {
                        if (!this.classRegistry.containsKey(iface)) continue;
                        return this.classRegistry.get(iface);
                    }
                }
                break block10;
            }
            if (itemStack.func_77973_b() == null) break block10;
            for (Class<?> clazz = itemStack.func_77973_b().getClass(); clazz != null; clazz = clazz.getSuperclass()) {
                if (this.classRegistry.containsKey(clazz)) {
                    return this.classRegistry.get(clazz);
                }
                for (Class<?> iface : clazz.getInterfaces()) {
                    if (!this.classRegistry.containsKey(iface)) continue;
                    return this.classRegistry.get(iface);
                }
            }
        }
        return null;
    }
}

