/*
 * Decompiled with CFR 0.152.
 */
package com.jaquadro.minecraft.gardenapi.api.component;

import com.jaquadro.minecraft.gardenapi.api.component.ILanternSource;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.Random;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import net.minecraftforge.client.IItemRenderer;

public abstract class StandardLanternSource
implements ILanternSource {
    private LanternSourceInfo info;

    public StandardLanternSource(LanternSourceInfo info) {
        this.info = info;
    }

    @Override
    public String getSourceID() {
        return this.info.sourceID;
    }

    @Override
    public int getSourceMeta(ItemStack item) {
        return item != null ? item.func_77960_j() : 0;
    }

    @Override
    public boolean isValidSourceItem(ItemStack item) {
        return item != null && item.func_77973_b() == this.info.item;
    }

    @Override
    public ItemStack getRemovedItem(int meta) {
        return new ItemStack(this.info.item, 1, meta);
    }

    @Override
    public int getLightLevel(int meta) {
        return this.info.lightLevel;
    }

    @Override
    public String getLanguageKey(int meta) {
        return "gardenstuff.lanternSource." + this.info.sourceID;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void renderParticle(World world, int x, int y, int z, Random rand, int meta) {
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void render(RenderBlocks renderer, int x, int y, int z, int meta, int pass) {
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void renderItem(RenderBlocks renderer, IItemRenderer.ItemRenderType renderType, int meta) {
    }

    @Override
    public boolean renderInPass(int pass) {
        return pass == 0;
    }

    public static class LanternSourceInfo {
        public String sourceID;
        public Item item;
        public int lightLevel;

        public LanternSourceInfo(String sourceID, Item item, int lightLevel) {
            this.sourceID = sourceID;
            this.item = item;
            this.lightLevel = lightLevel;
        }
    }
}

