/*
 * Decompiled with CFR 0.152.
 */
package latmod.silicio.tile;

import cofh.api.energy.EnergyStorage;
import cofh.api.energy.IEnergyReceiver;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import latmod.core.InvUtils;
import latmod.core.LatCoreMC;
import latmod.core.gui.ContainerEmpty;
import latmod.core.tile.IGuiTile;
import latmod.core.tile.ISecureTile;
import latmod.core.tile.IWailaTile;
import latmod.core.tile.TileLM;
import latmod.core.util.FastList;
import latmod.core.util.FastMap;
import latmod.core.util.LatCore;
import latmod.silicio.SilItems;
import latmod.silicio.gui.GuiController;
import latmod.silicio.item.IItemCard;
import latmod.silicio.item.modules.ICBModule;
import latmod.silicio.tile.CBChannel;
import latmod.silicio.tile.CircuitBoard;
import latmod.silicio.tile.ICBEnergyTile;
import latmod.silicio.tile.ICBNetTile;
import latmod.silicio.tile.InvEntry;
import latmod.silicio.tile.TankEntry;
import latmod.silicio.tile.TileCBCable;
import mcp.mobius.waila.api.IWailaConfigHandler;
import mcp.mobius.waila.api.IWailaDataAccessor;
import net.minecraft.block.Block;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Facing;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class TileCBController
extends TileLM
implements ICBNetTile,
IEnergyReceiver,
IWailaTile.Body,
ISecureTile,
IGuiTile {
    public final FastList<ICBNetTile> network;
    private final FastList<ICBNetTile> prevNetwork;
    public final FastList<CircuitBoard> circuitBoards;
    public final FastMap<CircuitBoard, FastMap<Integer, ICBModule>> allModules;
    public final FastList<InvEntry> invNetwork;
    public final FastList<TankEntry> tankNetwork;
    public final CBChannel[] channels;
    public final CBChannel[] prevChannels;
    public boolean energyChanged;
    public EnergyStorage storage = new EnergyStorage(50000000, 500000);
    private int pNetworkSize = -1;
    public boolean hasConflict = false;
    private int prevEnergyWaila = -1;
    private int currentEnergyWaila = -1;

    public TileCBController() {
        this.network = new FastList();
        this.prevNetwork = new FastList();
        this.circuitBoards = new FastList();
        this.allModules = new FastMap();
        this.invNetwork = new FastList();
        this.tankNetwork = new FastList();
        this.channels = CBChannel.create(128);
        this.prevChannels = CBChannel.create(128);
    }

    public boolean rerenderBlock() {
        return true;
    }

    public void readTileData(NBTTagCompound tag) {
        super.readTileData(tag);
        this.storage.readFromNBT(tag);
        CBChannel.readFromNBT(tag, "Channels", this.channels);
        this.hasConflict = tag.func_74764_b("Conflict");
    }

    public void writeTileData(NBTTagCompound tag) {
        super.writeTileData(tag);
        this.storage.writeToNBT(tag);
        CBChannel.writeToNBT(tag, "Channels", this.channels);
        if (this.hasConflict) {
            tag.func_74757_a("Conflict", true);
        }
    }

    public void addWailaBody(IWailaDataAccessor data, IWailaConfigHandler config, List<String> info) {
        ICBEnergyTile.Helper.addWailaWithChange(this.storage, info, this.currentEnergyWaila == -1 || this.prevEnergyWaila == -1 ? 0 : this.currentEnergyWaila - this.prevEnergyWaila);
        if (this.hasConflict) {
            info.add("Conflicting Controller found!");
        } else {
            int cables = 0;
            int otherDevices = 0;
            for (ICBNetTile t : this.network) {
                if (!(t instanceof TileCBCable)) continue;
                ++cables;
            }
            otherDevices = this.network.size() - cables;
            if (cables > 0) {
                info.add("Cables: " + cables);
            }
            if (otherDevices > 0) {
                info.add("Other Devices: " + otherDevices);
            }
            if (!this.circuitBoards.isEmpty()) {
                info.add("CircuitBoards: " + this.circuitBoards.size());
            }
            int am = 0;
            for (FastMap m : this.allModules) {
                am += m.size();
            }
            if (!this.allModules.isEmpty()) {
                info.add("Modules: " + am);
            }
            if (!this.invNetwork.isEmpty()) {
                info.add("IInventories: " + this.invNetwork.size());
            }
            if (!this.tankNetwork.isEmpty()) {
                info.add("IFluidHandlers: " + this.tankNetwork.size());
            }
        }
    }

    public boolean onRightClick(EntityPlayer ep, ItemStack is, int side, float x, float y, float z) {
        if (this.isServer()) {
            LatCoreMC.openGui((EntityPlayer)ep, (IGuiTile)this, null);
        }
        return true;
    }

    public boolean canConnect(ForgeDirection side) {
        return true;
    }

    @Override
    public void preUpdate(TileCBController c) {
        CBChannel.copy(this.channels, this.prevChannels);
        CBChannel.clear(this.channels);
    }

    public void onUnloaded() {
        for (ICBNetTile t : this.network) {
            t.onControllerDisconnected();
        }
    }

    public void onUpdate() {
        boolean pHasConflict;
        block6: {
            if (this.isServer() && this.energyChanged && this.tick % 20L == 0L) {
                this.energyChanged = false;
                this.prevEnergyWaila = this.currentEnergyWaila;
                this.currentEnergyWaila = this.storage.getEnergyStored();
                this.func_70296_d();
                for (ICBNetTile t : this.network) {
                    if (!(t instanceof ICBEnergyTile)) continue;
                    ((TileEntity)t).func_70296_d();
                }
            }
            pHasConflict = this.hasConflict;
            this.hasConflict = false;
            this.prevNetwork.clear();
            this.prevNetwork.addAll(this.network);
            this.network.clear();
            this.circuitBoards.clear();
            this.allModules.clear();
            this.invNetwork.clear();
            this.tankNetwork.clear();
            try {
                this.onUpdateCB();
            }
            catch (Exception e) {
                this.hasConflict = true;
                if (!this.field_145850_b.func_147468_f(this.field_145851_c, this.field_145848_d, this.field_145849_e)) break block6;
                e.printStackTrace();
                LatCoreMC.printChat(null, (Object)("CBController @ " + LatCore.stripInt((int[])new int[]{this.field_145851_c, this.field_145848_d, this.field_145849_e}) + " crashed!"), (boolean)true);
                InvUtils.dropItem((World)this.field_145850_b, (double)((double)this.field_145851_c + 0.5), (double)((double)this.field_145848_d + 0.5), (double)((double)this.field_145849_e + 0.5), (ItemStack)new ItemStack((Block)SilItems.b_cbcontroller), (int)10);
            }
        }
        for (ICBNetTile t : this.prevNetwork) {
            t.onControllerDisconnected();
        }
        if (pHasConflict != this.hasConflict) {
            this.func_70296_d();
        }
    }

    @Override
    public void onUpdateCB() {
        this.preUpdate(this);
        this.addToList(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        this.network.remove((Object)this);
        if (this.pNetworkSize != this.network.size()) {
            this.pNetworkSize = this.network.size();
            this.func_70296_d();
            this.sendDirtyUpdate();
            if (this.hasConflict) {
                for (ICBNetTile t : this.network) {
                    t.onControllerDisconnected();
                }
            }
        }
        if (this.hasConflict) {
            return;
        }
        for (ICBNetTile t : this.network) {
            t.preUpdate(this);
            if (!(t instanceof ICBEnergyTile) || this.storage.getEnergyStored() <= 0) continue;
            EnergyStorage e = ((ICBEnergyTile)t).getEnergyStorage();
            int d = Math.min(e.getMaxReceive(), this.storage.getMaxExtract());
            if ((d = Math.min(d, Math.min(this.storage.getEnergyStored(), e.getMaxEnergyStored() - e.getEnergyStored()))) <= 0) continue;
            this.storage.extractEnergy(d, false);
            e.receiveEnergy(d, false);
            this.energyChanged = true;
        }
        if (!this.isServer()) {
            return;
        }
        for (ICBNetTile t : this.network) {
            t.onUpdateCB();
        }
    }

    @Override
    public void onControllerDisconnected() {
    }

    public void onBroken() {
        super.onBroken();
        for (ICBNetTile t : this.network) {
            t.onControllerDisconnected();
        }
    }

    private void addToList(int x, int y, int z) {
        for (int i = 0; i < 6; ++i) {
            int px = x + Facing.field_71586_b[i];
            int py = y + Facing.field_71587_c[i];
            int pz = z + Facing.field_71585_d[i];
            TileEntity te = this.field_145850_b.func_147438_o(px, py, pz);
            if (te == null || te.func_145837_r() || !(te instanceof ICBNetTile)) continue;
            ICBNetTile ec = (ICBNetTile)te;
            if (ec != this && ec instanceof TileCBController) {
                this.hasConflict = true;
                return;
            }
            if (!ec.isSideEnabled(Facing.field_71588_a[i]) || this.network.contains((Object)ec)) continue;
            this.network.add((Object)ec);
            this.prevNetwork.remove((Object)ec);
            if (ec instanceof TileCBCable) {
                TileCBCable tc = (TileCBCable)ec;
                for (int b = 0; b < 6; ++b) {
                    if (tc.boards[b] == null) continue;
                    this.circuitBoards.add((Object)tc.boards[b]);
                    FastMap<Integer, ICBModule> modules = tc.boards[b].getAllModules();
                    this.allModules.put((Object)tc.boards[b], modules);
                    for (int j = 0; j < modules.size(); ++j) {
                        ICBModule m = (ICBModule)modules.values.get(j);
                        int MID = (Integer)modules.keys.get(j);
                        m.updateInvNet(tc.boards[b], MID, this.invNetwork);
                        m.updateTankNet(tc.boards[b], MID, this.tankNetwork);
                    }
                }
            }
            this.addToList(px, py, pz);
        }
    }

    @Override
    public boolean canConnectEnergy(ForgeDirection dir) {
        return true;
    }

    public boolean hasEnergy(int e) {
        return this.storage.getEnergyStored() >= e;
    }

    @Override
    public int receiveEnergy(ForgeDirection dir, int e, boolean simulate) {
        int i = this.storage.receiveEnergy(e, simulate);
        if (i != 0) {
            this.energyChanged = true;
        }
        return i;
    }

    public int receiveEnergy(int e) {
        return this.receiveEnergy(ForgeDirection.UNKNOWN, e, this.field_145850_b.field_72995_K);
    }

    public int extractEnergy(ForgeDirection dir, int e, boolean simulate) {
        int i = this.storage.extractEnergy(e, simulate);
        if (i != 0) {
            this.energyChanged = true;
        }
        return i;
    }

    public int extractEnergy(int e) {
        return this.extractEnergy(ForgeDirection.UNKNOWN, e, this.field_145850_b.field_72995_K);
    }

    @Override
    public int getEnergyStored(ForgeDirection dir) {
        return this.storage.getEnergyStored();
    }

    @Override
    public int getMaxEnergyStored(ForgeDirection dir) {
        return this.storage.getMaxEnergyStored();
    }

    @Override
    public boolean isSideEnabled(int side) {
        return true;
    }

    public boolean addItem(ItemStack is, boolean simulate) {
        if (is == null) {
            return false;
        }
        for (InvEntry e : this.invNetwork.sortToNew(null)) {
            if (!IItemCard.Helper.isValid(e.filter, is) || !InvUtils.addSingleItemToInv((ItemStack)is, (IInventory)e.inv, (int)e.side, (!simulate ? 1 : 0) != 0)) continue;
            return true;
        }
        return false;
    }

    public boolean requestItem(ItemStack is, boolean simulate) {
        if (is == null) {
            return false;
        }
        for (InvEntry e : this.invNetwork.sortToNew(null)) {
            int idx;
            if (!IItemCard.Helper.isValid(e.filter, is) || (idx = InvUtils.getFirstFilledIndex((IInventory)e.inv, (ItemStack)is, (int)e.side)) == -1) continue;
            if (!simulate) {
                e.inv.func_70299_a(idx, InvUtils.reduceItem((ItemStack)e.inv.func_70301_a(idx)));
                e.inv.func_70296_d();
            }
            return true;
        }
        return false;
    }

    public Container getContainer(EntityPlayer ep, NBTTagCompound data) {
        return new ContainerEmpty(ep, (Object)this);
    }

    @SideOnly(value=Side.CLIENT)
    public GuiScreen getGui(EntityPlayer ep, NBTTagCompound data) {
        return new GuiController(new ContainerEmpty(ep, (Object)this));
    }
}

