/*
 * Decompiled with CFR 0.152.
 */
package latmod.silicio.gui;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import latmod.core.gui.ButtonLM;
import latmod.core.gui.ContainerLM;
import latmod.core.gui.GuiLM;
import latmod.core.gui.TextureCoords;
import latmod.core.mod.LC;
import latmod.core.util.FastList;
import latmod.silicio.gui.GuiModule;
import latmod.silicio.gui.container.ContainerModuleSettings;
import latmod.silicio.item.modules.ICBModule;
import latmod.silicio.item.modules.config.ModuleCSBool;
import latmod.silicio.item.modules.config.ModuleCSFluid;
import latmod.silicio.item.modules.config.ModuleCSItem;
import latmod.silicio.item.modules.config.ModuleCSNum;
import latmod.silicio.item.modules.config.ModuleConfigSegment;
import latmod.silicio.tile.CircuitBoard;
import latmod.silicio.tile.TileCBCable;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.entity.RenderItem;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IIcon;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class GuiModuleSettings
extends GuiLM {
    public static final ResourceLocation thisTex = GuiModule.getTex("moduleSettings.png");
    public static final TextureCoords icon_channels = new TextureCoords(thisTex, 176, 0);
    public static final TextureCoords icon_cfg_empty = new TextureCoords(thisTex, 197, 0);
    public static final TextureCoords icon_cfg_text = new TextureCoords(thisTex, 218, 0);
    public static final TextureCoords icon_cfg_num = new TextureCoords(thisTex, 176, 21);
    public static final TextureCoords icon_cfg_bool = new TextureCoords(thisTex, 197, 21);
    public static final TextureCoords icon_cfg_item = new TextureCoords(thisTex, 218, 21);
    public static final TextureCoords icon_cfg_fluid = new TextureCoords(thisTex, 218, 42);
    public final CircuitBoard board;
    public final ICBModule module;
    public final int moduleID;
    public ButtonLM buttonChannels;
    public ButtonLM buttonBack;
    public ButtonLM buttonClicked;
    public ButtonLM[] buttonsConfig;
    private static RenderItem renderItem = new RenderItem();

    public GuiModuleSettings(ContainerModuleSettings c, int id) {
        super((ContainerLM)c, thisTex);
        this.field_146999_f = 176;
        this.field_147000_g = 142;
        this.board = (CircuitBoard)c.inv;
        this.moduleID = id;
        this.module = this.board.getModule(this.moduleID);
        this.buttonChannels = new ButtonLM(this, 8, 9, 21, 21){

            public void onButtonPressed(int b) {
                GuiModuleSettings.this.playClickSound();
                GuiModuleSettings.this.board.cable.clientOpenGui(TileCBCable.guiData(GuiModuleSettings.this.board.side, 3, GuiModuleSettings.this.moduleID));
            }
        };
        this.buttonChannels.title = "Select Channels";
        if (this.module.getChannelCount() > 0) {
            this.widgets.add((Object)this.buttonChannels);
        }
        this.buttonBack = new ButtonLM(this, 8, 32, 21, 21){

            public void onButtonPressed(int b) {
                GuiModuleSettings.this.playClickSound();
                GuiModuleSettings.this.board.cable.clientOpenGui(TileCBCable.guiData(GuiModuleSettings.this.board.side, 1, -1));
            }
        };
        this.widgets.add((Object)this.buttonBack);
        this.buttonBack.title = LC.mod.translate("button.back", new Object[0]);
        this.buttonsConfig = new ButtonLM[12];
        for (final ModuleConfigSegment mcs : this.module.getModuleConfig()) {
            if (mcs == null || mcs.ID < 0 || mcs.ID >= this.buttonsConfig.length) continue;
            this.buttonsConfig[mcs.ID] = new ButtonLM(this, 31 + 23 * (mcs.ID % 6), 9 + 23 * (mcs.ID / 6), 21, 21){

                public void onButtonPressed(int b) {
                    GuiModuleSettings.this.playClickSound();
                    GuiModuleSettings.this.buttonClicked = this;
                    mcs.buttonClicked(GuiModuleSettings.this);
                }

                public void addMouseOverText(FastList<String> l) {
                    l.add((Object)mcs.title);
                    FastList l1 = new FastList();
                    mcs.addButtonDesc(GuiModuleSettings.this, (FastList<String>)l1);
                    for (String s : l1) {
                        l.add((Object)(EnumChatFormatting.DARK_GRAY + s));
                    }
                }
            };
            if (mcs instanceof ModuleCSBool) {
                this.buttonsConfig[mcs.ID].background = icon_cfg_bool;
            } else if (mcs instanceof ModuleCSNum) {
                this.buttonsConfig[mcs.ID].background = icon_cfg_num;
            } else if (mcs instanceof ModuleCSItem) {
                this.buttonsConfig[mcs.ID].background = icon_cfg_item;
                ItemStack is = ((ModuleCSItem)mcs).getItem(this.board.items[this.moduleID]);
                if (is != null) {
                    this.buttonsConfig[mcs.ID].background = is;
                }
            } else if (mcs instanceof ModuleCSFluid) {
                this.buttonsConfig[mcs.ID].background = icon_cfg_fluid;
                FluidStack fs = ((ModuleCSFluid)mcs).getFluid(this.board.items[this.moduleID]);
                if (fs != null) {
                    this.buttonsConfig[mcs.ID].background = fs;
                }
            } else {
                this.buttonsConfig[mcs.ID].background = icon_cfg_text;
            }
            this.widgets.add((Object)this.buttonsConfig[mcs.ID]);
        }
    }

    public GuiModuleSettings(GuiModuleSettings parent) {
        this(new ContainerModuleSettings(parent.container.player, parent.board), parent.moduleID);
    }

    public void func_146976_a(float f, int mx, int my) {
        super.func_146976_a(f, mx, my);
        if (this.module.getChannelCount() > 0) {
            this.buttonChannels.render((Object)icon_channels);
        }
        for (ButtonLM b : this.buttonsConfig) {
            if (b == null || b.background == null) continue;
            if (b.background instanceof ItemStack) {
                b.render((Object)icon_cfg_empty);
                GL11.glPushMatrix();
                GL11.glTranslatef((float)((float)(b.posX + this.field_147003_i) + 2.5f), (float)((float)(b.posY + this.field_147009_r) + 2.5f), (float)0.0f);
                GL11.glPushAttrib((int)8192);
                RenderHelper.func_74520_c();
                GL11.glDisable((int)2896);
                GL11.glEnable((int)32826);
                GL11.glEnable((int)2903);
                GL11.glEnable((int)2896);
                renderItem.renderItemIntoGUI(this.field_146297_k.field_71466_p, this.field_146297_k.func_110434_K(), (ItemStack)b.background, 0, 0, false);
                renderItem.func_77021_b(this.field_146297_k.field_71466_p, this.field_146297_k.func_110434_K(), (ItemStack)b.background, 0, 0);
                GL11.glDisable((int)2896);
                GL11.glDepthMask((boolean)true);
                GL11.glEnable((int)2929);
                GL11.glPopAttrib();
                GL11.glPopMatrix();
                continue;
            }
            if (b.background instanceof FluidStack) {
                b.render((Object)icon_cfg_empty);
                Fluid fl = ((FluidStack)b.background).getFluid();
                IIcon ic = fl.getStillIcon();
                if (ic == null && fl.getBlock() != null) {
                    ic = fl.getBlock().func_149733_h(1);
                }
                if (ic == null) continue;
                GL11.glPushMatrix();
                this.setTexture(TextureMap.field_110575_b);
                GL11.glTranslatef((float)((float)(b.posX + this.field_147003_i) + 2.5f), (float)((float)(b.posY + this.field_147009_r) + 2.5f), (float)0.0f);
                this.drawWrappedIcon(ic, 0.0f, 0.0f, 16.0f, 16.0f);
                this.setTexture(thisTex);
                GL11.glPopMatrix();
                continue;
            }
            b.render(b.background);
        }
    }
}

