/*
 * Decompiled with CFR 0.152.
 */
package uk.co.qmunity.lib.network.packet;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Map;
import net.minecraft.entity.player.EntityPlayer;
import uk.co.qmunity.lib.network.packet.PacketCPart;
import uk.co.qmunity.lib.part.IPart;
import uk.co.qmunity.lib.part.ITilePartHolder;
import uk.co.qmunity.lib.part.PartRegistry;
import uk.co.qmunity.lib.part.compat.MultipartCompatibility;
import uk.co.qmunity.lib.vec.Vec3i;

public class PacketCAddPart
extends PacketCPart {
    private String type;
    private byte[] data;

    public PacketCAddPart(ITilePartHolder holder, IPart part) {
        super(holder, part);
    }

    public PacketCAddPart() {
    }

    @Override
    public void handle(EntityPlayer player) {
        this.part = PartRegistry.createPart(this.type, true);
        MultipartCompatibility.addPartToWorldBruteforce(this.part, player.field_70170_p, new Vec3i(this.x, this.y, this.z, player.field_70170_p));
        this.holder = this.part.getParent();
        if (this.holder == null) {
            return;
        }
        Map<String, IPart> map = this.holder.getPartMap();
        String oldId = null;
        for (String id : this.holder.getPartMap().keySet()) {
            if (this.holder.getPartMap().get(id) != this.part) continue;
            oldId = id;
        }
        map.remove(oldId);
        map.put(this.partId, this.part);
        try {
            this.part.readUpdateData(new DataInputStream(new ByteArrayInputStream(this.data)), -1);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void writeData(DataOutput buffer) throws IOException {
        buffer.writeUTF(this.part.getType());
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        this.part.writeUpdateData(new DataOutputStream(os), -1);
        this.data = os.toByteArray();
        buffer.writeInt(this.data.length);
        buffer.write(this.data);
    }

    @Override
    public void readData(DataInput buffer) throws IOException {
        this.type = buffer.readUTF();
        this.data = new byte[buffer.readInt()];
        buffer.readFully(this.data);
    }
}

