/*
 * Decompiled with CFR 0.152.
 */
package latmod.core.util;

import java.util.Random;
import latmod.core.mod.LC;
import latmod.core.util.FastList;
import latmod.core.util.Vertex;
import net.minecraft.block.BlockPistonBase;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.MathHelper;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class MathHelperLM {
    public static final Random rand = new Random();
    public static final double RAD = Math.PI / 180;
    public static final double DEG = 57.29577951308232;
    public static final double TWO_PI = Math.PI * 2;
    public static final double HALF_PI = 1.5707963267948966;

    public static double sin(double d) {
        return MathHelper.func_76126_a((float)((float)d));
    }

    public static double cos(double d) {
        return MathHelper.func_76134_b((float)((float)d));
    }

    public static double tan(double d) {
        return MathHelperLM.sin(d) / MathHelperLM.cos(d);
    }

    public static double sinFromDeg(double f) {
        return MathHelperLM.sin(f * (Math.PI / 180));
    }

    public static double cosFromDeg(double f) {
        return MathHelperLM.cos(f * (Math.PI / 180));
    }

    public static double tanFromDeg(double f) {
        return MathHelperLM.tan(f * (Math.PI / 180));
    }

    public static double sqrt(double d) {
        if (d == 0.0) {
            return 0.0;
        }
        if (d == 1.0) {
            return 1.0;
        }
        return Math.sqrt(d);
    }

    public static double sqrt2sq(double x, double y) {
        return MathHelperLM.sqrt(MathHelperLM.sq(x) + MathHelperLM.sq(y));
    }

    public static double sqrt3sq(double x, double y, double z) {
        return MathHelperLM.sqrt(MathHelperLM.sq(x) + MathHelperLM.sq(y) + MathHelperLM.sq(z));
    }

    public static double sq(double f) {
        return f * f;
    }

    public static double sq(double f, int i) {
        if (i == 2) {
            return MathHelperLM.sq(f);
        }
        double f1 = 1.0;
        for (int j = 0; j < i; ++j) {
            f1 *= f;
        }
        return f1;
    }

    public static int power(int f, int n) {
        int j = 1;
        for (int i = 0; i < n; ++i) {
            j *= f;
        }
        return j;
    }

    public static long powerLong(long f, int n) {
        long j = 1L;
        for (int i = 0; i < n; ++i) {
            j *= f;
        }
        return j;
    }

    public static double distSq(double x1, double y1, double z1, double x2, double y2, double z2) {
        return MathHelperLM.sq(x2 - x1) + MathHelperLM.sq(y2 - y1) + MathHelperLM.sq(z2 - z1);
    }

    public static double dist(double x1, double y1, double z1, double x2, double y2, double z2) {
        return MathHelperLM.sqrt(MathHelperLM.distSq(x1, y1, z1, x2, y2, z2));
    }

    public static Vertex getLook(Vertex v, double yaw, double pitch, double dist) {
        if (v == null) {
            v = new Vertex();
        }
        double f = MathHelperLM.cos(pitch * (Math.PI / 180));
        double x1 = MathHelperLM.cos(-yaw * (Math.PI / 180) + 1.5707963267948966);
        double z1 = MathHelperLM.sin(-yaw * (Math.PI / 180) + 1.5707963267948966);
        double y1 = MathHelperLM.sin(pitch * (Math.PI / 180));
        v.set(x1 * f * dist, y1 * dist, z1 * f * dist);
        return v;
    }

    public static int floor(double d) {
        return MathHelper.func_76128_c((double)d);
    }

    public static int chunk(double d) {
        return MathHelperLM.floor(d) >> 4;
    }

    public static int ceil(double d) {
        return MathHelper.func_76143_f((double)d);
    }

    public static int randomInt(Random r, int min, int max) {
        if (min == max) {
            return min;
        }
        if (min > max) {
            int min0 = min;
            min = max;
            max = min0;
        }
        return min + r.nextInt(max - min + 1);
    }

    public static double randomDouble(Random r, double min, double max) {
        if (min == max) {
            return min;
        }
        if (min > max) {
            double min0 = min;
            min = max;
            max = min0;
        }
        return min + r.nextDouble() * (max - min);
    }

    public static boolean isRound(double d) {
        return (double)Math.round(d) == d;
    }

    public static int lerpInt(int i1, int i2, double f) {
        return i1 + (int)((double)(i2 - i1) * f);
    }

    public static double lerp(double f1, double f2, double f) {
        return f1 + (f2 - f1) * f;
    }

    public static double clamp(double d, double min, double max) {
        if (d < min) {
            d = min;
        }
        if (d > max) {
            d = max;
        }
        return d;
    }

    public static int clampInt(int i, int min, int max) {
        if (i < min) {
            i = min;
        }
        if (i > max) {
            i = max;
        }
        return i;
    }

    public static double[] clamp(double[] d, double min, double max) {
        for (int i = 0; i < d.length; ++i) {
            d[i] = MathHelperLM.clamp(d[i], min, max);
        }
        return d;
    }

    public static int[] clampInt(int[] i, int min, int max) {
        for (int j = 0; j < i.length; ++j) {
            i[j] = MathHelperLM.clampInt(i[j], min, max);
        }
        return i;
    }

    public static int toIntDecoded(String s) {
        return Integer.decode(s);
    }

    public static int toInt(String s) {
        return Integer.parseInt(s.trim());
    }

    public static double toDouble(String s) {
        return Double.parseDouble(s.trim());
    }

    public static int toInt(String s, int def) {
        try {
            return Integer.parseInt(s.trim());
        }
        catch (Exception e) {
            return def;
        }
    }

    public static double toDouble(String s, double def) {
        try {
            return MathHelperLM.toDouble(s);
        }
        catch (Exception e) {
            return def;
        }
    }

    public static double toSmallDouble(double f) {
        long i = (long)(f * 100.0);
        return (double)i / 100.0;
    }

    public static Integer decode(String s) {
        try {
            Integer i = Integer.decode(s);
            return i;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static boolean canParseInt(String s) {
        try {
            Integer.parseInt(s);
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public static double map(double val, double min1, double max1, double min2, double max2) {
        return min2 + (max2 - min2) * ((val - min1) / (max1 - min1));
    }

    public static int mapInt(int val, int min1, int max1, int min2, int max2) {
        return min2 + (max2 - min2) * ((val - min1) / (max1 - min1));
    }

    public static final Vertex getMidPoint(double x1, double y1, double z1, double x2, double y2, double z2, double p) {
        double x = x2 - x1;
        double y = y2 - y1;
        double z = z2 - z1;
        double d = Math.sqrt(x * x + y * y + z * z);
        return new Vertex(x1 + x / d * (d * p), y1 + y / d * (d * p), z1 + z / d * (d * p));
    }

    public static Vertex getMidPoint(Vertex v1, Vertex v2, double p) {
        return MathHelperLM.getMidPoint(v1.x, v1.y, v1.z, v2.x, v2.y, v2.z, p);
    }

    public static boolean isPlural(int i) {
        String s = "" + i;
        return !s.endsWith("1") || s.endsWith("11");
    }

    public static String getPluralWord(int i, String s, String p) {
        return MathHelperLM.isPlural(i) ? p : s;
    }

    public static String formatDouble(double d) {
        String s = "" + d;
        if (s.endsWith(".0")) {
            s = s.substring(0, s.length() - 2);
        }
        return s;
    }

    public static final int getRotations(double yaw, int max) {
        return MathHelperLM.floor(yaw * (double)max / 360.0 + 0.5) & max - 1;
    }

    public static ForgeDirection get2DRotation(EntityLivingBase el) {
        int i = MathHelperLM.getRotations(el.field_70177_z, 4);
        if (i == 0) {
            return ForgeDirection.NORTH;
        }
        if (i == 1) {
            return ForgeDirection.EAST;
        }
        if (i == 2) {
            return ForgeDirection.SOUTH;
        }
        if (i == 3) {
            return ForgeDirection.WEST;
        }
        return ForgeDirection.UNKNOWN;
    }

    public static ForgeDirection get3DRotation(World w, int x, int y, int z, EntityLivingBase el) {
        return ForgeDirection.values()[BlockPistonBase.func_150071_a((World)w, (int)x, (int)y, (int)z, (EntityLivingBase)el)];
    }

    public static final int getRotYaw(int rot) {
        if (rot == 2) {
            return 180;
        }
        if (rot == 3) {
            return 0;
        }
        if (rot == 4) {
            return 90;
        }
        if (rot == 5) {
            return -90;
        }
        return 0;
    }

    public static final int getRotPitch(int rot) {
        if (rot == 0) {
            return 90;
        }
        if (rot == 1) {
            return -90;
        }
        return 0;
    }

    public static Vec3 getEyePosition(EntityPlayer ep) {
        double y = 0.0;
        if (!ep.field_70170_p.field_72995_K) {
            y = ep.func_70047_e();
        }
        return Vec3.func_72443_a((double)ep.field_70165_t, (double)(ep.field_70163_u + y), (double)ep.field_70161_v);
    }

    public static MovingObjectPosition rayTrace(EntityPlayer ep, double d) {
        Vec3 pos = MathHelperLM.getEyePosition(ep);
        Vec3 look = ep.func_70040_Z();
        Vec3 vec = pos.func_72441_c(look.field_72450_a * d, look.field_72448_b * d, look.field_72449_c * d);
        MovingObjectPosition mop = ep.field_70170_p.func_147447_a(pos, vec, false, true, false);
        if (mop != null && mop.field_72307_f == null) {
            mop.field_72307_f = Vec3.func_72443_a((double)0.0, (double)0.0, (double)0.0);
        }
        return mop;
    }

    public static MovingObjectPosition rayTrace(EntityPlayer ep) {
        return MathHelperLM.rayTrace(ep, LC.proxy.getReachDist(ep));
    }

    public static MovingObjectPosition collisionRayTrace(World w, int x, int y, int z, Vec3 start, Vec3 end, AxisAlignedBB[] boxes) {
        if (boxes == null || boxes.length <= 0) {
            return null;
        }
        MovingObjectPosition current = null;
        double dist = Double.POSITIVE_INFINITY;
        for (int i = 0; i < boxes.length; ++i) {
            MovingObjectPosition mop;
            if (boxes[i] == null || (mop = MathHelperLM.collisionRayTrace(w, x, y, z, start, end, boxes[i])) == null) continue;
            double d1 = mop.field_72307_f.func_72436_e(start);
            if (current != null && !(d1 < dist)) continue;
            current = mop;
            current.subHit = i;
            dist = d1;
        }
        return current;
    }

    public static MovingObjectPosition collisionRayTrace(World w, int x, int y, int z, Vec3 start, Vec3 end, FastList<AxisAlignedBB> boxes) {
        AxisAlignedBB[] boxesa = new AxisAlignedBB[boxes.size()];
        for (int i = 0; i < boxesa.length; ++i) {
            boxesa[i] = boxes.get(i).func_72329_c();
        }
        return MathHelperLM.collisionRayTrace(w, x, y, z, start, end, boxesa);
    }

    public static MovingObjectPosition collisionRayTrace(World w, int x, int y, int z, Vec3 start, Vec3 end, AxisAlignedBB aabb) {
        Vec3 pos = start.func_72441_c((double)(-x), (double)(-y), (double)(-z));
        Vec3 rot = end.func_72441_c((double)(-x), (double)(-y), (double)(-z));
        Vec3 xmin = pos.func_72429_b(rot, aabb.field_72340_a);
        Vec3 xmax = pos.func_72429_b(rot, aabb.field_72336_d);
        Vec3 ymin = pos.func_72435_c(rot, aabb.field_72338_b);
        Vec3 ymax = pos.func_72435_c(rot, aabb.field_72337_e);
        Vec3 zmin = pos.func_72434_d(rot, aabb.field_72339_c);
        Vec3 zmax = pos.func_72434_d(rot, aabb.field_72334_f);
        if (!MathHelperLM.isVecInsideYZBounds(xmin, aabb)) {
            xmin = null;
        }
        if (!MathHelperLM.isVecInsideYZBounds(xmax, aabb)) {
            xmax = null;
        }
        if (!MathHelperLM.isVecInsideXZBounds(ymin, aabb)) {
            ymin = null;
        }
        if (!MathHelperLM.isVecInsideXZBounds(ymax, aabb)) {
            ymax = null;
        }
        if (!MathHelperLM.isVecInsideXYBounds(zmin, aabb)) {
            zmin = null;
        }
        if (!MathHelperLM.isVecInsideXYBounds(zmax, aabb)) {
            zmax = null;
        }
        Vec3 v = null;
        if (xmin != null && (v == null || pos.func_72436_e(xmin) < pos.func_72436_e(v))) {
            v = xmin;
        }
        if (xmax != null && (v == null || pos.func_72436_e(xmax) < pos.func_72436_e(v))) {
            v = xmax;
        }
        if (ymin != null && (v == null || pos.func_72436_e(ymin) < pos.func_72436_e(v))) {
            v = ymin;
        }
        if (ymax != null && (v == null || pos.func_72436_e(ymax) < pos.func_72436_e(v))) {
            v = ymax;
        }
        if (zmin != null && (v == null || pos.func_72436_e(zmin) < pos.func_72436_e(v))) {
            v = zmin;
        }
        if (zmax != null && (v == null || pos.func_72436_e(zmax) < pos.func_72436_e(v))) {
            v = zmax;
        }
        if (v == null) {
            return null;
        }
        int side = -1;
        if (v == xmin) {
            side = 4;
        }
        if (v == xmax) {
            side = 5;
        }
        if (v == ymin) {
            side = 0;
        }
        if (v == ymax) {
            side = 1;
        }
        if (v == zmin) {
            side = 2;
        }
        if (v == zmax) {
            side = 3;
        }
        return new MovingObjectPosition(x, y, z, side, v.func_72441_c((double)x, (double)y, (double)z));
    }

    private static boolean isVecInsideYZBounds(Vec3 v, AxisAlignedBB aabb) {
        return v == null ? false : v.field_72448_b >= aabb.field_72338_b && v.field_72448_b <= aabb.field_72337_e && v.field_72449_c >= aabb.field_72339_c && v.field_72449_c <= aabb.field_72334_f;
    }

    private static boolean isVecInsideXZBounds(Vec3 v, AxisAlignedBB aabb) {
        return v == null ? false : v.field_72450_a >= aabb.field_72340_a && v.field_72450_a <= aabb.field_72336_d && v.field_72449_c >= aabb.field_72339_c && v.field_72449_c <= aabb.field_72334_f;
    }

    private static boolean isVecInsideXYBounds(Vec3 v, AxisAlignedBB aabb) {
        return v == null ? false : v.field_72450_a >= aabb.field_72340_a && v.field_72450_a <= aabb.field_72336_d && v.field_72448_b >= aabb.field_72338_b && v.field_72448_b <= aabb.field_72337_e;
    }

    public static MovingObjectPosition getMOPFrom(int x, int y, int z, int s, float hitX, float hitY, float hitZ) {
        return new MovingObjectPosition(x, y, z, s, Vec3.func_72443_a((double)((float)x + hitX), (double)((float)y + hitY), (double)((float)z + hitZ)));
    }

    public static final ForgeDirection getDir(int s) {
        if (s >= 0 && s < ForgeDirection.VALID_DIRECTIONS.length) {
            return ForgeDirection.VALID_DIRECTIONS[s];
        }
        return ForgeDirection.UNKNOWN;
    }

    public static AxisAlignedBB getBox(double cx, double y0, double cz, double w, double y1, double d) {
        return AxisAlignedBB.func_72330_a((double)(cx - w / 2.0), (double)y0, (double)(cz - d / 2.0), (double)(cx + w / 2.0), (double)y1, (double)(cz + d / 2.0));
    }

    public static AxisAlignedBB centerBox(double x, double y, double z, double w, double h, double d) {
        return MathHelperLM.getBox(x, y - h / 2.0, z, w, y + h / 2.0, d);
    }

    public static AxisAlignedBB rotate90BoxV(AxisAlignedBB bb, ForgeDirection dir) {
        double x1 = bb.field_72340_a;
        double y1 = bb.field_72338_b;
        double z1 = bb.field_72339_c;
        double x2 = bb.field_72336_d;
        double y2 = bb.field_72337_e;
        double z2 = bb.field_72334_f;
        if (dir == null || dir == ForgeDirection.UNKNOWN || dir == ForgeDirection.NORTH || dir == ForgeDirection.SOUTH) {
            return AxisAlignedBB.func_72330_a((double)x1, (double)y1, (double)z1, (double)x2, (double)y2, (double)z2);
        }
        return AxisAlignedBB.func_72330_a((double)z1, (double)y1, (double)x1, (double)z2, (double)y2, (double)x2);
    }

    public static boolean inRange(double d, double min, double max) {
        return d >= min && d <= max;
    }

    public static int percent(double d, double max) {
        return (int)(d / max * 100.0);
    }
}

