/*
 * Decompiled with CFR 0.152.
 */
package latmod.core.util;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.Type;
import java.net.InetAddress;
import java.net.URI;
import java.net.URL;
import java.net.URLConnection;
import java.nio.channels.Channels;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import latmod.core.util.FastList;
import latmod.core.util.MathHelperLM;

public class LatCore {
    public static final int DAY24 = 86400;

    public static URL getURL(String s) {
        try {
            return new File(s).toURL();
        }
        catch (Exception e) {
            try {
                return new URL(s);
            }
            catch (Exception e2) {
                e2.printStackTrace();
                return null;
            }
        }
    }

    public static String toString(InputStream is) throws Exception {
        byte[] b = new byte[is.available()];
        is.read(b);
        return new String(b);
    }

    public static FastList<String> toStringList(String s, String regex) {
        FastList<String> al = new FastList<String>();
        String[] s1 = LatCore.split(s, regex);
        if (s1 != null && s1.length > 0) {
            for (int i = 0; i < s1.length; ++i) {
                al.add(s1[i].trim());
            }
        }
        return al;
    }

    public static String toString(FastList<String> l) {
        String s = "";
        for (int i = 0; i < l.size(); ++i) {
            s = s + l.get(i);
            if (i == l.size() - 1) continue;
            s = s + "\n";
        }
        return s;
    }

    public static FastList<String> toStringList(InputStream is) throws Exception {
        FastList<String> l = new FastList<String>();
        BufferedReader reader = new BufferedReader(new InputStreamReader(is));
        String s = null;
        while ((s = reader.readLine()) != null) {
            l.add(s);
        }
        reader.close();
        return l;
    }

    public static void saveFile(File f, FastList<String> al) throws Exception {
        LatCore.saveFile(f, LatCore.toString(al));
    }

    public static void saveFile(File f, String s) throws Exception {
        FileOutputStream os = new FileOutputStream(LatCore.newFile(f));
        ((OutputStream)os).write(s.getBytes());
        ((OutputStream)os).close();
    }

    public static FastList<String> loadFile(File f) throws Exception {
        return LatCore.toStringList(new FileInputStream(f));
    }

    public static String loadFileAsText(File f) throws Exception {
        return LatCore.toString(new FileInputStream(f));
    }

    public static <E> E newObject(Class<?> c, Object ... o) throws Exception {
        if (c == null) {
            return null;
        }
        if (o != null && o.length > 0) {
            Class[] params = new Class[o.length];
            for (int i = 0; i < o.length; ++i) {
                params[i] = o.getClass();
            }
            Constructor<?> c1 = c.getConstructor(params);
            return (E)c1.newInstance(o);
        }
        return (E)c.newInstance();
    }

    public static boolean isASCIIChar(char c) {
        return c > '\u0000' && c < '\u0100';
    }

    public static boolean isTextChar(char c) {
        if (!LatCore.isASCIIChar(c)) {
            return false;
        }
        if (c >= '0' && c <= '9') {
            return true;
        }
        if (c >= 'a' && c <= 'z') {
            return true;
        }
        if (c >= 'A' && c <= 'Z') {
            return true;
        }
        String allowed = "!@#$%^&*()_+ -=\\/,.<>?'\"[]{}|;:`~";
        return allowed.indexOf(c) != -1;
    }

    public static FastList<Package> getAllPackages() {
        FastList<Package> p = FastList.asList(Package.getPackages());
        p.sort(new Comparator<Package>(){

            @Override
            public int compare(Package o1, Package o2) {
                return o1.getName().compareTo(o2.getName());
            }
        });
        return p;
    }

    public static String[] split(String s, String regex) {
        return LatCore.split(s, regex, 0);
    }

    public static String[] split(String s, String regex, int limit) {
        String[] stringArray;
        String[] s2 = s.split(regex, limit);
        if (s2 == null) {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = s;
        } else {
            stringArray = s2;
        }
        return stringArray;
    }

    public static void replace(FastList<String> txt, String s, String s1) {
        for (int i = 0; i < txt.size(); ++i) {
            String s2 = txt.get(i);
            if (s2 == null || s2.length() <= 0 || !s2.contains(s)) continue;
            s2 = s2.replace(s, s1);
            txt.set(i, s2);
        }
    }

    public static File newFile(File f) {
        if (!f.exists()) {
            try {
                f.createNewFile();
            }
            catch (Exception e) {
                f.getParentFile().mkdirs();
                try {
                    f.createNewFile();
                }
                catch (Exception e1) {
                    e1.printStackTrace();
                }
            }
        }
        return f;
    }

    public static <E> String[] toStrings(E[] o) {
        if (o == null) {
            return null;
        }
        String[] s = new String[o.length];
        for (int i = 0; i < o.length; ++i) {
            s[i] = "" + o[i];
        }
        return s;
    }

    public static String strip(String ... o) {
        if (o == null) {
            return null;
        }
        if (o.length == 0) {
            return "";
        }
        String s = "";
        for (int i = 0; i < o.length; ++i) {
            s = s + o[i];
            if (i == o.length - 1) continue;
            s = s + ", ";
        }
        return s;
    }

    public static String stripDouble(double ... o) {
        if (o == null) {
            return null;
        }
        if (o.length == 0) {
            return "";
        }
        String s = "";
        for (int i = 0; i < o.length; ++i) {
            String s1 = "" + MathHelperLM.toSmallDouble(o[i]);
            if (s1.endsWith(".0")) {
                s1 = s1 + "0";
            }
            s = s + s1;
            if (i == o.length - 1) continue;
            s = s + ", ";
        }
        return s;
    }

    public static String stripDoubleInt(double ... o) {
        if (o == null) {
            return null;
        }
        if (o.length == 0) {
            return "";
        }
        String s = "";
        for (int i = 0; i < o.length; ++i) {
            s = s + (long)o[i];
            if (i == o.length - 1) continue;
            s = s + ", ";
        }
        return s;
    }

    public static String stripInt(int ... o) {
        if (o == null) {
            return null;
        }
        if (o.length == 0) {
            return "";
        }
        String s = "";
        for (int i = 0; i < o.length; ++i) {
            s = s + o[i];
            if (i == o.length - 1) continue;
            s = s + ", ";
        }
        return s;
    }

    public static String stripBool(boolean ... o) {
        if (o == null) {
            return null;
        }
        if (o.length == 0) {
            return "";
        }
        String s = "";
        for (int i = 0; i < o.length; ++i) {
            s = s + (o[i] ? "1" : "0");
            if (i == o.length - 1) continue;
            s = s + ", ";
        }
        return s;
    }

    public static String classpath(Class<?> c) {
        return c == null ? null : c.toString().split(" ")[1];
    }

    public static File getSourceDirectory(Class<?> c) {
        return new File(c.getProtectionDomain().getCodeSource().getLocation().getPath().replace("%20", " "));
    }

    public static FastList<Class<?>> addSubclasses(Class<?> c, FastList<Class<?>> al, boolean all) {
        if (c == null) {
            return null;
        }
        if (al == null) {
            al = new FastList();
        }
        FastList al1 = new FastList();
        al1.addAll(c.getDeclaredClasses());
        if (all && !al1.isEmpty()) {
            for (int i = 0; i < al1.size(); ++i) {
                al.addAll(LatCore.addSubclasses((Class)al1.get(i), null, true));
            }
        }
        al.addAll(al1);
        return al;
    }

    @Deprecated
    public static URLConnection connectTo(String s, int timeout) throws Exception {
        URLConnection uc = new URL(s).openConnection();
        uc.setConnectTimeout(timeout);
        uc.setDoInput(true);
        uc.setDoOutput(true);
        uc.connect();
        return uc;
    }

    public static String substring(String s, String pre, String post, boolean ignoreSpace) {
        int preI = s.indexOf(pre);
        int postI = s.lastIndexOf(post);
        String s1 = s.substring(preI + 1, postI);
        return ignoreSpace ? s1.trim() : s1;
    }

    public static String removeAllWhitespace(String s) {
        if (s == null) {
            return null;
        }
        if ((s = s.trim()).length() == 0) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (Character.isWhitespace(c)) continue;
            sb.append(c);
        }
        return sb.toString();
    }

    public static String getHostAddress() {
        try {
            return InetAddress.getLocalHost().getHostAddress();
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static String getExternalAddress() {
        try {
            return LatCore.toString(new URL("http://checkip.amazonaws.com").openStream());
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static String unsplit(String[] s, String s1) {
        if (s == null) {
            return null;
        }
        String s2 = "";
        if (s.length == 1) {
            return s[0];
        }
        for (int i = 0; i < s.length; ++i) {
            s2 = s2 + s[i];
            if (i == s.length - 1) continue;
            s2 = s2 + s1;
        }
        return s2;
    }

    public static String firstUppercase(String s) {
        if (s == null || s.length() == 0) {
            return s;
        }
        return Character.toUpperCase(s.charAt(0)) + (s.length() > 1 ? s.substring(1) : "");
    }

    public static boolean objectsEquals(Object o1, Object o2, boolean allowNulls) {
        if (o1 == null && o2 == null && allowNulls) {
            return true;
        }
        if (o1 == null || o2 == null) {
            return false;
        }
        return o1.equals(o2);
    }

    public static <T> T fromJson(String s, Type t) {
        if (s == null || s.length() < 2) {
            s = "{}";
        }
        Gson gson = new GsonBuilder().excludeFieldsWithoutExposeAnnotation().create();
        return (T)gson.fromJson(s, t);
    }

    public static <T> T fromJsonFromFile(File f, Type t) {
        try {
            FileInputStream fis = new FileInputStream(f);
            byte[] b = new byte[fis.available()];
            fis.read(b);
            fis.close();
            return LatCore.fromJson(new String(b), t);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String toJson(Object o, boolean asTree) {
        GsonBuilder gb = new GsonBuilder().excludeFieldsWithoutExposeAnnotation();
        if (asTree) {
            gb.setPrettyPrinting();
        }
        Gson gson = gb.create();
        return gson.toJson(o);
    }

    public static void toJsonFile(File f, Object o) {
        String s = LatCore.toJson(o, true);
        try {
            FileOutputStream fos = new FileOutputStream(LatCore.newFile(f));
            fos.write(s.getBytes());
            fos.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static <K, V> Type getMapType(Type K, Type V) {
        return new TypeToken<Map<K, V>>(){}.getType();
    }

    public static <E> Type getListType(Type E) {
        return new TypeToken<List<E>>(){}.getType();
    }

    public static boolean openURL(String url) {
        try {
            Class<?> oclass = Class.forName("java.awt.Desktop");
            Object object = oclass.getMethod("getDesktop", new Class[0]).invoke(null, new Object[0]);
            oclass.getMethod("browse", URI.class).invoke(object, new URI(url));
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public static boolean downloadFile(String url, File out) {
        try {
            URL website = new URL(url);
            ReadableByteChannel rbc = Channels.newChannel(website.openStream());
            FileOutputStream fos = new FileOutputStream(out);
            fos.getChannel().transferFrom(rbc, 0L, Long.MAX_VALUE);
            fos.close();
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public static boolean areEqual(String s0, String s1) {
        if (s0 == null && s1 == null) {
            return true;
        }
        if (s0 != null && s1 == null) {
            return false;
        }
        if (s0 == null && s1 != null) {
            return false;
        }
        if (s0.length() != s1.length()) {
            return false;
        }
        return s0.equals(s1);
    }

    public static String formatTime(long secs, boolean wrap) {
        String ss;
        String ms;
        long secs1 = secs;
        if (secs < 0L) {
            secs1 = -secs1;
        }
        if (wrap) {
            secs1 %= 86400L;
        }
        long h = secs1 / 3600L;
        if (wrap) {
            h %= 24L;
        }
        long m = secs1 / 60L % 60L;
        long s = secs1 % 60L;
        String hs = "" + h;
        if (hs.length() == 1) {
            hs = "0" + hs;
        }
        if ((ms = "" + m).length() == 1) {
            ms = "0" + ms;
        }
        if ((ss = "" + s).length() == 1) {
            ss = "0" + ss;
        }
        return hs + ":" + ms + ":" + ss;
    }

    public static String fillString(String s, char fill, int length) {
        int sl = s.length();
        char[] c = new char[Math.max(sl, length)];
        for (int i = 0; i < c.length; ++i) {
            c[i] = i >= sl ? fill : s.charAt(i);
        }
        return new String(c);
    }

    public static int hashCode(Object ... o) {
        int h = 0;
        for (int i = 0; i < o.length; ++i) {
            h = h * 31 + (o[i] == null ? 0 : o[i].hashCode());
        }
        return h;
    }

    public static boolean contains(String[] s, String s1) {
        for (int i = 0; i < s.length; ++i) {
            if (s[i] == null || s[i] != s1 && !s[i].equals(s1)) continue;
            return true;
        }
        return false;
    }

    public static boolean copyFile(File oldFile, File newFile) {
        boolean result = false;
        if (oldFile != null && newFile != null && oldFile.exists() && !oldFile.equals(newFile)) {
            newFile = LatCore.newFile(newFile);
            FileChannel oldC = null;
            FileChannel newC = null;
            try {
                oldC = new FileInputStream(oldFile).getChannel();
                newC = new FileOutputStream(newFile).getChannel();
                newC.transferFrom(oldC, 0L, oldC.size());
                if (oldC != null) {
                    oldC.close();
                }
                if (newC != null) {
                    newC.close();
                }
                result = true;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return result;
    }

    public static boolean deleteFile(File dir) {
        if (!dir.exists()) {
            return false;
        }
        if (dir.isFile()) {
            return dir.delete();
        }
        String[] files = dir.list();
        for (int i = 0; i < files.length; ++i) {
            LatCore.deleteFile(new File(dir, files[i]));
        }
        return dir.delete();
    }
}

