/*
 * Decompiled with CFR 0.152.
 */
package latmod.core.tile;

import latmod.core.mod.LC;

public enum RedstoneMode {
    DISABLED("disabled"),
    ACTIVE_HIGH("high"),
    ACTIVE_LOW("low");

    public static final RedstoneMode[] VALUES;
    public final int ID = this.ordinal();
    public final String uname;

    private RedstoneMode(String s) {
        this.uname = s;
    }

    public boolean cancel(boolean b) {
        if (this == DISABLED) {
            return false;
        }
        if (this == ACTIVE_HIGH && !b) {
            return true;
        }
        return this == ACTIVE_LOW && b;
    }

    public RedstoneMode next() {
        return VALUES[(this.ID + 1) % VALUES.length];
    }

    public RedstoneMode prev() {
        int id = this.ID - 1;
        if (id < 0) {
            id = VALUES.length - 1;
        }
        return VALUES[id];
    }

    public String getText() {
        return LC.mod.translate("redstonemode." + this.uname, new Object[0]);
    }

    public String getTitle() {
        return LC.mod.translate("redstonemode", new Object[0]);
    }

    static {
        VALUES = RedstoneMode.values();
    }
}

