/*
 * Decompiled with CFR 0.152.
 */
package latmod.core.mod.cmd;

import latmod.core.LMPlayer;
import latmod.core.LatCoreMC;
import latmod.core.cmd.CommandLM;
import latmod.core.cmd.CommandLevel;
import latmod.core.mod.LCConfig;
import latmod.core.mod.cmd.CommandBaseLC;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.util.EnumChatFormatting;

public class CmdLMFriends
extends CommandBaseLC {
    public CmdLMFriends() {
        super("friendsLM", CommandLevel.ALL);
    }

    @Override
    public void printHelp(ICommandSender ics) {
        this.printHelpLine(ics, "[gui]");
        this.printHelpLine(ics, "add <player>");
        this.printHelpLine(ics, "rem <player>");
    }

    @Override
    public int func_82362_a() {
        return 0;
    }

    @Override
    public boolean func_71519_b(ICommandSender ics) {
        return !LCConfig.General.disableLMFriendsCommand;
    }

    @Override
    public String[] getSubcommands(ICommandSender ics) {
        return new String[]{"help", "add", "rem", "list"};
    }

    @Override
    public CommandLM.NameType getUsername(String[] args, int i) {
        if (i == 1 && CmdLMFriends.isArg(args, 0, "add", "rem")) {
            return CommandLM.NameType.OFF;
        }
        return CommandLM.NameType.NONE;
    }

    @Override
    public String[] getTabStrings(ICommandSender ics, String[] args, int i) {
        if (i == 0) {
            return this.getSubcommands(ics);
        }
        if (i == 1 && CmdLMFriends.isArg(args, 0, "list")) {
            return new String[]{"friends"};
        }
        return super.getTabStrings(ics, args, i);
    }

    @Override
    public String onCommand(ICommandSender ics, String[] args) {
        EntityPlayerMP ep = CmdLMFriends.func_71521_c((ICommandSender)ics);
        LMPlayer owner = CmdLMFriends.getLMPlayer(ep);
        if (args == null || args.length == 0 || args[0].equals("gui")) {
            LatCoreMC.openGui((EntityPlayer)ep, "lmc.friends", null);
            return null;
        }
        if (args[0].equals("help")) {
            this.printHelp((ICommandSender)ep);
            return null;
        }
        return CmdLMFriends.onStaticCommand(ep, owner, args);
    }

    public static String onStaticCommand(EntityPlayerMP ep, LMPlayer owner, String[] args) {
        CmdLMFriends.checkArgs(args, 1);
        if (args[0].equals("list")) {
            CmdLMFriends.checkArgs(args, 2);
            if (args[1].equals("friends")) {
                if (owner.friends.isEmpty()) {
                    return FINE + "No friends added";
                }
                LatCoreMC.printChat((ICommandSender)ep, "Your friends:");
                for (int i = 0; i < owner.friends.size(); ++i) {
                    LMPlayer p = owner.friends.get(i);
                    EnumChatFormatting col = EnumChatFormatting.GREEN;
                    if (p.isFriendRaw(owner) && !owner.isFriendRaw(p)) {
                        col = EnumChatFormatting.GOLD;
                    }
                    if (!p.isFriendRaw(owner) && owner.isFriendRaw(p)) {
                        col = EnumChatFormatting.BLUE;
                    }
                    LatCoreMC.printChat((ICommandSender)ep, col + "[" + i + "]: " + p.username);
                }
            }
            return null;
        }
        LMPlayer p = null;
        if (args.length >= 2 && CmdLMFriends.isArg(args, 0, "add", "rem")) {
            p = CmdLMFriends.getLMPlayer(args[1]);
        }
        if (p != null && p.equals(owner)) {
            return "Invalid player!";
        }
        CmdLMFriends.checkArgs(args, 2);
        if (args[0].equals("add")) {
            if (!owner.friends.contains(p)) {
                owner.friends.add(p);
                return CmdLMFriends.changed(owner, p, "Added " + p.username + " as friend");
            }
            return p.username + " is already added as friend!";
        }
        if (args[0].equals("rem")) {
            if (owner.friends.contains(p)) {
                owner.friends.remove(p);
                return CmdLMFriends.changed(owner, p, "Removed " + p.username + " from friends");
            }
            return p.username + " is not added as friend!";
        }
        return null;
    }

    private static String changed(LMPlayer o, LMPlayer p, String s) {
        o.sendUpdate("latcore.groups", true);
        if (p != null) {
            p.sendUpdate("latcore.groups", true);
        }
        return FINE + s;
    }
}

